<?php
/**
 * Single Product Meta
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.7.0
 */

use Automattic\WooCommerce\Enums\ProductType;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $post, $product;

//$cat_count = sizeof( get_the_terms( $post->ID, 'product_cat' ) );
//$tag_count = sizeof( get_the_terms( $post->ID, 'product_tag' ) );

$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );

?>
<div class="product_meta clearfix">
	
    <div class="product_meta_inside">
    
		<?php do_action( 'woocommerce_product_meta_start' ); ?>
    
		<?php if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( ProductType::VARIABLE ) ) ) : ?>
    
		<span class="sku_wrapper"><?php esc_html_e( 'SKU:', 'woocommerce' ); ?> <span class="sku"><?php echo ( $sku = $product->get_sku() ) ? $sku : esc_html__( 'N/A', 'woocommerce' ); ?></span></span>
    
        <?php endif; ?>
    
        <?php //echo $product->get_categories( ', ', '<span class="posted_in">' . _n( 'Category:', 'Categories:', $cat_count, 'woocommerce' ) . ' ', '.</span>' ); ?>

        <?php echo '<span class="posted_in">' . esc_html__( 'Categories: ' , 'woocommerce' ) . wc_get_product_category_list( $post->ID, 'product_cat' ) . '</span>'; ?>
    
        <?php //echo $product->get_tags( ', ', '<span class="tagged_as">' . _n( 'Tag:', 'Tags:', $tag_count, 'woocommerce' ) . ' ', '.</span>' ); ?>

        <?php echo '<span class="tagged_as">' . esc_html__( 'Tags: ' , 'woocommerce' ) . wc_get_product_tag_list( $post->ID, ', ' ) . '</span>'; ?>
    
        <?php do_action( 'woocommerce_product_meta_end' ); ?>
        
    </div>
    
    <div class="product_share">
		
        <ul class="team-skills changed  ">
        	<li>
            	<span class="social-icons">
                	<a href="http://www.facebook.com/sharer.php?s=100&p&#91;url&#93;=<?php the_permalink(); ?>&p&#91;title&#93;=<?php the_title(); ?>" class="facebook ntip" alt="Share on Facebook" original-title="Share on Facebook"><i class="fab fa-facebook-f"></i></a>
                </span>
            </li>
            <li>
            	<span class="social-icons">
                	<a href="http://twitter.com/home?status=<?php the_title(); ?> <?php the_permalink(); ?>" class="twitter ntip" alt="Share on Twitter" original-title="Share on Twitter"><i class="fab fa-twitter"></i></a>
                </span>
            </li>
            <li>
            	<span class="social-icons">
                	<a href="https://plus.google.com/share?url=<?php the_permalink(); ?>" onclick="javascript:window.open(this.href,
  '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;" class="gplus ntip" alt="Share on Gplus" original-title="Share on Gplus"><i class="fab fa-google-plus-g"></i></a>
                </span>
            </li>
            <li>
            	<span class="social-icons">
                	<a href="http://pinterest.com/pin/create/button/?url=<?php echo urlencode(get_permalink()); ?>&amp;description=<?php echo urlencode($post->post_title); ?>&amp;media=<?php echo urlencode($image[0]); ?>" class="pinterest ntip" alt="Share on Pinterest" original-title="Share on Pinterest"><i class="fab fa-pinterest"></i></a>
                </span>
            </li>
        </ul>
        
	</div>

</div>

