<?php
/**
 * Rocky Theme Updater
 *
 * @package EDD Sample Theme
 */

// Includes the files needed for the theme updater
if ( ! class_exists( 'Nimva_Theme_Updater_Admin' ) ) {
	include dirname( __FILE__ ) . '/theme-updater-admin.php';
}

// Loads the updater classes
$updater = new Nimva_Theme_Updater_Admin(
	// Config settings
	array(
		'remote_api_url' => 'https://rockythemes.com', // Site where EDD is hosted
		'item_name'      => 'Nimva 3 Theme', // Name of theme
		'theme_slug'     => 'nimva', // Theme slug
		'version'        => '3.4.6', // The current version of this theme
		'author'         => 'RockyThemes', // The author of this theme
		'download_id'    => '2635', // Optional, used for generating a license renewal link
		'renew_url'      => '', // Optional, allows for a custom license renewal link
		'beta'           => false, // Optional, set to true to opt into beta versions
		'item_id'        => '2635',
	),
	// Strings
	array(
		'theme-license'             => __( 'Theme License', 'Nimva' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'Nimva' ),
		'license-key'               => __( 'License Key', 'Nimva' ),
		'license-action'            => __( 'License Action', 'Nimva' ),
		'deactivate-license'        => __( 'Deactivate License', 'Nimva' ),
		'activate-license'          => __( 'Activate License', 'Nimva' ),
		'status-unknown'            => __( 'License status is unknown.', 'Nimva' ),
		'renew'                     => __( 'Renew?', 'Nimva' ),
		'unlimited'                 => __( 'unlimited', 'Nimva' ),
		'license-key-is-active'     => __( 'License key is active.', 'Nimva' ),
		/* translators: the license expiration date */
		'expires%s'                 => __( 'Expires %s.', 'Nimva' ),
		'expires-never'             => __( 'Lifetime License.', 'Nimva' ),
		/* translators: 1. the number of sites activated 2. the total number of activations allowed. */
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'Nimva' ),
		'activation-limit'          => __( 'Your license key has reached its activation limit.', 'Nimva' ),
		/* translators: the license expiration date */
		'license-key-expired-%s'    => __( 'License key expired %s.', 'Nimva' ),
		'license-key-expired'       => __( 'License key has expired.', 'Nimva' ),
		/* translators: the license expiration date */
		'license-expired-on'        => __( 'Your license key expired on %s.', 'Nimva' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'Nimva' ),
		'license-is-inactive'       => __( 'License is inactive.', 'Nimva' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'Nimva' ),
		'license-key-invalid'       => __( 'Invalid license.', 'Nimva' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'Nimva' ),
		/* translators: the theme name */
		'item-mismatch'             => __( 'This appears to be an invalid license key for %s.', 'Nimva' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'Nimva' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'Nimva' ),
		'error-generic'             => __( 'An error occurred, please try again.', 'Nimva' ),
	)
);
