<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />

<title><?php bloginfo('name'); ?> <?php wp_title(' - ', true, 'left'); ?></title>
<!--[if lte IE 8]>
	<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/js/html5shiv.js"></script>
<![endif]-->

<?php global $data, $woocommerce; ?>
<?php if($data['favicon']): ?>
	<link rel="shortcut icon" href="<?php echo $data['favicon']; ?>" type="image/x-icon" />
<?php endif; ?>
   
	<?php 
	if($data['responsive']){ 
		$responsive = 'true';
	?>      
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
        
	<?php 
	} 
	else{
		$responsive = 'false';
	}
	?>
<?php wp_head(); ?> 

<style type="text/css">  
	<?php
		ob_start();
		include_once get_template_directory() . '/css/additional_styles.php';
		$dynamic_css = ob_get_contents();
		ob_get_clean();
		echo less_css($dynamic_css);
	?>

</style>

<?php /* if(is_page_template('page-contact.php') && $data['gmap_address']) { 
}
*/
?>

<?php echo $data['head_code']; ?>

<?php echo $data['tracking_code']; ?>

<?php
$current_post_id = get_queried_object_id();
$header_layout = (get_post_meta($current_post_id, 'pyre_header_version', true) != NULL) ? get_post_meta($current_post_id, 'pyre_header_version', true) : $data['header_layout'] ;
if( $header_layout == 'default' ) $header_layout = $data['header_layout'];

$site_page_layout = (!is_archive() && get_post_meta($current_post_id, 'pyre_page_layout', true) != NULL) ? get_post_meta($current_post_id, 'pyre_page_layout', true) : $data['site_layout'];
if( $site_page_layout == 'default' ) { $site_page_layout = $data['site_layout']; }
?>
 <style type="text/css" id="ss">
</style>	
<link rel="stylesheet" type="text/css" id="skins">
</head>

<body <?php body_class($bclass); ?> data-responsive="<?php echo $responsive; ?>" data-loading-effect="<?php echo ((isset($data['loading_effect']) && $data['loading_effect']==1) ? 'true' : 'false'); ?>" data-layout="<?php echo strtolower($site_page_layout); ?>" data-layout-width="<?php echo ($data['custom_width'] && $data['custom_width'] != '') ? $data['custom_width'] : $data['layout_width']; ?>" data-sticky-sidebar="<?php echo ($data['sticky_sidebar'] == 1 ? 'true' : 'false') ?>" data-sticky-footer="<?php echo ($data['sticky_footer'] ? 'true' : 'false'); ?>">

<?php 
if(isset($data['loading_effect']) && $data['loading_effect']==1) {
    nv_page_loading();
}
?>
	<?php if($data['video_bg_en'] && ( get_post_meta ( $current_post_id, 'pyre_en_video_bg', true ) != 'yes' ) ) { ?>
		

            <div id="P2" class="player video-container" data-property="{videoURL:'<?php echo $data['ytb_id']; ?>',containment:'body',autoPlay:true, showControls:false, mute:true, startAt:0, opacity: <?php echo ($data['video_opacity']/100); ?>, quality:'<?php echo $data['video_quality']; ?>'}"></div>
            <!-- End Video -->
            
			<?php 
			if(($data['video_overlay'] !='') || ($data['video_overlay_bg'] != $none_img)) { ?>
			
            	<div class="video_overlay video_bg"></div>    
                	
            <?php 
			} 
			?>
            
    <?php } ?>  
    
    <?php
	if(get_post_meta ( $current_post_id, 'pyre_en_video_bg', true ) == 'yes' && get_post_meta ( $current_post_id, 'pyre_youtube_id', true ) != '') {
		$video_id = get_post_meta ( $current_post_id, 'pyre_youtube_id', true );
		$video_opacity = (get_post_meta ( $current_post_id, 'pyre_video_opacity', true ) !='') ? get_post_meta ( $current_post_id, 'pyre_video_opacity', true ) : 100 ;
	?>
    
    	<div id="P2" class="player video-container" data-property="{videoURL:'<?php echo $video_id; ?>',containment:'body',autoPlay:true, showControls:false, mute:true, startAt:0, opacity: <?php echo ($video_opacity/100); ?>, quality:'default'}"></div>
    
    <?php
		if(get_post_meta ( $current_post_id, 'pyre_video_bg_overlay', true )!='0' || get_post_meta ( $current_post_id, 'pyre_video_bg_overlay_color', true ) != '') {
			$video_overlay_bg = (get_post_meta ( $current_post_id, 'pyre_video_bg_overlay', true )!='0' ) ? 'background-image: url('. get_template_directory_uri().'/images/overlay/'.get_post_meta ( $current_post_id, 'pyre_video_bg_overlay', true).');'  : '';
			$video_overlay_op = (get_post_meta ( $current_post_id, 'pyre_video_overlay_opacity', true ) != '') ? get_post_meta ( $current_post_id, 'pyre_video_overlay_opacity', true ) : 100;
			$video_overlay_color = (get_post_meta ( $current_post_id, 'pyre_video_bg_overlay_color', true ) != '') ? 'background-color: '.get_post_meta ( $current_post_id, 'pyre_video_bg_overlay_color', true ).';' : '';
		?>
         	<div class="video_overlay video_bg" style=" <?php echo $video_overlay_bg . $video_overlay_color; ?> opacity: <?php echo ( $video_overlay_op/100 ); ?>; filter: alpha(opacity=<?php echo ($video_overlay_op/100); ?>);"></div> 
        <?php
		}
	}
	?>
      
    <div id="wrapper" class="clearfix">
    	
    <?php if(!is_page_template('page-blank.php')): ?>
    <!-- ============================================
            Top Bar
        ============================================= -->
        <?php if ( (( $data['header_left_content'] !='Leave Empty' ) ||  ( $data['header_right_content'] != 'Leave Empty' )) && ( get_post_meta($current_post_id, 'pyre_top_bar', true) != 'no' ) ){ ?>
        <div id="top-bar">
            
            <div class="container clearfix">            	
        
                <?php
				if($data['header_left_content'] !='Leave Empty'){
				?>
                    <div class="leftalign">
                        <?php	 
                        if($data['header_left_content'] =='Contact Info') { 
                            get_template_part('functions/template/contact-info');
                        } 
                        elseif ($data['header_left_content'] =='Social Links') {
                            get_template_part('functions/template/social-links');
                        }
						elseif ($data['header_left_content'] =='Top Menu') {
                            get_template_part('functions/template/top-menu');
                        }
                        ?>
                    </div>    
                <?php    
				}
				?>           
                
                <?php if ( $data['header_right_content'] != 'Leave Empty' ) { ?>
                	<div class="rightalign">
                        <?php	 
                        if($data['header_right_content'] =='Contact Info') { 
                            get_template_part('functions/template/contact-info');
                        } 
                        elseif ($data['header_right_content'] =='Social Links') {
                            get_template_part('functions/template/social-links');
                        }
						elseif ($data['header_right_content'] =='Top Menu') {
                            get_template_part('functions/template/top-menu');
                        }
                        ?>
                    </div>
                <?php } ?>
            
            </div>
        
        </div>  
        
        <?php
		
		}
		
		?>
        
        <!-- ============================================
            Header
        ============================================= -->
        <?php       
        if( get_post_meta($current_post_id, 'pyre_en_header', true) != 'no' ) {
        ?>
            <div id="header" data-header-resize="<?php echo ($data['header_resize'] != 0 ? 'true' : 'false'); ?>" data-header-version="header_<?php echo $header_layout; ?>" data-header-width="<?php echo strtolower($data['header_width']); ?>" data-transparent-header="<?php echo (get_post_meta($current_post_id, 'pyre_transparent_header', true) == 'yes' ? 'true' : 'false'); ?>" class="<?php echo ($data['floating_header'] ? 'sticky-header' : ''); ?> <?php echo (get_post_meta($current_post_id, 'pyre_transparent_header', true) == 'yes' ? 'transparent' : ''); ?> <?php echo ($data['shadow_header'] ? 'shadow' : ''); ?>">

                <?php 
    			$header_layout = (get_post_meta($current_post_id, 'pyre_header_version', true) != NULL) ? get_post_meta($current_post_id, 'pyre_header_version', true) : $data['header_layout'] ;
    			if( $header_layout == 'default' ) $header_layout = $data['header_layout'];
    			
    			
    			if($header_layout=='v1') { 
    				get_template_part('functions/template/header-v1');		
    			}
    			elseif($header_layout=='v2') {
    				get_template_part('functions/template/header-v2');
    			}
                elseif($header_layout=='v3') {
                    get_template_part('functions/template/header-v3');
                }
                elseif($header_layout=='v4' || $header_layout=='v5') {
                    get_template_part('functions/template/header-v4');
                }            
                elseif($header_layout=='v6') {
                    get_template_part('functions/template/header-v6');
                }
    			else{
    				get_template_part('functions/template/header-v7');
    			}
    			
    			
    			?> 
                 
            </div>      
        <?php
        }
        ?>

        <?php $mob_menu_extra_class = (is_page_template ( 'page-one-full.php') ) ? 'class="one-page-template"' : ''; ?>
        <div id="mobile-menu" <?php echo $mob_menu_extra_class; ?>>
	
            <div class="container">
                <ul>
                    <?php
                    if( get_post_meta($post->ID, 'pyre_main_menu', true) != 'default' ) {
                        $main_menu = get_post_meta($post->ID, 'pyre_main_menu', true);
                    }
                    else {
                        $main_menu = '';
                    }
					
					if ( is_page_template ( 'page-one-full.php' ) ) {
						wp_nav_menu(array('walker' => new MenuWalker, 'theme_location' => 'one-page-nav', 'container' => false, 'items_wrap' => '%3$s', 'menu_class' => 'sf-menu', 'fallback_cb' =>'MenuWalker::fallback', 'walker' => new MenuWalker() ) );
					}
					else{
                        if(has_nav_menu('primary-menu')) {
                            
                            wp_nav_menu( array('theme_location' => 'primary-menu', 'menu' => $main_menu, 'container' => '', 'items_wrap' => '%3$s' ) ); 
                            
                        }
                        else {
                            echo '<li><a href="">No menu assigned!</a></li>';
                        }
						
					}
                    ?>		
                </ul>
            </div>
            
        </div>
        
        <div id="content">               
    		<?php 
    		if($data['en_title_breadcrumb']){		
    			echo nv_page_title_breadcrumb();			
    		}		            
     endif;   
	 ?>