<?php

class PyreThemeFrameworkMetaboxes {
	
	public function __construct()
	{
		add_action('add_meta_boxes', array($this, 'add_meta_boxes'));
		add_action('save_post', array($this, 'save_meta_boxes'));
		add_action('admin_enqueue_scripts', array($this, 'admin_script_loader'));
	}

	// Load backend scripts
	function admin_script_loader() {
		global $pagenow;
		if (is_admin() && ($pagenow=='post-new.php' || $pagenow=='post.php')) {
	    	wp_register_script('creativo_cookie', get_template_directory_uri().'/js/jquery.biscuit.js');
	    	wp_register_script('creativo_upload', get_template_directory_uri().'/js/upload.js');    	
			wp_register_script('creativo_colorpicker', get_bloginfo('template_directory').'/inc/js/colorpicker.js');
	    	wp_enqueue_script('creativo_cookie');		
	    	wp_enqueue_script('creativo_upload');
			wp_enqueue_script('creativo_colorpicker');
	    	wp_enqueue_script('media-upload');
	    	wp_enqueue_script('thickbox');
	   		wp_enqueue_style('thickbox');
			wp_enqueue_style('creativo_colorpicker', get_bloginfo('template_directory').'/inc/css/colorpicker.css');
			wp_enqueue_script( 'nv-page-tabs', get_template_directory_uri().'/js/page-tabs.js', array(), '6', TRUE );
			wp_enqueue_style('creativo_admin_extra', get_bloginfo('template_directory').'/js/admin-extra.css');
		}
	}
	
	public function add_meta_boxes()
	{
		// Post Options - done
		$this->add_meta_box('post_options', __('Advanced Customization','Nimva'), 'post');
		/*
		$this->add_meta_box('post_options', __('General Options','Nimva'), 'post');
		$this->add_meta_box('page_slider', __('Slider Option','Nimva'), 'post');
		$this->add_meta_box('video', __('Video Options','Nimva'), 'post');
		$this->add_meta_box('video_background', __('Video Background','Nimva'), 'post');	
		$this->add_meta_box('custom_style', __('Custom Styling','Nimva'), 'post');	
		*/

		// Page Options - done
		$this->add_meta_box('page_options', __('Advanced Customization','Nimva'), 'page');
		/*
		$this->add_meta_box('page_options', __('General Options','Nimva'), 'page');		
		$this->add_meta_box('page_slider', __('Slider Option','Nimva'), 'page');
		$this->add_meta_box('video_background', __('Video Background','Nimva'), 'page');	
		$this->add_meta_box('custom_style', __('Custom Styling','Nimva'), 'page');
		*/

		// Portfolio Options - done	
		$this->add_meta_box('portfolio_options', __('Advanced Customization','Nimva'), 'creativo_portfolio');
		/*
		$this->add_meta_box('general', __('General Options','Nimva'), 'creativo_portfolio');
		$this->add_meta_box('page_slider', __('Slider Option','Nimva'), 'creativo_portfolio');		
		$this->add_meta_box('video', __('Video Options','Nimva'), 'creativo_portfolio');
		$this->add_meta_box('portfolio_details', __('Portfolio Details','Nimva'), 'creativo_portfolio');
		$this->add_meta_box('video_background', __('Video Background','Nimva'), 'creativo_portfolio');
		$this->add_meta_box('custom_style', __('Custom Styling','Nimva'), 'creativo_portfolio');*/		

		// Product Options
		$this->add_meta_box('product_options', __('Advanced Options','Nimva'), 'product');
		
		// FAQs Options	- done		
		$this->add_meta_box('faq_options', __('FAQ Options','Nimva'), 'faq');
			
		
		// Testimonials Options	- done
		$this->add_meta_box('testimonials_options', __('Testimonial','Nimva'), 'testimonials');
		
		// Pricing Options - done
		$this->add_meta_box('pricing_options', __('Pricing Column','Nimva'), 'pricing');
		
		// Clients Options - done
		$this->add_meta_box('clients_options', __('Client','Nimva'), 'clients');	
		
		// Employees Options - done	
		$this->add_meta_box('employee_options', __('Employee','Nimva'), 'employees');	
		
	}
	
	public function add_meta_box($id, $label, $post_type)
	{
	    add_meta_box( 
	        'pyre_' . $id,
	        $label,
	        array($this, $id),
	        $post_type
	    );
	}
	
	public function save_meta_boxes($post_id)
	{
		if(defined( 'DOING_AUTOSAVE') && DOING_AUTOSAVE) {
			return;
		}
		
		foreach($_POST as $key => $value) {
			if(strstr($key, 'pyre_')) {
				update_post_meta($post_id, $key, $value);
			}
		}
	}

	/**
	 * Handle rendering options.
	 *
	 * @access public
	 * @param array  $requested_tabs The requested tabs.
	 * @param string $post_type      The post-type.
	 */
	public function render_option_tabs( $requested_tabs, $post_type = 'default' ) {
		$screen = get_current_screen();

		$tabs_names = array(						
			
			'page_options'           => esc_html__( 'General Options', 'Nimva' ),
			'header_options'           => esc_html__( 'Header Options', 'Nimva' ),
			'page_slider'           => esc_html__( 'Slider Option', 'Nimva' ),
			'post_options'           => esc_html__( 'General Options', 'Nimva' ),
			'video'           => esc_html__( 'Video Post', 'Nimva' ),
			'video_background'           => esc_html__( 'Video Background', 'Nimva' ),
			
			'portfolio_general'      => esc_html__( 'Portfolio Options', 'Nimva' ),
			'portfolio_details'		 => esc_html__( 'Portfolio Details', 'Nimva' ),			
			'video_options'          => esc_html__( 'Video Options', 'Nimva' ),
			'footer_options'           => esc_html__( 'Footer Options', 'Nimva' ),
			'custom_style'           => esc_html__( 'Custom Styling', 'Nimva' ),
			'faq'           => esc_html__( 'FAQ', 'Nimva' ),
			'testimonials'           => esc_html__( 'Testimonial Details', 'Nimva' ),
			'pricing'         => esc_html__( 'Pricing Column Details', 'Nimva' ),
			'employee'         => esc_html__( 'Employee Details', 'Nimva' ),	
			'clients'    => esc_html__( 'Client Details', 'Nimva' ),
			'product'    => esc_html__( 'Product Options', 'Nimva' )		
		);
		?>

		<div class="creativo_customization">

			<ul class="cr_metabox_tabs">

				<?php foreach ( $requested_tabs as $key => $tab_name ) : ?>
					
					<li><a href="<?php echo $tab_name; ?>"><?php echo $tabs_names[ $tab_name ]; ?></a></li>
					
				<?php endforeach; ?>

			</ul>

			<div class="cr_metabox">

				<?php foreach ( $requested_tabs as $key => $tab_name ) : ?>
					<div class="pyre_metabox_tab" id="pyre_tab_<?php echo $tab_name; ?>">
						<?php require_once( 'metaboxes/' . $tab_name . '.php' ); ?>
					</div>
				<?php endforeach; ?>

			</div>

			<div class="clear"></div>

		</div>
		<?php

	}	

	public function post_options() {
		$this->render_option_tabs( array( 'header_options', 'post_options', 'page_slider', 'video', 'video_background', 'footer_options', 'custom_style' ) );
	}

	public function page_options() {
		$this->render_option_tabs( array( 'header_options', 'page_options', 'page_slider', 'video_background', 'footer_options', 'custom_style' ) );
	}

	public function portfolio_options() {
		$this->render_option_tabs( array( 'header_options','portfolio_general', 'portfolio_details', 'page_slider', 'video', 'video_background', 'footer_options', 'custom_style' ) );
	}

	public function faq_options() {
		$this->render_option_tabs( array( 'faq') );
	}

	public function testimonials_options() {
		$this->render_option_tabs( array( 'testimonials') );
	}

	public function pricing_options() {
		$this->render_option_tabs( array( 'pricing') );
	}

	public function employee_options() {
		$this->render_option_tabs( array( 'employee') );
	}

	public function clients_options() {
		$this->render_option_tabs( array( 'clients') );
	}

	public function product_options() {
		$this->render_option_tabs( array( 'header_options','product') );
	}
	
	public function text($id, $label, $desc = '')
	{
		global $post;
		
		$html = '';
		$html .= '<div class="pyre_metabox_field">';
			$html .= '<div class="desc_field">';	
				$html .= '<label for="pyre_' . $id . '">';
				$html .= $label;
				$html .= '</label>';
				if($desc) {
					$html .= '<p>' . $desc . '</p>';
				}
			$html .= '</div>';
			$html .= '<div class="field">';
				$html .= '<input type="text" id="pyre_' . $id . '" name="pyre_' . $id . '" value="' . get_post_meta($post->ID, 'pyre_' . $id, true) . '" />';
				
			$html .= '</div>';
		$html .= '</div>';
		
		echo $html;
	}
	
	public function select($id, $label, $options, $desc = '')
	{
		global $post;
		
		$html = '';
		$html .= '<div class="pyre_metabox_field">';
			$html .= '<div class="desc_field">';
				$html .= '<label for="pyre_' . $id . '">';
				$html .= $label;
				$html .= '</label>';
				if($desc) {
					$html .= '<p>' . $desc . '</p>';
				}
			$html .= '</div>';
			$html .= '<div class="field">';
				$html .= '<select id="pyre_' . $id . '" name="pyre_' . $id . '">';
				foreach($options as $key => $option) {
					if(get_post_meta($post->ID, 'pyre_' . $id, true) == $key) {
						$selected = 'selected="selected"';
					} else {
						$selected = '';
					}
					
					$html .= '<option ' . $selected . 'value="' . $key . '">' . $option . '</option>';
				}
				$html .= '</select>';
				
			$html .= '</div>';
		$html .= '</div>';
		
		echo $html;
	}

	public function textarea($id, $label, $desc = '')
	{
		global $post;

		$html = '';
		$html .= '<div class="pyre_metabox_field">';
			$html .= '<div class="desc_field">';
				$html .= '<label for="pyre_' . $id . '">';
				$html .= $label;
				$html .= '</label>';
				if($desc) {
					$html .= '<p>' . $desc . '</p>';
				}
			$html .= '</div>';
			$html .= '<div class="field">';
				$html .= '<textarea cols="120" rows="10" id="pyre_' . $id . '" name="pyre_' . $id . '">' . get_post_meta($post->ID, 'pyre_' . $id, true) . '</textarea>';				
			$html .= '</div>';
		$html .= '</div>';
		
		echo $html;
	}
	
	public function info($desc = '')
	{
		global $post;

		$html = '';
		$html = '';
		$html .= '<div class="pyre_metabox_field">';
			//$html .= '<label>&nbsp;</label>';			
			$html .= '<div class="field informational">';				
					$html .= '<p>' . $desc . '</p>';				
			$html .= '</div>';
		$html .= '</div>';
		
		echo $html;
	}

	public function upload($id, $label, $desc = '')
	{
		global $post;

		$html = '';
		$html .= '<div class="pyre_metabox_field">';
			$html .= '<div class="desc_field">';
				$html .= '<label for="pyre_' . $id . '">';
				$html .= $label;
				$html .= '</label>';
				if($desc) {
					$html .= '<p>' . $desc . '</p>';
				}
			$html .= '</div>';
			$html .= '<div class="field">';
			    $html .= '<input name="pyre_' . $id . '" class="upload_field" id="pyre_' . $id . '" type="text" value="' . get_post_meta($post->ID, 'pyre_' . $id, true) . '" style="width:60%;" />';
			    $html .= '<input class="cr_upload_button" type="button" value="'.__('Browse','Nimva').'" />';
				
			$html .= '</div>';
		$html .= '</div>';
		
		echo $html;
	}
	
	public function colorpicker($id, $label, $desc = '')
	{
		global $post;

		$html = '';
		$html = '';
		$html .= '<div class="pyre_metabox_field">';
			$html .= '<div class="desc_field">';
				$html .= '<label for="pyre_' . $id . '">';
					$html .= $label;
				$html .= '</label>';
				if($desc) {
					$html .= '<p>' . $desc . '</p>';
				}
			$html .= '</div>';		
			$html .= '<div class="field">';
			    $html .= '<div id="pyre_' . $id . '_picker" class="colorSelector" ><div></div></div>';
			    $html .= '<input type="text" id="pyre_' . $id . '" name="pyre_' . $id . '" value="' . get_post_meta($post->ID, 'pyre_' . $id, true) . '" style="width:80px; margin-left:5px;" />';
				
				//$html .= '<input name="'. $field['id'] .'" id="'. $field['id'] .'" type="text" value="'. $meta .'" />';
				
				?>
                <script type="text/javascript" language="javascript">
            		jQuery(document).ready(function(){
            			console.log('#pyre_<?php echo $id; ?>_picker');
            			//Color Picker
    				    //jQuery('#pyre_<?php echo $id; ?>_picker').children('div').css('backgroundColor', '<?php echo get_post_meta($post->ID, 'pyre_' . $id, true); ?>');    
            			jQuery('#pyre_<?php echo $id; ?>_picker').ColorPicker({
            				color: '<?php echo $meta; ?>',
            				onShow: function (colpkr) {
            					jQuery(colpkr).fadeIn(500);
            					return false;
            				},
            				onHide: function (colpkr) {
            					jQuery(colpkr).fadeOut(500);
            					return false;
            				},
            				onChange: function (hsb, hex, rgb) {
            					//jQuery(this).css('border','1px solid red');
            					jQuery('#pyre_<?php echo $id; ?>_picker').children('div').css('backgroundColor', '#' + hex);
            					jQuery('#pyre_<?php echo $id; ?>_picker').next('input').attr('value','#' + hex);
        					}
    				    });
                    });
        		</script>
                <?php				
			$html .= '</div>';
		$html .= '</div>';
		
		echo $html;
	}
	
}

$metaboxes = new PyreThemeFrameworkMetaboxes;