<?php
function extra_vc_style() {
    wp_enqueue_style( 'vc_style' , get_template_directory_uri() . '/css/vc_style.css' );
}

add_action( 'wp_enqueue_scripts', 'extra_vc_style', 15 );

#-----------------------------------------------------------------#
# Nimva Page Loading Function
#-----------------------------------------------------------------#
if (!function_exists('nv_page_loading')) {
    
    function nv_page_loading() {
        
        global $data; 
        $output = '';      
        
        $output .= '<div id="page_loading_effect" data-disable-mobile="1" data-disable-fade-on-click="0" data-effect="standard" data-method="standard">';                 
            $output .= '<div class="load_symbol">';
                $output .= '<div class="minimal_icon">';
                    $output .= '<div class="spinner">';
                        $output .= '<div class="right-side"><div class="bar"></div></div>';
                        $output .= '<div class="left-side"><div class="bar"></div></div>';
                    $output .= '</div>';
                    $output .= '<div class="spinner color-2">';
                        $output .= '<div class="right-side"><div class="bar"></div></div>';
                        $output .= '<div class="left-side"><div class="bar"></div></div>';
                    $output .= '</div>';
                $output .= '</div>';                     
           $output .= '</div>';
        $output .= '</div>';
        
        echo $output;
    }    
}

if(!function_exists('nv_page_title_breadcrumb')) {
    function nv_page_title_breadcrumb() {
        global $data, $post;
        
        if( is_page() && !is_front_page() && !is_singular('creativo_portfolio') && get_post_meta($post->ID, 'pyre_page_title', true)!='hide' && $data['tb_pages_ds'] != '1'): ?>
        
            <div id="page-title">
            
                <div class="page_title_inner">
                
                    <div class="container clearfix">
                    
                        <h2><?php the_title(); ?></h2>
                        
                        <?php 
                        if($data['en_breadcrumb']){
                            nimva_breadcrumb();                                     
                        }
                        ?>
                        
                        <?php if ($data['title_breadcrumb_right_side'] != 'Leave Empty'): ?>
                            <div class="searchtop-meta">                                
                                <?php 
                                if($data['title_breadcrumb_right_side'] == 'Social Links') get_template_part('functions/template/social-links'); 
                                elseif($data['title_breadcrumb_right_side'] == 'Search Box') get_search_form();
                                else get_template_part('functions/template/contact-info');                              
                                ?>                              
                            </div>
                        <?php endif; ?>    
                        
                    </div>
                    
                </div>  
                  
            </div>
        
        <?php endif; 
        
        $spb = false;       
        if(class_exists('Woocommerce') && is_product() ) $spb = true;

        if ( is_singular('post') && get_post_meta($post->ID, 'pyre_page_title', true)!='hide' && $data['tb_posts_ds'] != '1') :              
            ?>
            <div id="page-title">            
                <div class="page_title_inner ">                    
                    <div class="container clearfix">                        
                        <h2><?php the_title(); ?></h2>                            
                        <?php 
                        if($data['en_breadcrumb']){
                            nimva_breadcrumb();                                     
                        }
                        ?>                            
                        <?php if($data['blog_pn_nav']) { ?>
                            <div id="portfolio-navigation" class="clearfix">
                                <div class="port-nav-next">                         
                                    <?php next_post_link('%link', '<i class="fa fa-angle-left"></i>'); ?>
                                </div>
                                <div class="port-nav-prev">    
                                    <?php previous_post_link('%link', '<i class="fa fa-angle-right"></i>'); ?>
                                </div>    
                            </div>                           
                        <?php } ?>
                    </div>                        
                </div>                        
            </div>              
        <?php               
        endif;
        
        if ( (is_single() || is_singular('creativo_portfolio') ) && !is_singular('post') && get_post_meta($post->ID, 'pyre_page_title', true)!='hide' && !$spb ) :              
            ?>
            <div id="page-title">            
                <div class="page_title_inner">                    
                    <div class="container clearfix">                        
                        <h2><?php the_title(); ?></h2>                            
                        <?php 
                        if($data['en_breadcrumb']){
                            nimva_breadcrumb();                                     
                        }
                        ?>                            
                        <?php if($data['blog_pn_nav']) { ?>
                            <div id="portfolio-navigation" class="clearfix">
                                <div class="port-nav-next">                         
                                    <?php next_post_link('%link', '<i class="fa fa-angle-left"></i>'); ?>
                                </div>
                                <div class="port-nav-prev">    
                                    <?php previous_post_link('%link', '<i class="fa fa-angle-right"></i>'); ?>
                                </div>    
                            </div>                           
                        <?php } ?>
                    </div>                        
                </div>                        
            </div>              
        <?php               
        endif;
        
        if( ( class_exists( 'Woocommerce' ) && is_woocommerce()  ) || ( is_tax( 'product_cat' ) ||  is_tax( 'product_tag' ) ) ) {
        ?>
            <div id="page-title">
        
                <div class="page_title_inner">
                
                    <div class="container clearfix">
                    
                        <h2>
                            <?php 
                            if(!is_product()) woocommerce_page_title(true);
                            //else the_title();
                            ?>
                        </h2>
                        <?php
                        woocommerce_breadcrumb(array(
                            'wrap_before' => '<ul class="breadcrumbs">',
                            'wrap_after' => '</ul>',
                            'before' => '<li>',
                            'after' => '</li>',
                            'delimiter' => '',
                            'home'        => _x( '<i class="fa fa-home"></i>', 'breadcrumb', 'woocommerce' ),
                        ));
                        ?>
                        
                        <?php if ($data['title_breadcrumb_right_side'] != 'Leave Empty'): ?>
                            <?php if( !is_product() ): ?>        
                                <div class="searchtop-meta">                                
                                    <?php 
                                    if($data['title_breadcrumb_right_side'] == 'Social Links') get_template_part('functions/template/social-links'); 
                                    elseif($data['title_breadcrumb_right_side'] == 'Search Box') get_product_search_form();
                                    else get_template_part('functions/template/contact-info');                              
                                    ?>                              
                                </div>
                             <?php else: ?>
                                <div id="portfolio-navigation" class="clearfix">
                                    <div class="port-nav-next">                         
                                        <?php next_post_link('%link', '<i class="fa fa-angle-left"></i>'); ?>
                                    </div>
                                    <div class="port-nav-prev">    
                                        <?php previous_post_link('%link', '<i class="fa fa-angle-right"></i>'); ?>
                                    </div>    
                                </div>     
                             <?php endif; ?>        
                        <?php endif; ?>
                        
                    </div>
                </div>
            </div>            
        <?php
        }
        
        if(is_archive() && ( class_exists( 'Woocommerce' ) && !is_woocommerce() ) &&  !get_query_var('portfolio_category') && !get_query_var('faq_category')) {

        ?>
            <div id="page-title">
                <div class="page_title_inner">
                    <div class="container clearfix">
                        <h2>
                            <?php if ( is_day() ) : ?>
                                <?php printf( __( 'Daily Archives: %s', 'twentyeleven' ), '<span>' . get_the_date() . '</span>' ); ?>
                            <?php elseif ( is_month() ) : ?>
                                <?php printf( __( 'Monthly Archives: %s', 'twentyeleven' ), '<span>' . get_the_date( _x( 'F Y', 'monthly archives date format', 'twentyeleven' ) ) . '</span>' ); ?>
                            <?php elseif ( is_year() ) : ?>
                                <?php printf( __( 'Yearly Archives: %s', 'twentyeleven' ), '<span>' . get_the_date( _x( 'Y', 'yearly archives date format', 'twentyeleven' ) ) . '</span>' ); ?>
                            <?php elseif ( is_author() ) : ?> 
                                <?php
                                if(have_posts() ) {                                 
                                    the_post();
                                    ?>                
                                    <?php _e('Posts by: ','Nimva'); echo get_the_author(); ?>
                                    <?php
                                    rewind_posts();
                                }
                                ?>  
                            <?php elseif ( is_tag() ) : ?> 
                                    <?php _e('Tags: ', 'Nimva'); single_cat_title(); ?>     
                            <?php else : ?>
                                <?php _e('Category: ', 'Nimva'); single_cat_title(); ?>
                            <?php endif; ?>
                        </h2> 
                        <?php 
                        if($data['en_breadcrumb']){
                            nimva_breadcrumb();                                     
                        }
                        ?>                                                      
                        
                        <?php if ($data['title_breadcrumb_right_side'] != 'Leave Empty'): ?>
                            <div class="searchtop-meta">                                
                                <?php 
                                if($data['title_breadcrumb_right_side'] == 'Social Links') get_template_part('functions/template/social-links'); 
                                elseif($data['title_breadcrumb_right_side'] == 'Search Box') get_search_form();
                                else get_template_part('functions/template/contact-info');                              
                                ?>                              
                            </div>
                        <?php endif; ?>
                        
                    </div>
                </div>    
            </div>
        <?php           
        }
        
        if ( is_search() && ( class_exists( 'Woocommerce' ) && !is_woocommerce() ) ) {
        ?>
            <div id="page-title">
                <div class="page_title_inner">
                    <div class="container clearfix">
                        <h2><?php echo _e('Search results for:', 'Nimva'); ?> <?php echo get_search_query(); ?></h2>
                        <?php 
                        if($data['en_breadcrumb']){
                            nimva_breadcrumb();                                     
                        }
                        ?> 
                        
                        <?php if ($data['title_breadcrumb_right_side'] != 'Leave Empty'): ?>
                            <div class="searchtop-meta">                                
                                <?php 
                                if($data['title_breadcrumb_right_side'] == 'Social Links') get_template_part('functions/template/social-links'); 
                                elseif($data['title_breadcrumb_right_side'] == 'Search Box') get_search_form();
                                else get_template_part('functions/template/contact-info');                              
                                ?>                              
                            </div>
                        <?php endif; ?>
                        
                    </div>
                </div>    
            </div>
                        
        <?php
        }
        
        if(get_query_var('portfolio_category') || get_query_var('faq_category')){
        ?>
            <div id="page-title">
                <div class="page_title_inner">
                    <div class="container clearfix">
                        <h2><?php single_cat_title(); ?></h2>
                        <?php 
                        if($data['en_breadcrumb']){
                            nimva_breadcrumb();                                     
                        }
                        ?>
                        <?php if ($data['title_breadcrumb_right_side'] != 'Leave Empty'): ?>
                            <div class="searchtop-meta">                                
                                <?php 
                                if($data['title_breadcrumb_right_side'] == 'Social Links') get_template_part('functions/template/social-links'); 
                                elseif($data['title_breadcrumb_right_side'] == 'Search Box') get_search_form();
                                else get_template_part('functions/template/contact-info');                              
                                ?>                              
                            </div>
                        <?php endif; ?>
                    </div>
                </div>    
            </div>    
        <?php
        }
        
    }
}

#-----------------------------------------------------------------#
# Nimva Get Coordinates Function
#-----------------------------------------------------------------#

if (!function_exists('get_coordinates')) {
    function get_coordinates( $address, $force_refresh = false ) {

	    $address_hash = md5( $address );

	    $coordinates = get_transient( $address_hash );

	    if ( $force_refresh || 
	    	 $coordinates === false
	    ) {

	    	$args       = array( 'address' => urlencode( $address ), 'sensor' => 'false' );
	    	$url        = add_query_arg( $args, 'http://maps.googleapis.com/maps/api/geocode/json' );
	     	$response 	= wp_remote_get( $url );

	     	if( is_wp_error( $response ) )
	     		return;

	     	$data = wp_remote_retrieve_body( $response );

	     	if( is_wp_error( $data ) )
	     		return;

			if ( $response['response']['code'] == 200 ) {

				$data = json_decode( $data );

				if ( $data->status === 'OK' ) {

				  	$coordinates = $data->results[0]->geometry->location;

				  	$cache_value['lat'] 	= $coordinates->lat;
				  	$cache_value['lng'] 	= $coordinates->lng;
				  	$cache_value['address'] = (string) $data->results[0]->formatted_address;

				  	// cache coordinates for 3 months
				  	set_transient($address_hash, $cache_value, 3600*24*30*3);
				  	$data = $cache_value;

				} elseif ( $data->status === 'ZERO_RESULTS' ) {
				  	return __( 'No location found for the entered address.', 'Nimva' );
				} elseif( $data->status === 'INVALID_REQUEST' ) {
				   	return __( 'Invalid request. Did you enter an address?', 'Nimva' );
				} else {
					return __( 'Something went wrong while retrieving your map, please ensure you have entered the short code correctly.', 'Nimva' );
				}

			} else {
			 	return __( 'Unable to contact Google API service.', 'Nimva' );
			}

	    } else {
	       // return cached results
	       $data = $coordinates;
	    }

	    return $data;

	}
}
#-----------------------------------------------------------------#
# Hex to RGBA function
#-----------------------------------------------------------------#

global $data;

if( !function_exists('hex2rgba')) {

    function hex2rgba($hex) {

    	$hex = str_replace("#", "", $hex);

       if(strlen($hex) == 3) {
          $r = hexdec(substr($hex,0,1).substr($hex,0,1));
          $g = hexdec(substr($hex,1,1).substr($hex,1,1));
          $b = hexdec(substr($hex,2,1).substr($hex,2,1));
       } else {
          $r = hexdec(substr($hex,0,2));
          $g = hexdec(substr($hex,2,2));
          $b = hexdec(substr($hex,4,2));
       }
       $rgb = array($r, $g, $b);
       //return implode(",", $rgb); // returns the rgb values separated by commas
       return $rgb; // returns an array with the rgb values
    }
}

#-----------------------------------------------------------------#
# Hex RGBA Darker function
#-----------------------------------------------------------------#

if (!function_exists('hexDarker')) {
    function hexDarker( $hex, $factor = 30 ) {
        $new_hex = '';
        if ( $hex == '' || $factor == '' ) {
            return false;
        }

        $hex = str_replace( '#', '', $hex );

        $base['R'] = hexdec( $hex[0].$hex[1] );
        $base['G'] = hexdec( $hex[2].$hex[3] );
        $base['B'] = hexdec( $hex[4].$hex[5] );


        foreach ( $base as $k => $v ) {
            $amount = $v / 100;
            $amount = round( $amount * $factor );
            $new_decimal = $v - $amount;

            $new_hex_component = dechex( $new_decimal );
            if ( strlen( $new_hex_component ) < 2 ) { $new_hex_component = "0".$new_hex_component; }
            $new_hex .= $new_hex_component;
        }

        return '#'.$new_hex;
    }
}

#-----------------------------------------------------------------#
# Fontawesome in Menus 
#-----------------------------------------------------------------#
class FontawesomeMenus{
	function fontawesome_menu( $nav ) {
        $menu = preg_replace_callback(
                            '/<li((?:[^>]+)(fa-[^ ]+ )(?:[^>]+))><a[^>]+>(.*)<\/a>/',
                            array( $this, 'fontawesome_replace' ),
                            $nav
                        );
        print $menu;
    }
    function fontawesome_replace( $a ) {
        $listitem = $a[0];
        $icon = $a[2];
        $link_text = $a[3];
        $str_noicon = str_replace( $icon, '', $listitem );
        $str = str_replace( $link_text, '<span class="megamenu-icon text-menu-icon"><i class="fa ' . trim( $icon ) . '"></i></span><span class="menu-text"> ' . $link_text . '</span>', $str_noicon );
        return $str;
    }
	function __construct() {        
        add_filter( 'wp_nav_menu' , array( $this, 'fontawesome_menu' ), 10, 2);        
    }
}

#-----------------------------------------------------------------#
# Display Menu Item Description
#-----------------------------------------------------------------#
if (!function_exists('prefix_nav_description')) {
    function prefix_nav_description( $item_output, $item, $depth, $args ) {
        if ( !empty( $item->description ) ) {
            $item_output = str_replace( $args->link_after . '</a>', '<p class="menu-item-description">' . $item->description . '</p>' . $args->link_after . '</a>', $item_output );
        }
     
        return $item_output;
    }
}
//add_filter( 'walker_nav_menu_start_el', 'prefix_nav_description', 10, 4 );

#-----------------------------------------------------------------#
# Content Strip Tags functions
#-----------------------------------------------------------------#

if (!function_exists('nv_content')) {
    function nv_content($limit, $strip_html) {
    	global $more;	

    	$test_strip_html = $strip_html;

    	if($strip_html == "true" || $strip_html == true) {
    		$test_strip_html = true;
    	}

    	if($strip_html == "false" || $strip_html == false) {
    		$test_strip_html = false;
    	}	
    	//$test_strip_html = true;
    	if($test_strip_html) {		
    		$raw_content = strip_shortcodes( strip_tags( get_the_content() ) );
    	} else {		
    		$raw_content = strip_shortcodes( get_the_content() );
    	}

    	if($raw_content) {
    		
    		$content = explode(' ', $raw_content, $limit);
    		
    		if (count($content)>=$limit) {
    			array_pop($content);
    			$content = implode(" ",$content).'...';
    		} 
    		else {
    			$content = implode(" ",$content);
    		}	
    		
    		$content = preg_replace('/\[.+\]/','', $content);
    		if(!$test_strip_html) {
    			$content = apply_filters('the_content', $content); 
    		}
    		$content = str_replace(']]>', ']]&gt;', $content);
    		
    		return $content;
    	}
    }
}


#-----------------------------------------------------------------#
# Comment Styling
#-----------------------------------------------------------------#

if( !function_exists( 'comment_style' ) ) {
    function comment_style($comment, $args, $depth) {

        $GLOBALS['comment'] = $comment; ?>
        <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
     
            <div id="comment-<?php comment_ID(); ?>" class="comment-wrap clearfix">
            	
                <div class="comment-meta">
                	<div class="comment-author vcard">
                        <span class="comment-avatar clearfix">
                            <?php echo get_avatar($comment,$size='55'); ?>
                        </span> 
                    </div>       
                </div>
                
                <div class="comment-content clearfix">
                	<div class="comment-author">
                    	<?php echo get_comment_author_link(); ?>
                        <span>
                        	<a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf(__('%1$s at %2$s', 'framework'), get_comment_date(),  get_comment_time()) ?></a> &middot; 
                            <?php edit_comment_link(__('(Edit)', 'framework'),'  ','') ?> &middot; <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
                        </span>
                    </div>
                    <?php comment_text() ?>
                </div>

<!--
                <div style=" max-width:300px; float:left">
                    <div class="comment-author vcard">
                        <?php printf(__('<cite class="fn">%s</cite>'), get_comment_author_link()) ?>
                    </div>
    
                    <div class="comment-meta commentmetadata">
                        <a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf(__('%1$s at %2$s', 'framework'), get_comment_date(),  get_comment_time()) ?></a>
                        <?php edit_comment_link(__('(Edit)', 'framework'),'  ','') ?> &middot; <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
                    </div>
          
                    <?php if ($comment->comment_approved == '0') : ?>
                        <em class="moderation"><?php _e('Your comment is awaiting moderation.', 'framework') ?></em>
                        <br />
                    <?php endif; ?>
          
                    <div class="comment-body">
                        <?php comment_text() ?>
                    </div>
                </div>    
                -->
            </div>
            <div class="clear"></div>

    <?php
    }
}

#-----------------------------------------------------------------#
# Nimva Logo Function
#-----------------------------------------------------------------#

if (!function_exists('nimva_logo')) {
    function nimva_logo() {
        global $data, $post;
        $html = $transparent_logo = $transparent_retina_logo = $default_logo_class = '';

        if ( get_post_meta($post->ID, 'pyre_transparent_header', true) == 'yes' && $data['transparent_logo'] !='' && get_post_meta($post->ID, 'pyre_transparent_header_opt_inh', true) != 'no') {
            if($data['transparent_logo']) {                                    
                $transparent_logo = '<img src="' . $data['transparent_logo'] . '" alt="' . get_bloginfo('name') . '" class="transparent_logo" title="' . get_bloginfo('name') .'" />';         
            }
            if($data['transparent_retina_logo']) {                                    
                $transparent_retina_logo = '<img src="' . $data['transparent_retina_logo'] . '" alt="' . get_bloginfo('name') . '" class="transparent_logo" title="' . get_bloginfo('name') .'" />';         
            }
            $default_logo_class = 'init_logo';
        }
        else {
            /* We don't have any transparent logo, in this case the default logo will be used */
            $default_logo_class = 'trans_hdr_default_logo';
        }

        if( $data['logo'] || $data['logo_retina'] ){                    
         
            if($data['logo']) {                                    
                $html .= '<a href="' . home_url() . '" class="standard_logo">' . $transparent_logo . '<img src="' . $data['logo'] . '" alt="' . get_bloginfo('name') . '" class="'.$default_logo_class.'" title="' . get_bloginfo('name') .'" /></a>';            
            }

            if($data['logo_retina']) {            
                $html .= '<a href="' . home_url() .'" class="retina_logo">' . $transparent_retina_logo . '<img src="' . $data['logo_retina'] . '" alt="' . get_bloginfo('name') . '" class="'.$default_logo_class.'" title="' . get_bloginfo('name'). '" /></a>';                    
            }
        }                   

        else{ 

            $html .='<a href="' . home_url() .'" class="standard_logo_text">' . get_bloginfo('name') . '</a>';                       
            
            if($data['show_tagline']) {            
                $html .= '<div class="tagline">' . $data['tagline_text'] . '</div>';            
            }
                             
        } 
    return $html; 
    }
}

#-----------------------------------------------------------------#
# Logo in middle of Menu
#-----------------------------------------------------------------#

class logo_in_middle_Menu_Walker extends Walker_Nav_Menu {

    public $menu_location = 'primary-menu';

    function __construct($menu_location_var) {
        // parent class doesnt have a constructor so no parent::__construct();
        $this->menu_location = $menu_location_var;
    }

    public function end_el(&$output, $item, $depth = 0, $args = array()) {
        global $data, $post;
        $locations = get_nav_menu_locations(); //get all menu locations
        if( get_post_meta($post->ID, 'pyre_main_menu', true) && get_post_meta($post->ID, 'pyre_main_menu', true) !== 'default' ) {
            $main_menu = get_post_meta($post->ID, 'pyre_main_menu', true);
        }
        else {
            $main_menu = $locations[$this->menu_location];
        }
        $menu = wp_get_nav_menu_object($main_menu); //one menu for one location so lets get the menu of this location
        $menu_items = wp_get_nav_menu_items($menu->term_id);

        $top_lvl_menu_items_count = 0; //we need this to work with a menu with children too so we dont use simply $menu->count here
        foreach ($menu_items as $menu_item) {
            if ($menu_item->menu_item_parent == "0") {
                $top_lvl_menu_items_count++;
            }
        }

        $total_menu_items = $top_lvl_menu_items_count;

        $item_position = $item->menu_order;

        $position_to_have_the_logo = ceil($total_menu_items / 2);

        if ($item_position == $position_to_have_the_logo && $item->menu_item_parent == "0") { //make sure we output for top level only
            $output .= '</li><li class="header_middle_logo">'.nimva_logo().'</li>'; //here we add the logo
        } else {
            $output .= '</li>';
        }
    }
}

#-----------------------------------------------------------------#
# Social Sharing Box Function
#-----------------------------------------------------------------#

if( !function_exists('nv_share_post')) {
    function nv_share_post() {
        global $data;

        if($data['social_sharing_box']):                    
                        
            $shape = ($data['social_icons_shape']=='Round') ? 'round' : 'square';
            
            ?>
            <div class="entry_share <?php echo $shape ?> clearfix">
                        
                    <span><?php echo __('SHARE IT:','Nimva'); ?></span>
                                    
                    <a href="http://www.facebook.com/sharer.php?u=<?php the_permalink(); ?>&amp;t=<?php the_title(); ?>" class="facebook ntip" title="Share on Facebook"><i class="fab fa-facebook"></i></a>
                    
                    <a href="http://twitter.com/home?status=<?php the_title(); ?> <?php the_permalink(); ?>" class="twitter ntip" title="Tweet on Twitter"><i class="fab fa-twitter"></i></a>
                    
                    <?php $full_image_share = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); ?>
                    <a href="http://pinterest.com/pin/create/button/?url=<?php echo urlencode(get_permalink()); ?>&amp;description=<?php the_title(); ?>&amp;media=<?php echo urlencode($full_image_share[0]); ?>" class="pinterest ntip" title="Pin on Pinterest"><i class="fab fa-pinterest"></i></a>
                    
                    <a href="https://plus.google.com/share?url=<?php the_permalink(); ?>" onclick="javascript:window.open(this.href,
'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;" class="google_plus ntip" title="Share on Google Plus"><i class="fab fa-google-plus"></i></a>

                    <a href="http://www.stumbleupon.com/badge/?url=<?php the_permalink(); ?>" class="stumble_upon ntip" title="Share on StumbleUpon"><i class="fab fa-stumbleupon"></i></a>
                    
                    <a href="http://reddit.com/submit?url=<?php the_permalink(); ?>&amp;title=<?php the_title(); ?>" class="reddit ntip" title="Share on Reddit"><i class="fab fa-reddit"></i></a>
                    
                    <a href="mailto:?subject=<?php the_title(); ?>&amp;body=<?php the_permalink(); ?>" class="mailto ntip" title="Email this Post"><i class="fa fa-envelope"></i></a>
                                
                </div>
        <?php
        endif;
    }
}

#-----------------------------------------------------------------#
# Single Post Meta 
#-----------------------------------------------------------------#
if( !function_exists('nv_post_meta')) {
    function nv_post_meta($design) {

        global $data;
        $html = $cat_output  = '';

        if($data['post_meta_date'] || $data['post_meta_author'] || $data['post_meta_cats'] || $data['post_meta_comments']):
                         
            $html .= '<ul class="entry_meta clearfix">';
                
                if($data['post_meta_date'] && $design != 'alternate'):                
                    $html .= '<li><i class="fa fa-calendar"></i>' . get_the_time( get_option('date_format') ) .'<span>/</span></li>';            
                endif;

                if($data['post_meta_author']):                  
                    $html .= '<li><i class="fa fa-user"></i>' . get_the_author_posts_link() .'<span>/</span></li>';             
                endif;

                if($data['post_meta_cats']):
                    $categories = get_the_category();
                    //echo sizeof($categories);
                    $count = 1;
                    if ( ! empty( $categories ) ) {
                      foreach( $categories as $category ) {
                        $categ_split = ($count < sizeof($categories)) ? ', ' : '';
                        $cat_output .= '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '" title="' . esc_attr( sprintf( __( 'View all posts in %s', 'Creativo' ), $category->name ) ) . '"><i class="fa fa-bookmark"></i>' . esc_html( $category->name ) . '</a>'.$categ_split;
                        $count++;
                      }   
                    }
                    $html .= '<li class="category_render">' . $cat_output .' <span>/</span></li>';
                endif;

                if($data['post_meta_comments']):
                    $html .= '<li><a href="' . get_comments_link() .'"><i class="fa fa-comment"></i> '. get_comments_number() . ' ' . __('Comments ','Nimva').'</a></li>';
                endif;
                                   
            $html .= '</ul>';
         
        endif;

        return $html;
    }
}

if(!function_exists('nv_post_icon')) {
    function nv_post_icon() {
        global $data, $post;
        $icon = '';
        $post_id = $post->ID;
        if(has_post_thumbnail() || get_post_meta($post_id , 'pyre_youtube', true) || get_post_meta($post_id , 'pyre_vimeo', true)){  
            $icon = 'fa fa-camera';
        }
        if(get_post_meta($post_id, 'pyre_youtube', true)) {            
            $icon = 'fa fa-film';
        }
        if(get_post_meta($post_id, 'pyre_vimeo', true)) {            
            $icon = 'fa fa-film';
        } 
        $i = 2;
       

        for ($i=1; $i <= 2; $i++) {
            $attachment = new StdClass;
            $attachment->ID = cr_get_featured_image_id('featured-image-'.$i, 'post');
            if($attachment->ID):
                $icon='fa fa-picture-o';
            endif;
        }

        $icon = '<i class="'.$icon.'"></i>';

        return $icon;
    }
}
    
#-----------------------------------------------------------------#
# Single Post Featured Image
#-----------------------------------------------------------------#

if( !function_exists( 'single_post_featured_images' )) {
    function single_post_featured_images() {
        global $data, $post;
        $html = '';
        $post_id = $post->ID;
        
        if(has_post_thumbnail() || get_post_meta($post_id, 'pyre_youtube', true) || get_post_meta($post_id, 'pyre_vimeo', true)){
            $icon = 'fa fa-camera';

            $html .= '<div class="entry_image">';
                $html .= '<div class="fslider" data-animate="' . $data['bp_anim'] . '" '. ( $data['bp_anim_auto'] ? 'data-slideshow="true"' : '' ) . ( $data['bp_anim_control'] ? 'data-direction-nav="true"' : '' ) . 'data-speed="' . $data['bp_anim_speed'] . '" data-pause="' . ($data['bp_anim_pause_time']*1000) . '" ' . ( $data['bp_anim_pause'] ? 'data-pause-hover="true"' : '') .'>';
                    $html .= '<div class="flexslider">';
                        $html .= '<div class="slider-wrap">';
                        
                            if(get_post_meta($post_id, 'pyre_youtube', true)) {
                                $html .= '<div class="slide">' . do_shortcode('[youtube id=' . get_post_meta($post_id, 'pyre_youtube', true) . ']') . '</div>';
                                $icon = 'fa fa-film';
                            }

                            if(get_post_meta($post_id, 'pyre_vimeo', true)) {
                                $html .= '<div class="slide">' . do_shortcode('[vimeo id=' . get_post_meta($post_id, 'pyre_vimeo', true) . ']') . '</div>';
                                $icon = 'fa fa-film';
                            }

                            if(has_post_thumbnail() && get_post_meta($post_id, 'pyre_skip_first', true) != 'yes'){

                                $full_picture = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); 
                                if ( ! empty( $full_picture[0] ) ) { 
                                    $html .= '<div class="slide">';
                                        $html .= '<a href="' . $full_picture[0] .'" class="magnific_popup_gallery" title="' . get_the_title() .'">';
                                            $html .= '<img src="' . $full_picture[0] .'" alt="' . get_the_title() .'" title="' . get_the_title() .'" />';
                                            $html .= '<div class="portfolio-overlay"></div>';
                                        $html .= '</a>';                                    
                                    $html .= '</div>';
                                }
                            }

                            $i = 2;
                            while($i <= $data['featured_images']):
                                
                                $attachment = new StdClass;
                                $attachment->ID = cr_get_featured_image_id('featured-image-'.$i, 'post');
                                
                                if($attachment->ID):
                                
                                    $full_picture = wp_get_attachment_image_src( $attachment->ID, 'full' ); 
                                    if ( ! empty( $full_picture[0] ) ) {
                                        $html .= '<div class="slide">';
                                            $html .= '<a href="'. $full_picture[0] . '" class="magnific_popup_gallery" title="'. get_the_title() . '">';
                                                $html .= '<img src="'. $full_picture[0] .'" alt="' . ( isset( $attachment->post_title ) ? $attachment->post_title : '' ) .'" />';
                                                $html .= '<div class="portfolio-overlay"></div>';
                                            $html .= '</a>';
                                                        
                                        $html .= '</div>'; 
                                    }                                     
                                endif; 
                                $i++; 
                            endwhile;

                        $html .= '</div>';
                    $html .= '</div>';
                $html .= '</div>';
            $html .= '</div>';
        }

        return $html;
    }
}

#-----------------------------------------------------------------#
# Single Post Featured Image for Style 3
#-----------------------------------------------------------------#

if( !function_exists( 'sp_featured_images_style3' )) {
    function sp_featured_images_style3() {
        global $data, $post;
        $html = '';
        $post_id = $post->ID;
        
        if(has_post_thumbnail() && get_post_meta($post_id, 'pyre_skip_first', true) != 'yes'){

            $full_picture = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');  
            $html .= '<div class="sp_featured_image_output parallax_section">';                       
                    //$html .= '<img src="' . $full_picture[0] .'" alt="' . get_the_title() .'" title="' . get_the_title() .'" />';                       
                $html .= '</a>';                                    
            $html .= '</div>';

        }

        return $html;
    }
}

if( !function_exists('portfolio_featured_images')) {
    function portfolio_featured_images() {
        global $data;

        $html = $attachment_image = '';

        if(get_post_meta(get_the_ID(), 'pyre_img_render', true) != 'list') {
        
            $html .= '<div id="slider" class="fslider" data-animate="' . $data['bp_anim'] .'" '. ($data['bp_anim_auto'] ? 'data-slideshow="true"' : '') .' ' . ($data['bp_anim_control'] ? 'data-direction-nav="true"' : '') . ' data-speed="' . $data['bp_anim_speed'] .'" data-pause="'. ($data['bp_anim_pause_time']*1000) .'" ' . ($data['bp_anim_pause'] ? 'data-pause-hover="true"' : '') . '>';
                $html .= '<div class="flexslider">';
                    $html .= '<div class="slider-wrap">';
                        
                        if(get_post_meta(get_the_ID(), 'pyre_youtube', true)) {
                            $html .= '<div class="slide">'.do_shortcode('[youtube id='.get_post_meta(get_the_ID(), 'pyre_youtube', true).']').'</div>';
                        }
                        if(get_post_meta(get_the_ID(), 'pyre_vimeo', true)) {
                            $html .= '<div class="slide">'.do_shortcode('[vimeo id='.get_post_meta(get_the_ID(), 'pyre_vimeo', true).']').'</div>';
                        }                                                
                        if(has_post_thumbnail() && ( get_post_meta(get_the_ID(), 'pyre_skip_first', true) !='yes' ) ):
                            $attachment_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
                            $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
                            $attachment_data = wp_get_attachment_metadata(get_post_thumbnail_id());
                            $html .= '<div class="slide">';
                                $html .= '<a href="'.$full_image[0] .'" class="magnific_popup_gallery">';
                                    $html .= '<img src="'.$attachment_image[0].'" alt="' . get_the_title() . '" />';
                                    $html .= '<div class="portfolio-overlay"></div>';
                                $html .= '</a>';
                            $html .= '</div>';
                        
                        endif;
                        $i = 2;
                        while($i <= $data['featured_images']):
                            $attachment = new StdClass();
                            $attachment->ID = cr_get_featured_image_id('featured-image-'.$i, 'creativo_portfolio');
                            if($attachment->ID):                                                        
                            
                                $attachment_image = wp_get_attachment_image_src($attachment->ID, 'full');
                                $full_image = wp_get_attachment_image_src($attachment->ID, 'full');
                                $attachment_data = wp_get_attachment_metadata($attachment->ID);
                                $html .= '<div class="slide">';
                                    $html .= '<a href="'.$full_image[0] .'" class="magnific_popup_gallery">';
                                        $html .= '<img src="'. $attachment_image[0].'" alt="'. get_the_title() .'" />';
                                        $html .= '<div class="portfolio-overlay"></div>';
                                    $html .= '</a>';
                                $html .= '</div>';                                                                            
                            endif; 
                            $i++; 
                        endwhile;
                    $html .= '</div>';
                $html .= '</div>';
            $html .= '</div>';
        }
        else {
            $html .= '<div class="portfolio_images_list">';
                if(get_post_meta(get_the_ID(), 'pyre_youtube', true)) {
                    $html .= '<div class="image_listing">'.do_shortcode('[youtube id='.get_post_meta(get_the_ID(), 'pyre_youtube', true).']').'</div>';
                }
                if(get_post_meta(get_the_ID(), 'pyre_vimeo', true)) {
                    $html .= '<div class="image_listing">'.do_shortcode('[vimeo id='.get_post_meta(get_the_ID(), 'pyre_vimeo', true).']').'</div>';
                }                                                
                if(has_post_thumbnail() && ( get_post_meta(get_the_ID(), 'pyre_skip_first', true) !='yes' ) ):
                    $attachment_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
                    $attachment_data = wp_get_attachment_metadata(get_post_thumbnail_id());
                    $html .= '<div class="image_listing">';
                        $html .= '<a href="'.$full_image[0] .'" class="magnific_popup_gallery">';
                            $html .= '<img src="'.$attachment_image[0].'" alt="'.get_the_title().'" />';
                            //$html .= '<div class="portfolio-overlay"></div>';
                        $html .= '</a>';
                    $html .= '</div>';
                
                endif;
                $i = 2;
                while($i <= $data['featured_images']):
                    $attachment = new StdClass();
                    $attachment->ID = cr_get_featured_image_id('featured-image-'.$i, 'creativo_portfolio');
                    if($attachment->ID):                                                        
                    
                        $attachment_image = wp_get_attachment_image_src($attachment->ID, 'full');
                        $full_image = wp_get_attachment_image_src($attachment->ID, 'full');
                        $attachment_data = wp_get_attachment_metadata($attachment->ID);
                        $html .= '<div class="image_listing">';
                            $html .= '<a href="'.$full_image[0] .'" class="magnific_popup_gallery">';
                                $html .= '<img src="'. $attachment_image[0].'" alt="'. $attachment->post_title .'" />';
                                //$html .= '<div class="portfolio-overlay"></div>';
                            $html .= '</a>';
                        $html .= '</div>';                                                                            
                    endif; 
                    $i++; 
                endwhile;
            $html .= '</div>';
        } 

        return $html;       
    }
}

#-----------------------------------------------------------------#
# Portfolio Details
#-----------------------------------------------------------------#

if(!function_exists('nv_portfolio_details')) {
    function nv_portfolio_details() {
        global $data, $post;
        $html = '';
        
        $html .= '<div class="port-details">';
            if($data['project_details_text']) {
                $html .= '<div class="title-outer">';
                    $html .= '<h3>' . $data['project_details_text'] . '</h3>';
                $html .= '</div>';
            }
            if($data['port_date']):
                $html .= '<div class="port-terms">';
                    $html .= '<h5>'. __("Date", "Nimva") .'</h5>';
                    $html .= '<span>' . get_the_date() .'</span>';
                $html .= '</div>';
            endif;            
            
            if($data['port_client'] && get_post_meta($post->ID, 'pyre_client_name', true)){
            
                $html .= '<div class="port-terms">';
                    $html .= '<h5>' . $data['project_client_text'] . '</h5>';
                    $html .= '<span>' . get_post_meta($post->ID, 'pyre_client_name', true) .'</span>';
                $html .= '</div>';
            
            }
            if($data['port_skills'] && get_post_meta($post->ID, 'pyre_skills', true)){
            
                $html .= '<div class="port-terms">';
                    $html .= '<h5>' . $data['project_skills_text'] .'</h5>';
                    $html .= '<span>' . get_post_meta($post->ID, 'pyre_skills', true) .'</span>';
                $html .= '</div>';
            
            }
            if($data['port_website'] && get_post_meta($post->ID, 'pyre_website_text', true)){
            
                $html .= '<div class="port-terms">';
                    $html .= '<h5>'. $data['project_website_text'] . '</h5>';                    
                        if(get_post_meta($post->ID, 'pyre_website_url', true)): 
                            $html .= '<span><a href="'. get_post_meta($post->ID, 'pyre_website_url', true) .'" target="_blank">' . get_post_meta($post->ID, 'pyre_website_text', true) .'</a></span>';                    
                        else:
                    
                        $html .= '<span>' . get_post_meta($post->ID, 'pyre_website_text', true) .'</span>';
                    
                    endif;
                $html .= '</div>';

            }
           
        $html .= '</div>';

        return $html;        
    }
}

#-----------------------------------------------------------------#
# Related Portfolio Function
#-----------------------------------------------------------------#

if(!function_exists('nv_related_portfolio')) {
    function nv_related_portfolio() {
        global $data, $post;
        $html = '';

        $html .= '<div id="portfolio-related">';
            if($data['project_related_text']) {
                $html .= '<div class="title-outer">';
                    $html .= '<h3>' . $data['project_related_text'] .'</h3>';
                $html .= '</div>'; 
            }
            $relate = get_related_projects($post->ID, -1);    
            if($relate->have_posts()):                      
                $html .= '<div id="portfolio-related-items" class="related_portfolio owl-carousel owl-theme">';
                
                    while($relate->have_posts()): $relate->the_post();
                        $icon = 'fa fa-camera';     
                        if(get_post_meta(get_the_ID(), 'pyre_youtube', true)) {
                            $icon = 'fa fa-film';
                        }
                        if(get_post_meta(get_the_ID(), 'pyre_vimeo', true)) {
                            $icon = 'fa fa-film';
                        }                        
                                    
                        if(has_post_thumbnail()){                                       
                            $img_url = wp_get_attachment_url( get_post_thumbnail_id(),'full' );
                            $image = aq_resize( $img_url, 470, 320, true );
                       
                            $html .= '<div class="related_portfolio_items">';
                                $html .= '<img src="'. $image .'" />';
                                $html .= '<div class="portfolio-overlay">';
                                    $html .= '<a href="'. get_the_permalink() .'">';
                                        $html .= '<div class="portfolio-overlay-inside">';
                                            $html .= '<span class="' . $icon .'"></span>';
                                        $html .= '</div>';
                                    $html .= '</a>';
                                $html .= '</div>';
                            $html .= '</div>';                        
                        }
                    endwhile;                        
                $html .= '</div>';                
                
            endif; 
            wp_reset_query();   
        $html .= '</div>';

        return $html;
    }
}

#-----------------------------------------------------------------#
# Seperated Pings Styling
#-----------------------------------------------------------------#

if( !function_exists( 'cr_list_pings' ) ) {
    function cr_list_pings($comment, $args, $depth) {
        $GLOBALS['comment'] = $comment; ?>
    	<li id="comment-<?php comment_ID(); ?>"><?php comment_author_link(); ?>
    	<?php 
    }
}


#-----------------------------------------------------------------#
# Custom Gravatar Support
#-----------------------------------------------------------------#

if( !function_exists( 'cr_custom_gravatar' ) ) {
    function cr_custom_gravatar( $avatar_defaults ) {
        $cr_avatar = get_template_directory_uri() . '/images/gravatar.png';
        $avatar_defaults[$cr_avatar] = 'Custom Gravatar (/images/gravatar.png)';
        return $avatar_defaults;
    }
    
    add_filter( 'avatar_defaults', 'cr_custom_gravatar' );
}

#-----------------------------------------------------------------#
# Related Posts Function
#-----------------------------------------------------------------#

if( !function_exists( 'get_related_posts' ) ) {
    function get_related_posts($post_id,$items) {
    	
    	$query = new WP_Query();    
        $args = '';
    	$args = wp_parse_args($args, array(
    		'showposts' => $items,
    		'post__not_in' => array($post_id),
    		'ignore_sticky_posts' => 0,
            'category__in' => wp_get_post_categories($post_id)
    	));
    	
    	$query = new WP_Query($args);
    	
      	return $query;
    }
}

#-----------------------------------------------------------------#
# Related Posts Render Function
#-----------------------------------------------------------------#

if(!function_exists('nv_related_posts')) {
    function nv_related_posts() {

        global $data, $post;
        $relate = get_related_posts($post->ID, $data['related_posts_number']);

        $html = '';

        if($relate->have_posts()): 

            $html .= '<div class="related_posts_wrap" style="position: relative;">';
                   
                $html .= '<div class="title-outer"><h3>' . __('Related Posts','Nimva') . '</h3></div>';
                
                if( $data['rp_design'] != 'Vertical List' ) {                
                
                    $html .= '<div id="related-posts-scroller" class="related-posts owl-carousel owl-theme clearfix">';
                        
                        while($relate->have_posts()): $relate->the_post();
                                $icon = 'fa fa-camera';
                             
                                if(get_post_meta(get_the_ID(), 'pyre_youtube', true)) {
                                    $icon = 'fa fa-film';
                                }
                                if(get_post_meta(get_the_ID(), 'pyre_vimeo', true)) {
                                     $icon = 'fa fa-film';
                                }
                                $i = 2;
                                while($i <= $data['featured_images']):
                                    $attachment = new StdClass();
                                    $attachment->ID = cr_get_featured_image_id('featured-image-'.$i, 'post');
                                    if($attachment->ID):
                                    $icon='fa fa-picture-o';                                        
                                    endif; 
                                    $i++; 
                                endwhile;
                                    
                            if(has_post_thumbnail()){
                                $img_url = wp_get_attachment_url( get_post_thumbnail_id(),'full' );
                                $image = aq_resize( $img_url, 470, 320, true );
                                
                                $html .= '<div>';
                                    $html .= '<div class="rpost-image">';
                                        $html .= '<a href="' . get_the_permalink() .'" >';
                                            $html .= '<img src="' . $image .'" alt="' . get_the_title() .'" title="' . get_the_title() .'" />';
                                            $html .= '<div class="post-overlay"><i class="'.$icon.'"></i></div>';
                                            $html .= '<div class="portfolio-overlay"></div>';
                                        $html .= '</a>';
                                    $html .= '</div>';
                                    $html .= '<div class="rpost-title"><a href="' .get_the_permalink() .'">' .get_the_title() .'</a></div>';
                                $html .= '</div>';                                
                            }
                        endwhile;
                        wp_reset_query();
                        
                    $html .= '</div>';                      
                }
                elseif( $data['rp_design'] == 'Vertical List' ) {
                    while($relate->have_posts()): $relate->the_post();
                        $img_url = wp_get_attachment_url( get_post_thumbnail_id(),'full' );
                        $image = aq_resize( $img_url, 300, 200, true );
                        
                        $html .= '<div class="vertical_related_posts">';
                            $html .= '<div class="entry clearfix">';
                                $html .= '<div class="entry_image">';
                                    $html .= '<a href="' . get_the_permalink() .'">'; 
                                        $html .= '<img src="' . $image .'" alt="' . get_the_title() .'" title="' .get_the_title() .'" />';
                                        $html .= '<div class="portfolio-overlay"></div>';
                                    $html .= '</a>';
                                $html .= '</div>';
                                $html .= '<div class="entry_c">';
                                    $html .= '<div class="entry_title"><h2><a href="' .get_the_permalink() .'">' . get_the_title() .'</a></h2></div>';
                                    $html .= nv_post_meta('default');
                                    $html .= '<div class="entry_content">';                                        
                                        $stripped_content = nv_content( $data['excerpt_length_blog'], $data['strip_html_excerpt'] );
                                        $html .= $stripped_content;                                        
                                    $html .= '</div>';
                                $html .= '</div>';
                            $html .= '</div>';

                        $html .= '</div>';
                        
                    endwhile;
                    wp_reset_query();
                }
                
            $html .= '</div>';        
        endif;

        return $html;
    }
}

#-----------------------------------------------------------------#
# Related Portfolio Function
#-----------------------------------------------------------------#

if( !function_exists( 'get_related_projects' ) ) {
    function get_related_projects($post_id,$items) {
        $query = new WP_Query();

        global $post;
        
        $args = '';

        $item_cats = get_the_terms($post->ID, 'portfolio_category');
        if($item_cats):
        foreach($item_cats as $item_cat) {
            $item_array[] = $item_cat->term_id;
        }
        endif;

        $args = wp_parse_args($args, array(
            'showposts' => $items,
            'post__not_in' => array($post_id),
            'ignore_sticky_posts' => 0,
            'post_type' => 'creativo_portfolio',
            'tax_query' => array(
                array(
                    'taxonomy' => 'portfolio_category',
                    'field' => 'id',
                    'terms' => $item_array
                )
            )
        ));
        
        $query = new WP_Query($args);
        
        return $query;
    }
}

#-----------------------------------------------------------------#
# Custom pagination function
#-----------------------------------------------------------------#

if( !function_exists( 'nv_pagination' ) ) {
    function nv_pagination($pages = '', $range = 2) {  

    	global $data;

        $html = '';

         $showitems = ($range * 2)+1;  

         global $paged;
         if(empty($paged)) $paged = 1;

         if($pages == '')
         {
             global $wp_query;
             $pages = $wp_query->max_num_pages;
             if(!$pages)
             {
                 $pages = 1;
             }
         }   

         if(1 != $pages)
         {
             $html .= "<div class='pagination clearfix'>";
            // if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a href='".get_pagenum_link(1)."'><span class='arrows'>&laquo;</span> First</a>";
             if($paged > 1) $html .= '<a class="pagination-prev" href="'.get_pagenum_link($paged - 1).'"><span class="page-prev">←'.__('Previous','Nimva').'</span></a>';

             for ($i=1; $i <= $pages; $i++)
             {
    			 if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
                 {
                
                     $html .= ($paged == $i)? "<span class='current'>".$i."</span>":"<a href='".get_pagenum_link($i)."' class='inactive' >".$i."</a>";
    			 }
                 
             }

             if ($paged < $pages) $html .= '<a class="pagination-next" href="'.get_pagenum_link($paged + 1).'"><span class="page-next">'.__('Next', 'Nimva').' →</span></a>';  
            // if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($pages)."'>Last <span class='arrows'>&raquo;</span></a>";
             $html .= "</div>\n";
        }
        return $html;
    }
}

#-----------------------------------------------------------------#
# Limit Words Function
#-----------------------------------------------------------------#
if( !function_exists( 'string_limit_words' ) ) {
    function string_limit_words($string, $word_limit)
    {
    	$words = explode(' ', $string, ($word_limit + 1));
    	
    	if(count($words) > $word_limit) {
    		array_pop($words);
    	}
    	
    	return implode(' ', $words);
    }
}

#-----------------------------------------------------------------#
# Custom Breadcrumb Function
#-----------------------------------------------------------------#

if(!function_exists('nimva_breadcrumb')) {
    function nimva_breadcrumb() {
        global $data,$post;
        echo '<ul class="breadcrumbs">';

         if ( !is_front_page() ) {
        echo '<li><a href="';
        echo home_url();
        echo '"><i class="fa fa-home"></i>';
        echo "</a></li>";
        }

        $params['link_none'] = '';
        $separator = '';

        if (is_category() && !is_singular('creativo_portfolio')) {
            $category = get_the_category();
            $ID = $category[0]->cat_ID;
            echo is_wp_error( $cat_parents = get_category_parents($ID, TRUE, '', FALSE ) ) ? '' : '<li>'.$cat_parents.'</li>';
        }

        if(is_singular('creativo_portfolio')) {
            echo get_the_term_list($post->ID, 'portfolio_category', '<li>', '&nbsp;/&nbsp;&nbsp;', '</li>');
            echo '<li>'.get_the_title().'</li>';
        }

        if(is_singular('event')) {
            echo get_the_term_list($post->ID, 'event-categories', '<li>', '&nbsp;/&nbsp;&nbsp;', '</li>');
            echo '<li>'.get_the_title().'</li>';
        }

        if (is_tax()) {
            $term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
            echo '<li>'.$term->name.'</li>';
        }

        if(is_home()) { echo '<li>'.$data['blog_title'].'</li>'; }
        if(is_page() && !is_front_page()) {
            $parents = array();
            $parent_id = $post->post_parent;
            while ( $parent_id ) :
                $page = get_page( $parent_id );
                if ( $params["link_none"] )
                    $parents[]  = get_the_title( $page->ID );
                else
                    $parents[]  = '<li><a href="' . get_permalink( $page->ID ) . '" title="' . get_the_title( $page->ID ) . '">' . get_the_title( $page->ID ) . '</a></li>' . $separator;
                $parent_id  = $page->post_parent;
            endwhile;
            $parents = array_reverse( $parents );
            echo join( '', $parents );
            echo '<li>'.get_the_title().'</li>';
        }
        if(is_single() && !is_singular('creativo_portfolio')  && !is_singular('event')) {
            $categories_1 = get_the_category($post->ID);
            if($categories_1):
                foreach($categories_1 as $cat_1):
                    $cat_1_ids[] = $cat_1->term_id;
                endforeach;
                $cat_1_line = implode(',', $cat_1_ids);
            endif;
            if( $cat_1_line ) {
                $categories = get_categories(array(
                    'include' => $cat_1_line,
                    'orderby' => 'id'
                ));
                if ( $categories ) :
                    foreach ( $categories as $cat ) :
                        $cats[] = '<li><a href="' . get_category_link( $cat->term_id ) . '" title="' . $cat->name . '">' . $cat->name . '</a></li>';
                    endforeach;
                    echo join( '', $cats );
                endif;
            }
            echo '<li>'.get_the_title().'</li>';
        }
        if(is_tag()){ echo '<li>'."Tag: ".single_tag_title('',FALSE).'</li>'; }
        if(is_404()){ echo '<li>'.__("404 - Page not Found", 'Nimva').'</li>'; }
        if(is_search()){ echo '<li>'.__("Search", 'Nimva').'</li>'; }
        if(is_year()){ echo '<li>'.get_the_time('Y').'</li>'; }

        echo "</ul>";
    }
}

/**
 * Title         : Aqua Resizer
 * Description   : Resizes WordPress images on the fly
 * Version       : 1.2.0
 * Author        : Syamil MJ
 * Author URI    : http://aquagraphite.com
 * License       : WTFPL - http://sam.zoy.org/wtfpl/
 * Documentation : https://github.com/sy4mil/Aqua-Resizer/
 *
 * @param string  $url    - (required) must be uploaded using wp media uploader
 * @param int     $width  - (required)
 * @param int     $height - (optional)
 * @param bool    $crop   - (optional) default to soft crop
 * @param bool    $single - (optional) returns an array if false
 * @uses  wp_upload_dir()
 * @uses  image_resize_dimensions()
 * @uses  wp_get_image_editor()
 *
 * @return str|array
 */

if(!class_exists('Aq_Resize')) {
    class Aq_Resize
    {
        /**
         * The singleton instance
         */
        static private $instance = null;

        /**
         * No initialization allowed
         */
        private function __construct() {}

        /**
         * No cloning allowed
         */
        private function __clone() {}

        /**
         * For your custom default usage you may want to initialize an Aq_Resize object by yourself and then have own defaults
         */
        static public function getInstance() {
            if(self::$instance == null) {
                self::$instance = new self;
            }

            return self::$instance;
        }

        /**
         * Run, forest.
         */
        public function process( $url, $width = null, $height = null, $crop = null, $single = true, $upscale = false ) {
            // Validate inputs.
            if ( ! $url || ( ! $width && ! $height ) ) return false;

            // Caipt'n, ready to hook.
            if ( true === $upscale ) add_filter( 'image_resize_dimensions', array($this, 'aq_upscale'), 10, 6 );

            // Define upload path & dir.
            $upload_info = wp_upload_dir();
            $upload_dir = $upload_info['basedir'];
            $upload_url = $upload_info['baseurl'];
            
            $http_prefix = "http://";
            $https_prefix = "https://";
            
            /* if the $url scheme differs from $upload_url scheme, make them match 
               if the schemes differe, images don't show up. */
            if(!strncmp($url,$https_prefix,strlen($https_prefix))){ //if url begins with https:// make $upload_url begin with https:// as well
                $upload_url = str_replace($http_prefix,$https_prefix,$upload_url);
            }
            elseif(!strncmp($url,$http_prefix,strlen($http_prefix))){ //if url begins with http:// make $upload_url begin with http:// as well
                $upload_url = str_replace($https_prefix,$http_prefix,$upload_url);      
            }
            

            // Check if $img_url is local.
            if ( false === strpos( $url, $upload_url ) ) return false;

            // Define path of image.
            $rel_path = str_replace( $upload_url, '', $url );
            $img_path = $upload_dir . $rel_path;

            // Check if img path exists, and is an image indeed.
            if ( ! file_exists( $img_path ) or ! getimagesize( $img_path ) ) return false;

            // Get image info.
            $info = pathinfo( $img_path );
            $ext = $info['extension'];
            list( $orig_w, $orig_h ) = getimagesize( $img_path );

            // Get image size after cropping.
            $dims = image_resize_dimensions( $orig_w, $orig_h, $width, $height, $crop );
            $dst_w = $dims[4];
            $dst_h = $dims[5];

            // Return the original image only if it exactly fits the needed measures.
            if ( ! $dims && ( ( ( null === $height && $orig_w == $width ) xor ( null === $width && $orig_h == $height ) ) xor ( $height == $orig_h && $width == $orig_w ) ) ) {
                $img_url = $url;
                $dst_w = $orig_w;
                $dst_h = $orig_h;
            } else {
                // Use this to check if cropped image already exists, so we can return that instead.
                $suffix = "{$dst_w}x{$dst_h}";
                $dst_rel_path = str_replace( '.' . $ext, '', $rel_path );
                $destfilename = "{$upload_dir}{$dst_rel_path}-{$suffix}.{$ext}";

                if ( ! $dims || ( true == $crop && false == $upscale && ( $dst_w < $width || $dst_h < $height ) ) ) {
                    // Can't resize, so return false saying that the action to do could not be processed as planned.
                    return false;
                }
                // Else check if cache exists.
                elseif ( file_exists( $destfilename ) && getimagesize( $destfilename ) ) {
                    $img_url = "{$upload_url}{$dst_rel_path}-{$suffix}.{$ext}";
                }
                // Else, we resize the image and return the new resized image url.
                else {

                    $editor = wp_get_image_editor( $img_path );

                    if ( is_wp_error( $editor ) || is_wp_error( $editor->resize( $width, $height, $crop ) ) )
                        return false;

                    $resized_file = $editor->save();

                    if ( ! is_wp_error( $resized_file ) ) {
                        $resized_rel_path = str_replace( $upload_dir, '', $resized_file['path'] );
                        $img_url = $upload_url . $resized_rel_path;
                    } else {
                        return false;
                    }

                }
            }

            // Okay, leave the ship.
            if ( true === $upscale ) remove_filter( 'image_resize_dimensions', array( $this, 'aq_upscale' ) );

            // Return the output.
            if ( $single ) {
                // str return.
                $image = $img_url;
            } else {
                // array return.
                $image = array (
                    0 => $img_url,
                    1 => $dst_w,
                    2 => $dst_h
                );
            }

            return $image;
        }

        /**
         * Callback to overwrite WP computing of thumbnail measures
         */
        function aq_upscale( $default, $orig_w, $orig_h, $dest_w, $dest_h, $crop ) {
            if ( ! $crop ) return null; // Let the wordpress default function handle this.

            // Here is the point we allow to use larger image size than the original one.
            $aspect_ratio = $orig_w / $orig_h;
            $new_w = $dest_w;
            $new_h = $dest_h;

            if ( ! $new_w ) {
                $new_w = intval( $new_h * $aspect_ratio );
            }

            if ( ! $new_h ) {
                $new_h = intval( $new_w / $aspect_ratio );
            }

            $size_ratio = max( $new_w / $orig_w, $new_h / $orig_h );

            $crop_w = round( $new_w / $size_ratio );
            $crop_h = round( $new_h / $size_ratio );

            $s_x = floor( ( $orig_w - $crop_w ) / 2 );
            $s_y = floor( ( $orig_h - $crop_h ) / 2 );

            return array( 0, 0, (int) $s_x, (int) $s_y, (int) $new_w, (int) $new_h, (int) $crop_w, (int) $crop_h );
        }
    }
}





if(!function_exists('aq_resize')) {

    /**
     * This is just a tiny wrapper function for the class above so that there is no
     * need to change any code in your own WP themes. Usage is still the same :)
     */
    function aq_resize( $url, $width = null, $height = null, $crop = null, $single = true, $upscale = false ) {
        $aq_resize = Aq_Resize::getInstance();
        return $aq_resize->process( $url, $width, $height, $crop, $single, $upscale );
    }
}

// retrieves the attachment ID from the file URL
if(!function_exists('nv_get_image_id')) {
    function nv_get_image_id($image_url) {
    	global $wpdb;
    	$attachment = $wpdb->get_col($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE guid='%s';", $image_url )); 
            return $attachment[0]; 
    }
}


remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10);
add_action( 'woocommerce_before_main_content', 'nv_woocommerce_output_content_wrapper', 10);
add_action( 'woocommerce_after_main_content', 'nv_woocommerce_output_content_wrapper_end', 10);
remove_action( 'woocommerce_before_main_content','woocommerce_breadcrumb', 20, 0);


if(!function_exists('nv_woocommerce_output_content_wrapper')) {
    function nv_woocommerce_output_content_wrapper() {	
    	global $data, $post;
    	
    	if(is_shop()) {
    		$pageID = get_option('woocommerce_shop_page_id');
    	} else {
    		$pageID = $post->ID;
    	}
    	
    	?>
    	<div class="content-wrap display_class">
    		<div class="container clearfix">
            	<?php
    			if( ( $data['shop_sidebar'] ) && ( $data['woocommerce_archive_sidebar'] != 'None' && get_post_meta($pageID, 'pyre_en_sidebar', true) != 'no' )  ) { 
    			?>
            		<div class="postcontent clearfix nobottommargin">
                <?php
    			}
    			else{
    			?>
    				<div class="col_full nobottommargin">            
                <?php
    			}
    }
}

if(!function_exists('nv_woocommerce_output_content_wrapper_end')) {
    function nv_woocommerce_output_content_wrapper_end() {
    	global $data, $post;
    	if(is_shop()) {
    		$pageID = get_option('woocommerce_shop_page_id');
    	} else {
    		$pageID = $post->ID;
    	}
        ?>
    			
            </div>
        	
            <?php //if sidebar is enabled start displaying it
        	if( ( $data['shop_sidebar'] ) && ( $data['woocommerce_archive_sidebar'] != 'None' && get_post_meta($pageID, 'pyre_en_sidebar', true) != 'no' ) ) { 	
        	?>
            	<div class="sidebar col_last nobottommargin clearfix" <?php echo get_post_meta($pageID, 'pyre_en_sidebar', true); ?>>
                    <div class="sidebar-widgets-wrap clearfix">
                        <?php
                        if (!function_exists('dynamic_sidebar') || !dynamic_sidebar($data['woocommerce_archive_sidebar'])): 
                        endif;
                        ?> 
                    </div>
                </div>
            <?php    	
        	} 
            ?>	
    	</div>
    	
    </div>
    <?php
    }
}

if(!function_exists('nv_is_out_of_stock')) {
    function nv_is_out_of_stock() {
	    global $post;
	    $post_id = $post->ID;
	    $stock_status = get_post_meta($post_id, '_stock_status',true);
	    
	    if ($stock_status == 'outofstock') {
    	    return true;
	    } else {
	       return false;
	    }
	}
}

if ( class_exists( 'WooCommerce' ) ) {

    add_filter( 'loop_shop_per_page', 'nv_loop_shop_per_page', 20 );

	/**
	 * Nimva WooCommerce products per page loop.
	 *
	 * @since 7.0
	 * @return int
	 */
	function nv_loop_shop_per_page() {
        global $data;
		return ( ( $data['shop_prod_number'] ) ? $data['shop_prod_number'] : 10 );
	}

    // Change number of products per row to 3
    if( ( isset( $data['shop_sidebar'] ) ) && ( $data['woocommerce_archive_sidebar'] != 'None' && ((int)($data['custom_width']) < 1200 )) ) { 
            add_filter('loop_shop_columns', 'loop_columns');
            if (!function_exists('loop_columns')) {
                function loop_columns() {
                    return 3; // 3 products per row
                }
            }
    }

    // Redefine woocommerce_output_related_products()
    /*
    if(!function_exists('woocommerce_output_related_products')) {
        function woocommerce_output_related_products() {
            
            global $data,$post;
            
            if(is_shop()) {
                $pageID = get_option('woocommerce_shop_page_id');
            } else {
                $pageID = $post->ID;
            }
            
            if( ( $data['shop_sidebar'] ) && ( $data['woocommerce_archive_sidebar'] != 'None' && get_post_meta($pageID, 'pyre_en_sidebar', true) != 'no' ) ) { 
                woocommerce_related_products(3,3); // Display 4 products in rows of 4
            }
            else{
                woocommerce_related_products(4,4);
            }
        }
    } */

    /* Change the columns number for related products */
    add_filter( 'woocommerce_output_related_products_args', 'nv_related_products_args' );
    function nv_related_products_args( $args ) {  
        global $data, $post;

        //$has_sidebar = ( get_post_meta( get_the_ID(), 'pyre_en_prod_sidebar', true) != NULL && get_post_meta( get_the_ID(), 'pyre_en_prod_sidebar', true) != 'default' ) ? get_post_meta( get_the_ID(), 'pyre_en_prod_sidebar', true) : $data['woocommerce_sidebar_product_en'];

        $site_page_width = (int)($data['custom_width']);   

        if( ( $data['shop_sidebar'] ) && ( $data['woocommerce_archive_sidebar'] != 'None' && get_post_meta( get_the_ID(), 'pyre_en_sidebar', true) != 'no' ) && $site_page_width < 1200 ) {  
        $args['columns'] = 3; // arranged in 3 columns
        $args['posts_per_page'] = 3; // 4 related products
        }
        else{
        $args['columns'] = 4; // arranged in 4 columns
        $args['posts_per_page'] = 4; // 4 related products  
        }
        return $args;
    }

    // Ensure cart contents update when products are added to the cart via AJAX (place the following in functions.php)
    add_filter('woocommerce_add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment');

    if(!function_exists('woocommerce_header_add_to_cart_fragment')) { 
        function woocommerce_header_add_to_cart_fragment( $fragments ) {
            global $woocommerce;
            
            ob_start();
            
            ?>
            <?php if(!$woocommerce->cart->cart_contents_count): ?>
            <a class="shopping-cart" href="<?php echo wc_get_cart_url(); ?>"><i class="fa fa-shopping-cart"><span><?php echo $woocommerce->cart->cart_contents_count; ?></span></i></a>
            <?php else: ?>
            <a class="shopping-cart active" href="<?php echo wc_get_cart_url(); ?>"><i class="fa fa-shopping-cart"><span><?php echo $woocommerce->cart->cart_contents_count; ?></span></i></a>

            <?php
            endif;
            $fragments['a.shopping-cart'] = ob_get_clean();
            
            return $fragments;
            
        }
    }
}

if( !function_exists('header_search')) {
    function header_search() {
        global $data;        
        ?>
        <li class="main_menu_search">                       
            <a href="#search-main-menu" class="main-menu-search-form"><i class="fa fa-search"></i></a>                            
            <!-- search form input will show on icon click-->
            <form id="search-main-menu" action="<?php echo home_url(); ?>" method="get" class="mfp-hide search-form-result">
                <div class="search-form position-relative">
                    <button type="submit" class="fa fa-search close-search search-button"></button>
                    <input type="text" name="s" class="search-input" placeholder="Search here..." autocomplete="off">
                </div>
            </form>                     
        </li>
        <?php        
    }
}

if( !function_exists('header_shopping_cart')) {
    function header_shopping_cart() {
        global $data, $woocommerce;

        $header_shopping_cart_icon = '';

        if( class_exists('Woocommerce') ) {

            $items = $woocommerce->cart->get_cart();

            ob_start();

            if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                
            ?> 
                <li class="cart">
                    <?php if(!$woocommerce->cart->cart_contents_count): ?>
                        <a class="shopping-cart" href="<?php echo wc_get_cart_url(); ?>"><i class="fa fa-shopping-cart"></i></a>
                    <?php else: ?>
                        <a class="shopping-cart active" href="<?php echo wc_get_cart_url(); ?>"><i class="fa fa-shopping-cart"></i></a>
                        <div class="cart-contents">
                            <?php 
                            foreach($items as $item => $values) { 
                                $_product =  wc_get_product( $values['data']->get_id()); 
                                $getProductDetail = wc_get_product( $values['product_id'] );
                                $price = get_woocommerce_currency_symbol() . ' ' . get_post_meta($values['product_id'] , '_price', true);
                                ?>
                                <div class="cart-content">
                                    <?php echo $getProductDetail->get_image(); ?>
                                    <div class="cart-desc">
                                        <span class="cart-title">
                                            <a href="<?php echo get_permalink($values['product_id']); ?>">
                                                <?php echo $_product->get_title(); ?></a>
                                        </span>
                                        <span class="product-quantity">
                                            <?php echo $values['quantity']; ?> x <?php echo $price; ?></span>
                                    </div>
                                </div>
                                <?php
                                
                            }
                            ?>
                            <div class="cart-total">
                                <?php _e('Subtotal: ', 'Nimva'); ?>
                                <?php echo $woocommerce->cart->get_cart_subtotal(); ?>
                            </div>
                            <div class="cart-checkout">
                                <div class="cart-link"><a href="<?php echo get_permalink(get_option('woocommerce_cart_page_id')); ?>"><?php _e('View Cart', 'Nimva'); ?></a></div>
                                <div class="checkout-link"><a href="<?php echo get_permalink(get_option('woocommerce_checkout_page_id')); ?>"><?php _e('Checkout', 'Nimva'); ?></a></div>
                            </div>
                        </div>
                        
                    <?php endif; ?>                 
                </li> 
            <?php            
            }

            $header_shopping_cart_icon = ob_get_clean();
            
        }

        return $header_shopping_cart_icon;
    }
}

if( ! function_exists( 'less_css' ) ) {
	function less_css( $minify ) {
		/* remove comments */
		$minify = preg_replace( '!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $minify );

		/* remove tabs, spaces, newlines, etc. */
		$minify = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $minify );
			
		return $minify;
	}
}

/* Get Attachment id from image url */
if( ! function_exists( 'pn_get_attachment_id_from_url' ) ) {
    function pn_get_attachment_id_from_url( $attachment_url = '' ) {
     
        global $wpdb;
        $attachment_id = false;
     
        // If there is no url, return.
        if ( '' == $attachment_url )
            return;
     
        // Get the upload directory paths
        $upload_dir_paths = wp_upload_dir();
     
        // Make sure the upload path base directory exists in the attachment URL, to verify that we're working with a media library image
        if ( false !== strpos( $attachment_url, $upload_dir_paths['baseurl'] ) ) {
     
            // If this is the URL of an auto-generated thumbnail, get the URL of the original image
            $attachment_url = preg_replace( '/-\d+x\d+(?=\.(jpg|jpeg|png|gif)$)/i', '', $attachment_url );
     
            // Remove the upload path base directory from the attachment URL
            $attachment_url = str_replace( $upload_dir_paths['baseurl'] . '/', '', $attachment_url );
     
            // Finally, run a custom database query to get the attachment ID from the modified attachment URL
            $attachment_id = $wpdb->get_var( $wpdb->prepare( "SELECT wposts.ID FROM $wpdb->posts wposts, $wpdb->postmeta wpostmeta WHERE wposts.ID = wpostmeta.post_id AND wpostmeta.meta_key = '_wp_attached_file' AND wpostmeta.meta_value = '%s' AND wposts.post_type = 'attachment'", $attachment_url ) );
     
        }
     
        return $attachment_id;
    }
}

if( !function_exists( 'nv_twitter_bar' )) {
    
    function nv_twitter_bar() {
        
        global $data;
        $id = rand(0,999);  
        ?>

        <div id="twitter_bar">
            <div class="container clearfix">
                <?php
                $transName = 'list_tweets_'.$args['widget_id'];
                $cacheTime = 10;
                delete_transient($transName);

                // Define the path to the Twitter OAuth file
                $twitter_oauth_path = get_template_directory() . '/functions/twitteroauth/twitteroauth.php';

                if(false === ($twitterData = get_transient($transName))) {
                    
                    // Check if the twitteroauth.php file exists before requiring it
                    if (file_exists($twitter_oauth_path)) {
                        require_once $twitter_oauth_path;

                        $twitterConnection = new TwitterOAuth(
                            $data['consumer_key'],       // Consumer Key
                            $data['consumer_secret'],    // Consumer secret
                            $data['access_token'],       // Access token
                            $data['access_token_secret'] // Access token secret
                        );

                        $twitterData = $twitterConnection->get(
                            'statuses/user_timeline',
                            array(
                                'screen_name'     => $data['twitter_profile'],
                                'count'           => 1,
                                'exclude_replies' => false
                            )
                        );

                        if($twitterConnection->http_code != 200) {
                            $twitterData = get_transient($transName);
                        }
                        // Save our new transient
                        set_transient($transName, $twitterData, 60 * $cacheTime);
                    } else {
                        // Optionally, log an error or display a message if the file is missing
                        echo "<p>Twitter integration is temporarily unavailable.</p>";
                    }
                }
                
                $twitter = get_transient($transName);
                
                if($twitter && is_array($twitter)) {
                    
                    $id = rand(0,999);
                    ?>

                    <ul id="twitter_list_<?php echo $id; ?>" style="margin:0;">
                        <?php 
                        foreach($twitter as $tweet): ?>
                            <li>                    
                                <?php
                                $latestTweet = $tweet->text;
                                $latestTweet = preg_replace('/http:\/\/([a-z0-9_\.\-\+\&\!\#\~\/\,]+)/i', '&nbsp;<a href="http://$1" target="_blank">http://$1</a>&nbsp;', $latestTweet);
                                $latestTweet = preg_replace('/@([a-z0-9_]+)/i', '&nbsp;<a href="http://twitter.com/$1" target="_blank">@$1</a>&nbsp;', $latestTweet);
                                echo $latestTweet;                  
                                $twitterTime = strtotime($tweet->created_at);                   
                                ?>
                        
                                <a href="http://twitter.com/<?php echo $tweet->user->screen_name; ?>/statuses/<?php echo $tweet->id_str; ?>" class="jtwt_date"></a> 
                                                    
                            </li>
                        <?php 
                        endforeach; 
                        ?>
                    </ul>
                <?php
                }
                ?>
            </div>    
        </div>
    <?php
    }
}


if( !function_exists( 'nv_call_action' ) ) {
    function nv_call_action() {
        global $data;
        ?>

        <div id="call_action">
            
            <div class="container clearfix">
                
                <div class="promo-text">
                    <h3><?php echo $data['call_action_text']; ?></h3>
                </div>
                <div class="promo-action">

                    <?php if ($data['call_action_button_color']=='Light Blue') $data['call_action_button_color']='blue'; ?>
                    <?php if ($data['call_action_button_color']=='Light Red') $data['call_action_button_color']='red'; ?>
                    
                    <?php echo do_shortcode('[vc_button style="'.strtolower($data['call_action_button_style']).'" title="'.$data['call_action_button_text'].'" href="' . $data['call_action_button_link'] . '" color="' . strtolower(str_replace(" ","_",$data['call_action_button_color'])).'" button_inverse="false" size="'.strtolower($data['call_action_button_size']).'" icon="fa '.$data['call_action_button_icon'].'"]') ?>
                </div>

            </div>

        </div>
    <?php
    }
}

add_action( 'woocommerce_grouped_product_list_before_quantity', 'woocommerce_grouped_product_thumbnail' );

function woocommerce_grouped_product_thumbnail( $product ) {
    $image_size = array( 150, 150 );  
    $attachment_id = get_post_meta( $product->id, '_thumbnail_id', true );
    $attr = array('class' => 'grouped_image');
    ?>
    <td class="woocommerce_small_thumb">
        <?php echo wp_get_attachment_image( $attachment_id, $image_size, false, $attr ); ?>
     </td>
<?php
}