<?php

add_action('init','of_options');

if (!function_exists('of_options'))
{
	function of_options()
	{				
        //Register sidebar options for blog/portfolio/woocommerce category/archive pages
        global $wp_registered_sidebars;
        $sidebar_options[] = 'None';
        for($i=0;$i<1;$i++){
            $sidebars = $wp_registered_sidebars;// sidebar_generator::get_sidebars();
            //var_dump($sidebars);
            if(is_array($sidebars) && !empty($sidebars)){
                foreach($sidebars as $sidebar){
                    $sidebar_options[] = $sidebar['name'];
                }
            }
            $sidebars = sidebar_generator::get_sidebars();
            if(is_array($sidebars) && !empty($sidebars)){
                foreach($sidebars as $key => $value){
                    $sidebar_options[] = $value;
                }
            }
        }
        // End
		
		//Access the WordPress Categories via an Array
		$of_categories 		= array();  
		$of_categories_obj 	= get_categories('hide_empty=0');
		foreach ($of_categories_obj as $of_cat) {
		    $of_categories[$of_cat->cat_ID] = $of_cat->cat_name;}
		$categories_tmp 	= array_unshift($of_categories, "Select a category:");    
	       
		//Access the WordPress Pages via an Array
		$of_pages 			= array();
		$of_pages_obj 		= get_pages('sort_column=post_parent,menu_order');    
		foreach ($of_pages_obj as $of_page) {
		    $of_pages[$of_page->ID] = $of_page->post_name; }
		$of_pages_tmp 		= array_unshift($of_pages, "Select a page:");       
	
		//Testing 
		$of_options_select 	= array("one","two","three","four","five"); 
		$of_options_radio 	= array("one" => "One","two" => "Two","three" => "Three","four" => "Four","five" => "Five");
		$of_options_columns = array("col_one_fourth" => "Four Columns", "col_one_third" => "Three Columns", "col_half" => "Two Columns");
		$of_options_info = array("Left", "Center", "Right"); 
		$of_options_pt = array("Style 1", "Style 2");
		$of_options_effect = array("fade", "scroll", "crossfade", "cover", "cover-fade", "uncover", "uncover-fade");
		$of_options_autoplay = array("true", "false");
		$of_options_tb = array("left", "right");
		$of_options_animation = array("fade", "slide");
		$of_options_direction = array("horizontal", "vertical");
		
		//Sample Homepage blocks for the layout manager (sorter)
		$of_options_homepage_blocks = array
		( 
			"disabled" => array (
				"placebo" 		=> "placebo", //REQUIRED!
				"block_one"		=> "Block One",
				"block_two"		=> "Block Two",
				"block_three"	=> "Block Three",
			), 
			"enabled" => array (
				"placebo" 		=> "placebo", //REQUIRED!
				"block_four"	=> "Block Four",
			),
		);


		//Stylesheets Reader
		$alt_stylesheet_path = LAYOUT_PATH;
		$alt_stylesheets = array();
		
		if ( is_dir($alt_stylesheet_path) ) 
		{
		    if ($alt_stylesheet_dir = opendir($alt_stylesheet_path) ) 
		    { 
		        while ( ($alt_stylesheet_file = readdir($alt_stylesheet_dir)) !== false ) 
		        {
		            if(stristr($alt_stylesheet_file, ".css") !== false)
		            {
		                $alt_stylesheets[] = $alt_stylesheet_file;
		            }
		        }    
		    }
		}


		//Background Images Reader
		$bg_images_path = get_stylesheet_directory(). '/images/patterns/'; // change this to where you store your bg images
		$bg_images_url = get_template_directory_uri().'/images/patterns/'; // change this to where you store your bg images
		$bg_images = array();
		
		if ( is_dir($bg_images_path) ) {
		    if ($bg_images_dir = opendir($bg_images_path) ) { 
		        while ( ($bg_images_file = readdir($bg_images_dir)) !== false ) {
		            if(stristr($bg_images_file, ".png") !== false || stristr($bg_images_file, ".jpg") !== false) {
		                $bg_images[] = $bg_images_url . $bg_images_file;
		            }
		        }    
		    }
		}
		
		//Pattern overlay reader
		
		$bg_overlay_path = get_stylesheet_directory(). '/images/overlay/'; // change this to where you store your bg images
		$bg_overlay_url = get_template_directory_uri().'/images/overlay/'; // change this to where you store your bg images
		$bg_overlay = array();
		
		if ( is_dir($bg_overlay_path) ) {
		    if ($bg_overlay_dir = opendir($bg_overlay_path) ) { 
		        while ( ($bg_overlay_file = readdir($bg_overlay_dir)) !== false ) {
		            if(stristr($bg_overlay_file, ".png") !== false || stristr($bg_overlay_file, ".jpg") !== false) {
		                $bg_overlay[] = $bg_overlay_url . $bg_overlay_file;
		            }
		        }    
		    }
		}
		
		/*-----------------------------------------------------------------------------------*/
		/* TO DO: Add options/functions that use these */
		/*-----------------------------------------------------------------------------------*/
		
		//More Options
		$uploads_arr 		= wp_upload_dir();
		$all_uploads_path 	= $uploads_arr['path'];
		$all_uploads 		= get_option('of_uploads');
		$other_entries 		= array("Select a number:","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19");
		$body_repeat 		= array("no-repeat","repeat-x","repeat-y","repeat");
		$body_pos 			= array("top left","top center","top right","center left","center center","center right","bottom left","bottom center","bottom right");
		
		// Image Alignment radio box
		$of_options_thumb_align = array("alignleft" => "Left","alignright" => "Right","aligncenter" => "Center"); 
		
		// Image Links to Options
		$of_options_image_link_to = array("image" => "The Image","post" => "The Post"); 
		
		$font_sizes = array(
			'10' => '10',
			'11' => '11',
			'12' => '12',
			'13' => '13',
			'14' => '14',
			'15' => '15',
			'16' => '16',
			'17' => '17',
			'18' => '18',
			'19' => '19',
			'20' => '20',
			'21' => '21',
			'22' => '22',
			'23' => '23',
			'24' => '24',
			'25' => '25',
			'26' => '26',
			'27' => '27',
			'28' => '28',
			'29' => '29',
			'30' => '30',
			'31' => '31',
			'32' => '32',
			'33' => '33',
			'34' => '34',
			'35' => '35',
			'36' => '36',
			'37' => '37',
			'38' => '38',
			'39' => '39',
			'40' => '40',
			'41' => '41',
			'42' => '42',
		);

		// Get Google fonts array.
		$google_fonts = nv_get_google_fonts();
/*-----------------------------------------------------------------------------------*/
/* The Options Array */
/*-----------------------------------------------------------------------------------*/

// Set the Options Array
global $of_options;
$of_options = array();

$of_options[] = array( 	"name" 		=> "Logo",
						"type" 		=> "heading"
				);
/*				
$of_options[] = array( "name" => "Custom Favicon",
					"desc" => "You can put url of an ico image that will represent your website's favicon (16px x 16px)",
					"id" => "favicon",
					"std" => "",
					"type" => "upload");	
					
$of_options[] = array( "name" => "Default Sidebar Position",
					"desc" => "Select the defeault position of the sidebar.",
					"id" => "default_sidebar_pos",
					"std" => "right",
					"options" => array('right' => 'Right', 'left' => 'Left'),
					"type" => "select");

$of_options[] = array( "name" => "Tracking Code",
					"desc" => "Paste your Google Analytics (or other) tracking code here. This will be added into the footer template of your theme.",
					"id" => "google_analytics",
					"std" => "",
					"type" => "textarea");

$of_options[] = array( "name" => "Allow comments on pages",
					"desc" => "Allow comments on regular pages.",
					"id" => "comments_pages",
					"std" => 1,
					"type" => "checkbox");
*/	
$of_options[] = array( 	"name" 		=> "Favicon",
						"desc" 		=> "",
						"id" 		=> "favicon_sett",
						"std" 		=> "<h3>Favicon</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);	
$of_options[] = array(  "name" => "Favicon",
						"desc" => "Upload your custom favicon. Your favicon should be 16x16px. To generate a favicon you can visit <a href=\"http://tools.dynamicdrive.com/favicon/\" target = \"_blank\">Dynamic Drive</a>",
						"id" => "favicon",
						"std" => '',
						"collapse_sec"	=> "favicon_sett",
						"type" => "media");					
				
$of_options[] = array( 	"name" 		=> "Logo Settings",
						"desc" 		=> "",
						"id" 		=> "logo_settings",
						"std" 		=> "<h3>Logo Settings</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord admin_expand",
						"collapse"	=> true,
						"type" 		=> "info"
				);			
$of_options[] = array(  "name" => "Logo",
						"desc" => "Please choose an image file for your logo. <br>IMPORTANT: If no image is used, the default site title text will be used.",
						"id" => "logo",
						"std" => "",
						"collapse_sec"	=> "logo_settings",
						"type" => "media");	
						
$of_options[] = array(  "name" => "Retina Logo",
						"desc" => "Your Retina Logo should be twice the size of your normal logo. For example if your normal logo is: 113x97, your retina logo should be: 226x194 pixels. <br>IMPORTANT: If no image is used, the default site title text will be used.",
						"id" => "logo_retina",
						"std" =>"",
						"collapse_sec"	=> "logo_settings",
						"type" => "media");	
/*
$of_options[] = array(  "name" => "Retina Logo height",
						"desc" => "Set a height for the Retina logo. Leave blank to not use a custom height for Retina logo",
						"id" => "retina_logo_height",
						"std" => "70",
						"type" => "text");	
*/

$of_options[] = array( 	"name" 		=> "Transparent Header Logo ",
						"desc" 		=> "Upload a logo to be used with the Transparent Header. This is useful if you want to have a different logo for pages using the Transparent Header. ",
						"id" 		=> "transparent_logo",						
						"std" 		=> "",
						"type" 		=> "upload",
						"collapse_sec"	=> "logo_settings"
				);

$of_options[] = array( 	"name" 		=> "Transparent Header Retina Logo ",
						"desc" 		=> "Upload a Retina logo to be used with the Transparent Header. This is useful if you want to have a different logo for pages using the Transparent Header. The Transparent Retina Logo should be twice the size of the Transparent Logo.",
						"id" 		=> "transparent_retina_logo",						
						"std" 		=> "",
						"type" 		=> "upload",
						"collapse_sec"	=> "logo_settings"						
				);
					
$of_options[] = array(  "name" => "Logo resize",
						"desc" => "Force logo resize to a specified value",
						"id" => "logo_resize",
						"std" => 0,
						"folds" => 1,
						"collapse_sec"	=> "logo_settings",
						"type" => "switch");	
						
$of_options[] = array(  "name" => "Logo resize - height value in pixels",
						"desc" => "Set here the logo resize height. Default value: 97",
						"id" => "logo_resize_value",
						"std" => "97",
						"fold" => "logo_resize",
						"collapse_sec"	=> "logo_settings",
						"type" => "text");
						
$of_options[] = array(  "name" => "Sticky Header Logo ",
						"desc" => "Set here the sticky header logo height in pixels. Use a value that is lower than the height of your logo to create a nice shrinking effect when scrolling. Default value: 70",
						"id" => "sticky_header_logo",
						"std" => "",
						"collapse_sec"	=> "logo_settings",
						"type" => "text");												
						
$of_options[] = array( 	"name" 		=> "Text Logo Settings",
						"desc" 		=> "",
						"id" 		=> "text_logo_settings",
						"std" 		=> "<h3>Text Logo Settings</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);		
				
$of_options[] = array(  "name" => "Text Logo font family",
						"desc" => "Select a font family for the text logo",
						"id" => "text_logo_font",
						"std" => "Open Sans",
						"collapse_sec"	=> "text_logo_settings",
						"type" => "select_google_font",
						"preview" 	=> array(
										"text" => "My Text Logo", //this is the text from preview box
										"size" => "30px" //this is the text size from preview box
						),
						"options" => $google_fonts);
						
$of_options[] = array(  "name" => "Text Logo font size (px)",
						"desc" => "Default is 26px",
						"id" => "text_logo_font_size",
						"std" => "26",
						"type" => "select",
						"collapse_sec"	=> "text_logo_settings",
						"options" => $font_sizes);	
						
$of_options[] = array(  "name" =>  "Text Logo font color",
						"desc" => "",
						"id" => "text_logo_font_color",
						"std" => "#777777",
						"collapse_sec"	=> "text_logo_settings",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "Text Logo Margin Top",
						"desc" => "Default is 10px",
						"id" => "text_logo_margin_top",
						"std" => "10",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "50",
						"collapse_sec"	=> "text_logo_settings",
						"type" 		=> "sliderui" 
				);
				
$of_options[] = array( 	"name" => "Text Logo Margin Bottom",
						"desc" => "Default is 10px",
						"id" => "text_logo_margin_bottom",
						"std" => "10",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "50",
						"collapse_sec"	=> "text_logo_settings",
						"type" 		=> "sliderui" 
				);																																																

$of_options[] = array( 	"name" 		=> "Tagline",
						"desc" 		=> "",
						"id" 		=> "tagline_settings",
						"std" 		=> "<h3 >Tagline</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);
$of_options[] = array(  "name" => "Show Tagline",
						"desc" => "Only works if there is no image logo used.",
						"id" => "show_tagline",
						"std" => 0,
						"folds" => 1,
						"collapse_sec"	=> "tagline_settings",
						"type" => "switch");
					
$of_options[] = array( 	"name" 		=> "Tagline text",
						"id" 		=> "tagline_text",
						"std" 		=> "Ultimate WordPress Theme.",
						"fold"		=> "show_tagline",
						"collapse_sec"	=> "tagline_settings",
						"type" 		=> "textarea"
				);	
				
$of_options[] = array(  "name" => "Tagline position",
						"desc" => "Select the tagline positioning - this option only works for Header Version 3.",
						"id" => "tagline_pos",
						"std" => "right",
						"fold" => "show_tagline",
						"type" => "select",
						"collapse_sec"	=> "tagline_settings",
						"options" => array('left','right'));

						
$of_options[] = array( 	"name" => "Tagline font size (px)",
						"desc" => "Default is 16px",
						"id" => "tagline_font_size",
						"std" => "16",
						"min" 		=> "10",
						"step"		=> "1",
						"max" 		=> "50",
						"fold" 		=> "show_tagline",
						"collapse_sec"	=> "tagline_settings",
						"type" 		=> "sliderui" 
				);						
/*						
$of_options[] = array(  "name" => "Tagline text align",
						"desc" => "",
						"id" => "tagline_text_align",
						"std" => "right",
						"fold" => "show_tagline",
						"type" => "select",
						"options" => array('left','right'));													
*/				
$of_options[] = array(  "name" => "Tagline Font Family",
						"desc" => "Select a font family for the tagline text",
						"id" => "tagline_font",
						"std" => "Open Sans",
						"type" => "select_google_font",
						"fold" 	=> "show_tagline",
						"collapse_sec"	=> "tagline_settings",
						"preview" 	=> array(
										"text" => "Tagline preview text", //this is the text from preview box
										"size" => "20px" //this is the text size from preview box
						),
						"options" => $google_fonts);
						
$of_options[] = array(  "name" =>  "Tagline font Color",
						"desc" => "",
						"id" => "tagline_font_color",
						"std" => "#777777",
						"fold" 	=> "show_tagline",
						"collapse_sec"	=> "tagline_settings",
						"type" => "color");						
						
$of_options[] = array( 	"name" 		=> "Margin Top",
						"desc" 		=> "",
						"id" 		=> "tagline_margin_top",
						"std" 		=> "40",
						"min" 		=> "0",
						"step"		=> "5",
						"max" 		=> "80",
						"fold" 		=> "show_tagline",
						"collapse_sec"	=> "tagline_settings",
						"type" 		=> "sliderui" 
				);
				
$of_options[] = array( 	"name" 		=> "General Settings",
						"type" 		=> "heading"
				);

$of_options[] = array( 	"name" 		=> "Generat Settings",
						"desc" 		=> "",
						"id" 		=> "general_settings",
						"std" 		=> "<h3>General Settings.</h3>",
						"icon" 		=> true,						
						"class" 	=>"hide_me admin_accord admin_expand",
						"collapse"	=> true,
						"type" 		=> "info"
				);
/*	
$of_options[] = array( 	"name" 		=> "Disable Integrated Visual Composer ",
						"desc" 		=> "Allows you to disable the integrated Visual Composer. Enable this option if you own an original license of Visual Composer and plan to use it.",
						"id" 		=> "disable_visual_composer",
						"std" 		=> 0,
						"type" 		=> "switch"
				);					
*/
$of_options[] = array(  "name" =>  "Website Top Border Width",
						"desc" => "",
						"id" => "wrapper_top_border",
						"std" 		=> "3",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "10",
						"collapse_sec"	=> "general_settings",
						"type" 		=> "sliderui");	
						
$of_options[] = array(  "name" =>  "Website Top Border Color",
						"desc" => "",
						"id" => "wrapper_top_border_color",
						"std" => "#f96e5b",
						"collapse_sec"	=> "general_settings",
						"type" => "color");				
				
$of_options[] = array(  "name" => "Sidebar Position",
						"desc" => "Select the default Sidebar Position",
						"id" => "sidebar_position",
						"std" => "Right",
						"type" => "select",
						"collapse_sec"	=> "general_settings",
						"options" => array(						
							'left' => 'Left',
							'right' => 'Right',
				));	
							
				
$of_options[] = array( 	"name" 		=> "Featured Images",
						"desc" 		=> "How many featured images to be used for posts, pages and portfolio items",
						"id" 		=> "featured_images",
						"std" 		=> "5",
						"min" 		=> "1",
						"step"		=> "1",
						"max" 		=> "30",
						"collapse_sec"	=> "general_settings",
						"type" 		=> "sliderui" 
				);	
				
$of_options[] = array( 	"name" 		=> "Smooth Scrolling",
						"desc" 		=> "Enable / Disable smooth srolling and styled scrollbar.",
						"id" 		=> "smooth_scrolling",
						"std" 		=> 1,
						"collapse_sec"	=> "general_settings",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> "Page Loading Effect",
						"desc" 		=> "Enable / Disable page loading effect.",
						"id" 		=> "loading_effect",
						"std" 		=> 0,
						"collapse_sec"	=> "general_settings",
						"folds"		=> 1,
						"type" 		=> "switch"
				);

$of_options[] = array(  "name" =>  "Page Loading Spinner Color",
						"desc" => "Choose the color of the Page Loading Spinner",
						"id" => "loading_effect_color",
						"std" => "#e82525",
						"collapse_sec"	=> "general_settings",
						"fold"	=> "loading_effect",
						"type" => "color");	
/*
$of_options[] = array( 	"name" 		=> "WOW Animation",
						"desc" 		=> "Enable / Disable wow animations.",
						"id" 		=> "wow_animations",
						"std" 		=> 0,
						"collapse_sec"	=> "general_settings",
						"type" 		=> "switch"
				);
*/	

$of_options[] = array( 	"name" 		=> "Default Page Template show Title",
						"desc" 		=> "Enable / Disable the Title for the Default Page Template.",
						"id" 		=> "dpt_title",
						"std" 		=> 1,
						"collapse_sec"	=> "general_settings",
						"type" 		=> "switch"
				);				
$of_options[] = array( 	"name" 		=> "Responsiveness",
						"desc" 		=> "Enable / Disable responsive layout.",
						"id" 		=> "responsive",
						"std" 		=> 1,
						"collapse_sec"	=> "general_settings",
						"type" 		=> "switch"
				);		
				
$of_options[] = array( 	"name" 		=> "Tracking Code / Header Code / Body Code",
						"desc" 		=> "",
						"id" 		=> "tracking_code_settings",
						"std" 		=> "<h3>Tracking Code / Header Code / Body Code</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);	
				
$of_options[] = array(  "name" => "Tracking Code",
						"desc" => "Paste your Google Analytics (or other) tracking code here. Please put code inside script tags.",
						"id" => "tracking_code",
						"std" => '',
						"collapse_sec"	=> "tracking_code_settings",
						"type" => "textarea");	
						
$of_options[] = array(  "name" => "Code before &lt;/head&gt;",
						"desc" => "Add code before the closing &lt;/head&gt; tag.",
						"id" => "head_code",
						"std" => '',
						"collapse_sec"	=> "tracking_code_settings",
						"type" => "textarea");	
						
$of_options[] = array(  "name" => "Code before &lt;/body&gt;",
						"desc" => "Add code before the closing &lt;/body&gt; tag.",
						"id" => "body_code",
						"std" => '',
						"collapse_sec"	=> "tracking_code_settings",
						"type" => "textarea");							

$of_options[] = array( 	"name" 		=> "Top Bar",
						"type" 		=> "heading"
				);	

$of_options[] = array( 	"name" 		=> "Top Bar",
						"desc" 		=> "",
						"id" 		=> "top_bar_content",
						"std" 		=> "<h3>Top Bar Content Area</h3>",
						"icon" 		=> true,						
						"class" 	=>"hide_me admin_accord admin_expand",
						"collapse"	=> true,
						"type" 		=> "info"
				);	
										
				
$of_options[] = array( "name" => "Header Top Bar Left Content",
					"desc" => "",
					"id" => "header_left_content",
					"std" => "Contact Info",
					"type" => "select",
					"collapse_sec"	=> "top_bar_content",
					"options" => array('contactinfo' => 'Contact Info', 'socialinks' => 'Social Links', 'nav' => 'Top Menu', 'empty' => 'Leave Empty'));	

$of_options[] = array( "name" => "Header Top Bar Right Content",
					"desc" => "",
					"id" => "header_right_content",
					"std" => "Social Links",
					"type" => "select",
					"collapse_sec"	=> "top_bar_content",
					"options" => array('contactinfo' => 'Contact Info', 'socialinks' => 'Social Links', 'nav' => 'Top Menu', 'empty' => 'Leave Empty'));								
	
$of_options[] = array( 	"name" 		=> "Header Contact Info",
						"desc" 		=> "",
						"id" 		=> "header_soc_prof",
						"std" 		=> "<h3>Top Bar Contact Info</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);	
$of_options[] = array(  "name" => "Phone Number",
						"desc" => "",
						"id" => "header_number",
						"std" => "Call Us Now! 1.555.800.800",
//						"fold" => "header_contact",
						"collapse_sec"	=> "header_soc_prof",
						"type" => "text");
						
$of_options[] = array(  "name" => "Phone Number Icon",
						"desc" => "",
						"id" => "header_number_icon",
						"std" => "fa-phone",
						"collapse_sec"	=> "header_soc_prof",
//						"fold" => "header_contact",
						"type" => "text");	
						
$of_options[] = array(  "name" => "Email Address",
						"desc" => "",
						"id" => "header_email",
						"std" => "hello@yoursite.com",
//						"fold" => "header_contact",
						"collapse_sec"	=> "header_soc_prof",
						"type" => "text");
						
$of_options[] = array(  "name" => "Email Icon",
						"desc" => "",
						"id" => "header_email_icon",
						"std" => "fa-envelope",
//						"fold" => "header_contact",
						"collapse_sec"	=> "header_soc_prof",
						"type" => "text");	

$of_options[] = array(  "name" => "Contact Address",
						"desc" => "",
						"id" => "header_contact_address",
						"std" => "1600 Amphitheatre Parkway, CA, 94043",
//						"fold" => "header_contact",
						"collapse_sec"	=> "header_soc_prof",
						"type" => "text");

$of_options[] = array(  "name" => "Contact Address Icon",
						"desc" => "",
						"id" => "header_address_icon",
						"std" => "fa-map-marker-alt",
//						"fold" => "header_contact",
						"collapse_sec"	=> "header_soc_prof",
						"type" => "text");	
						
$of_options[] = array( 	"name" 		=> "Tap to Call Button",
						"desc" 		=> "",
						"id" 		=> "tap_to_call_button",
						"std" 		=> "<h3>Tap to Call Button</h3>This will add a Tap to Call Button, but only on mobile devices - phones!",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);
								
						
$of_options[] = array(  "name" => "Tap to Call",
						"desc" => "Enable Tap to Call Action",
						"id" => "en_tapcall",
						"std" => 1,
						"folds" => 1,
						"collapse_sec"	=> "tap_to_call_button",
						"type" => "switch");
					
$of_options[] = array( 	"name" 		=> "Button text",
						"desc"		=> "Enter the text that will appear on the tap to call button",
						"id" 		=> "tapcall_button",
						"std" 		=> "Tap to Call",
						"fold"		=> "en_tapcall",
						"collapse_sec"	=> "tap_to_call_button",
						"type" 		=> "text"
				);
				
$of_options[] = array(  "name" => "Tap to Call Phone Number",
						"desc" => "Should be the same as the one you enter above",
						"id" => "tapcall_ph_number",
						"std" => "1.555.800.800",
						"fold" => "en_tapcall",
						"collapse_sec"	=> "tap_to_call_button",
						"type" => "text");	
						
$of_options[] = array(  "name" => "Tap to Call Button Style",
						"desc" => "",
						"id" => "tapcall_style",
						"std" => "minimal",
						"type" => "select",
						"collapse_sec"	=> "tap_to_call_button",
						"options" => array('minimal' => 'Minimal', '3d' => '3D'));							
						
$of_options[] = array(  "name" => "Tap to Call Button Color",
						"desc" => "Select the color of the Tap to Call button",
						"id" => "tapcall_color",
						"std" => "lightred",
						"type" => "select",
						"collapse_sec"	=> "tap_to_call_button",
						"options" => array( 'lightred' => 'Light Red',
											'darkred' => 'Dark Red',  
											'orange' => 'Orange',  
											'turquoise' => 'Turquoise',
											'emerald' => 'Emerald',
											'lightblue' => 'Light Blue',
											'amethyst' => 'Amethyst',
											'wetasphalt' => 'Wet Asphalt',
											'light' => 'Light',
											'dark' => 'Dark'
									 ));	
																								
$of_options[] = array(  "name" => "Tap to Call Button Size",
						"desc" => "Select the size of the Tap to Call button",
						"id" => "tapcall_size",
						"std" => "small",
						"type" => "select",
						"collapse_sec"	=> "tap_to_call_button",
						"options" => array('small' => 'Small', 'large' => 'Large'));


						
$of_options[] = array( 	"name" 		=> "Header Top Bar",
						"desc" 		=> "",
						"id" 		=> "header_top_bar",
						"std" 		=> "<h3>Top Bar Colors</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);	

$of_options[] = array(  "name" =>  "Header Top Bar Background Color",
						"desc" => "",
						"id" => "header_contact_bg",
						"std" => "#f7f7f7",
						"collapse_sec"	=> "header_top_bar",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Header Top Bar Border Width",
						"desc" => "",
						"id" => "header_top_bar_bw",
						"std" 		=> "1",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "5",
						"collapse_sec"	=> "header_top_bar",
						"type" 		=> "sliderui");	
						
$of_options[] = array(  "name" =>  "Header Top Bar Border Color",
						"desc" => "",
						"id" => "header_top_bar_bc",
						"std" => "#e8e8e8",
						"collapse_sec"	=> "header_top_bar",
						"type" => "color");							
																										

$of_options[] = array(  "name" =>  "Header Top Bar Text/Link Color",
						"desc" => "",
						"id" => "header_contact_text_color",
						"std" => "#777777",
						"collapse_sec"	=> "header_top_bar",
						"type" => "color");				
						
$of_options[] = array(  "name" =>  "Header Top Bar Link Color Hover",
						"desc" => "",
						"id" => "header_contact_link_color",
						"std" => "#f96e5b",
						"collapse_sec"	=> "header_top_bar",
						"type" => "color");		
						
$of_options[] = array(  "name" =>  "Header Contact Info Separator Color",
						"desc" => "",
						"id" => "header_contact_separator_color",
						"std" => "#e8e8e8",
						"collapse_sec"	=> "header_top_bar",
						"type" => "color");																																																																			

$of_options[] = array( 	"name" 		=> "Header Settings",
						"type" 		=> "heading"
				);
$of_options[] = array( 	"name" 		=> "Header Layout",
						"desc" 		=> "",
						"id" 		=> "header_layout_setting",
						"std" 		=> "<h3>Header Layout</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord admin_expand",
						"collapse"	=> true,
						"type" 		=> "info"
				);				
$of_options[] = array( "name" => "Select a Header Layout",
                    "desc" => "",
                    "id" => "header_layout",
                    "std" => "v1",
                    "type" => "images",
                    "collapse_sec"	=> "header_layout_setting",
                    "options" => array(
                        "v1" => get_bloginfo('template_directory')."/images/header/header1.jpg",
                        "v2" => get_bloginfo('template_directory')."/images/header/header2.jpg",
						"v3" => get_bloginfo('template_directory')."/images/header/header3.jpg",
						"v4" => get_bloginfo('template_directory')."/images/header/header4.jpg",
						"v5" => get_bloginfo('template_directory')."/images/header/header5.jpg",
						"v6" => get_bloginfo('template_directory')."/images/header/header6.jpg",
						"v7" => get_bloginfo('template_directory')."/images/header/header7.jpg"
                ));	
				
										
				
							
/*
$of_options[] = array( 	"name" 		=> "Header Social Profiles",
						"desc" 		=> "Enable or disable social profiles.",
						"id" 		=> "off_social",
						"std" 		=> 1,
						"folds" 	=> 1,
						"type" 		=> "switch"
				);
*/		
																						

$of_options[] = array( 	"name" 		=> "Header Design Options",
						"desc" 		=> "",
						"id" 		=> "header_design_options",
						"std" 		=> "<h3>Header Design Options</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);	

$of_options[] = array(  "name" => "Header Width",
						"desc" => "",
						"id" => "header_width",
						"std" => "normal",
						"type" => "select",
						"collapse_sec"	=> "header_design_options",
						"options" => array(
							"default" => "Default",
							"expanded" => "Expanded"
						));	

				
$of_options[] = array(  "name" =>  "Header Background Color",
						"desc" => "",
						"id" => "header_bg",
						"std" => "#fff",
						"collapse_sec"	=> "header_design_options",
						"type" => "color");	
						
$of_options[] = array( 	"name" 		=> "Header Background pattern",
						"desc" 		=> "Enable/Disable Header Background Pattern.",
						"id" 		=> "header_bg_pattern_en",
						"std" 		=> 0,
						"folds" 	=> 1,
						"collapse_sec"	=> "header_design_options",
						"type" 		=> "switch"
				);												

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "Select a background pattern for the header.",
						"id" 		=> "header_bg_pattern",
						"std" 		=> $bg_images_url."bg1.png",
						"type" 		=> "tiles",
						"fold"		=> "header_bg_pattern_en",
						"collapse_sec"	=> "header_design_options",
						"options" 	=> $bg_images,
				);		
				
$of_options[] = array( 	"name" 		=> "Custom Background Image Upload",
						"desc" 		=> "Upload or select an existing image to use for the header background.",
						"id" 		=> "header_custom_bg_image",
						"collapse_sec"	=> "header_design_options",
						// Use the shortcodes [site_url] or [site_url_secure] for setting default URLs
						"std" 		=> "",
						"type" 		=> "upload"
				);
				
$of_options[] = array(  "name" => "Header Custom Background Image Repeat",
						"desc" => "",
						"id" => "header_custom_bg_repeat",
						"std" => "2",
						"collapse_sec"	=> "header_design_options",
						"type" => "select",
						"options" => array('no-repeat' => 'no-repeat', 'repeat' => 'repeat', 'repeat-x' => 'repeat-x', 'repeat-y' => 'repeat-y'));	
						
$of_options[] = array( 	"name" 		=> "Header Top Border",
						"id" 		=> "header_border_top",
						"std" 		=> "0",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "10",
						"collapse_sec"	=> "header_design_options",
						"type" 		=> "sliderui" 
				);
				
$of_options[] = array(  "name" =>  "Header Top Border Color",
						"desc" => "",
						"id" => "header_border_top_color",
						"std" => "#ccc",
						"collapse_sec"	=> "header_design_options",
						"type" => "color");					
				
$of_options[] = array( 	"name" 		=> "Header Bottom Border",
						"id" 		=> "header_border_bottom",
						"std" 		=> "1",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "10",
						"collapse_sec"	=> "header_design_options",
						"type" 		=> "sliderui" 
				);	
				
$of_options[] = array(  "name" =>  "Header Bottom Border Color",
						"desc" => "",
						"id" => "header_border_bottom_color",
						"std" => "#e8e8e8",
						"collapse_sec"	=> "header_design_options",
						"type" => "color");																							

$of_options[] = array( 	"name" 		=> "Header V2/V3 Design Options",
						"desc" 		=> "",
						"id" 		=> "header_design_options_v2_v3",
						"std" 		=> "<h3>Header V2/V3 Design Options</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);
				
				
$of_options[] = array( 	"name" 		=> "Header V2/V3 Menu Top Border",
						"id" 		=> "header_v23_menu_border_top",
						"std" 		=> "1",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "10",
						"collapse_sec"	=> "header_design_options_v2_v3",
						"type" 		=> "sliderui" 
				);
				
$of_options[] = array(  "name" =>  "Header V2/V3 Menu Top Border Color",
						"desc" => "",
						"id" => "header_v23_menu_border_top_color",
						"std" => "#e8e8e8",
						"collapse_sec"	=> "header_design_options_v2_v3",
						"type" => "color");

$of_options[] = array( 	"name" 		=> "Header V2/V3 Menu Top Border Transparency",
						"id" 		=> "header_v23_menu_border_top_trans",
						"std" 		=> "20",
						"desc" => "Set the transparancy of the Top Border when the Transparent Header is enabled. Defaul is 20%.",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "100",
						"collapse_sec"	=> "header_design_options_v2_v3",
						"type" 		=> "sliderui" 
				);						
						
$of_options[] = array(  "name" => "Header V3 Banner Code",
						"desc" => "Paste here the html code for Header V3. The banner or image will display in Header V3 if the Show Tagline (Logo Options) is turned off",
						"id" => "header_v3_banner",
						"std" => '',
						"collapse_sec"	=> "header_design_options_v2_v3",
						"type" => "textarea");										

$of_options[] = array( 	"name" 		=> "Header Extra Options",
						"desc" 		=> "",
						"id" 		=> "header_extra_options",
						"std" 		=> "<h3>Header Extra Options</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);

$of_options[] = array( 	"name" 		=> "Sticky Header",
						"desc" 		=> "Enabling this option will allow the header section to become fixed on user scroll.",
						"id" 		=> "floating_header",
						"std" 		=> 1,
						"folds" 	=> 1,
						"collapse_sec"	=> "header_extra_options",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" 		=> "Sticky Header Resize",
						"desc" 		=> "Enabling this option will make the sticky header resizable on scroll.",
						"id" 		=> "header_resize",
						"std" 		=> 1,
						"folds" 	=> 1,
						"collapse_sec"	=> "header_extra_options",
						"type" 		=> "switch"
				);	
				
$of_options[] = array( 	"name" 		=> "Transparent Sticky Header",
						"desc" 		=> "Enabling this option will make the sticky header background transparent, but keeping the background color.",
						"id" 		=> "transp_floating_header",
						"std" 		=> 1,
						"folds" 	=> 1,
						"collapse_sec"	=> "header_extra_options",
						"type" 		=> "switch"
				);	

																
$of_options[] = array(  "name" => "Menu Transparency",
						"desc" => "Enable or disable menu transparency.",
						"id" => "en_menu_transparent",
						"std" => 1,
						"folds" => 1,
						"collapse_sec"	=> "header_extra_options",
						"type" => "switch");							
				
$of_options[] = array( 	"name" 		=> "Header Shadow",
						"desc" 		=> "Enabling this option will add a shadow effect just bellow the header.",
						"id" 		=> "shadow_header",
						"std" 		=> 1,
						"folds" 	=> 1,
						"collapse_sec"	=> "header_extra_options",
						"type" 		=> "switch"
				);				

//Social Media

$of_options[] = array(	"name"		=> "Social Media",
						"type"		=> "heading"
				);

$of_options[] = array( 	"name" 		=> "Header Top Bar Social Profiles",
						"desc" 		=> "",
						"id" 		=> "header_top_bar_soc_prof",
						"std" 		=> "<h3>Header Top Bar Social Media Profiles</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord admin_expand",
						"collapse"	=> true,
						"type" 		=> "info"
				);		

$of_options[] = array(  "name" =>  "Header Social Profiles Color",
						"desc" => "",
						"id" => "header_sp_color",
						"std" => "#4a4a4a",
						"collapse_sec"	=> "header_top_bar_soc_prof",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Header Social Profiles Background Color Hover",
						"desc" => "",
						"id" => "header_sp_bg_hover",
						"std" => "#f96e5b",
						"collapse_sec"	=> "header_top_bar_soc_prof",
						"type" => "color");	
/*
$of_options[] = array(  "name" => "Header Social Profiles Color Scheme",
						"desc" => "",
						"id" => "social_prof_cs",
						"std" => "dark",
						"type" => "select",
						"options" => array('dark','light'));	
						
$of_options[] = array(  "name" => "Header Social Profiles Color Scheme on Hover",
						"desc" => "",
						"id" => "social_prof_cs_hover",
						"std" => "light",
						"type" => "select",
						"options" => array('dark','light'));				
*/				
$of_options[] = array( 	"name" 		=> "Header Soc Prof",
						"desc" 		=> "",
						"id" 		=> "header_soc_prof_icons",
						"std" 		=> "<h3>Social Media Profiles</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);	
		
$of_options[] = array( "name" => "Facebook",
					"desc" => "Place the link to your facebook profile/page. To remove it, just leave it blank.",
					"id" => "facebook_link",
					"std" => "facebook link here",
//					"fold" => "off_social",
					"collapse_sec"	=> "header_soc_prof_icons",
					"type" => "text");	

$of_options[] = array( "name" => "Twitter",
					"desc" => "Place the link to your twitter profile/page. To remove it, just leave it blank.",
					"id" => "twitter_link",
					"std" => "twitter link here",
//					"fold" => "off_social",
					"collapse_sec"	=> "header_soc_prof_icons",
					"type" => "text");
					
$of_options[] = array( "name" => "Google Plus",
					"desc" => "Place the link to your google plus profile/page. To remove it, just leave it blank.",
					"id" => "gplus_link",
					"std" => "gplus link here",
//					"fold" => "off_social",
					"collapse_sec"	=> "header_soc_prof_icons",
					"type" => "text");
					
$of_options[] = array( "name" => "Instagram",
					"desc" => "Place the link to your instagram profile/page. To remove it, just leave it blank.",
					"id" => "instagram_link",
					"std" => "instagram link here",
//					"fold" => "off_social",
					"collapse_sec"	=> "header_soc_prof_icons",
					"type" => "text");					
					
$of_options[] = array( "name" => "Dribbble",
					"desc" => "Place the link to your dribble profile/page. To remove it, just leave it blank.",
					"id" => "dribbble_link",
					"std" => "",
					"collapse_sec"	=> "header_soc_prof_icons",
//					"fold" => "off_social",
					"type" => "text");

$of_options[] = array( "name" => "TikTok",
					"desc" => "Place the link to your Tiktok profile/page. To remove it, just leave it blank.",
					"id" => "tiktok_link",
					"std" => "",
					"collapse_sec"	=> "header_soc_prof_icons",
//					"fold" => "off_social",
					"type" => "text");					

$of_options[] = array( "name" => "Pinterest",
					"desc" => "Place the link to your pinterest profile/page. To remove it, just leave it blank.",
					"id" => "pinterest_link",
					"std" => "",
					"collapse_sec"	=> "header_soc_prof_icons",
//					"fold" => "off_social",
					"type" => "text");
					
$of_options[] = array( "name" => "Tumblr",
					"desc" => "Place the link to your tumblr profile/page. To remove it, just leave it blank.",
					"id" => "tumblr_link",
					"std" => "",
//					"fold" => "off_social",
					"collapse_sec"	=> "header_soc_prof_icons",
					"type" => "text");
					
$of_options[] = array( "name" => "Skype",
					"desc" => "Place the link to your skype profile/page. To remove it, just leave it blank.",
					"id" => "skype_link",
					"std" => "",
//					"fold" => "off_social",
					"collapse_sec"	=> "header_soc_prof_icons",
					"type" => "text");
					
$of_options[] = array( "name" => "Vimeo",
					"desc" => "Place the link to your vimeo profile/page. To remove it, just leave it blank.",
					"id" => "vimeo_link",
					"std" => "",
					"collapse_sec"	=> "header_soc_prof_icons",
//					"fold" => "off_social",
					"type" => "text");
					
$of_options[] = array( "name" => "Youtube",
					"desc" => "Place the link to your youtube profile/page. To remove it, just leave it blank.",
					"id" => "youtube_link",
					"std" => "",
//					"fold" => "off_social",
					"collapse_sec"	=> "header_soc_prof_icons",
					"type" => "text");	
					
$of_options[] = array( "name" => "LinkedIn",
					"desc" => "Place the link to your linkedin profile/page. To remove it, just leave it blank.",
					"id" => "linkedin_link",
					"std" => "",
//					"fold" => "off_social",
					"collapse_sec"	=> "header_soc_prof_icons",
					"type" => "text");	
					
$of_options[] = array( "name" => "Flickr",
					"desc" => "Place the link to your flickr profile/page. To remove it, just leave it blank.",
					"id" => "flickr_link",
					"std" => "",
//					"fold" => "off_social",
					"collapse_sec"	=> "header_soc_prof_icons",
					"type" => "text");	
					
$of_options[] = array( "name" => "Behance",
					"desc" => "Place the link to your behance profile/page. To remove it, just leave it blank.",
					"id" => "behance_link",
					"std" => "",
//					"fold" => "off_social",
					"collapse_sec"	=> "header_soc_prof_icons",
					"type" => "text");																																											
				
//Menu Settings
$of_options[] = array( 	"name" 		=> "Menu options",
						"type" 		=> "heading"
				);

$of_options[] = array(  "name" => "Menu Style - First Level",
						"desc" => "",
						"id" => "menu_style_first",
						"std" => "<h3>Menu Style - First Level</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord admin_expand",
						"collapse"	=> true,
						"type" => "info");										

$of_options[] = array(  "name" => "Menu Force Uppercase",
						"desc" => "Force uppercase letters on the First Level menu.",
						"id" => "menu_first_up",
						"std" => 0,		
						"collapse_sec"	=> "menu_style_first",
						"type" => "switch");

$of_options[] = array(  "name" => "Sub-Menu Force Uppercase",
						"desc" => "Force uppercase letters on the Sub-Menu Items.",
						"id" => "menu_second_up",
						"std" => 0,		
						"collapse_sec"	=> "menu_style_first",
						"type" => "switch");

$of_options[] = array(  "name" => "Sub-Menu Icon Indicator",
						"desc" => "Choose to show or hide the sub-menu icon indicator.",
						"id" => "subindicator_en",
						"std" => 1,		
						"collapse_sec"	=> "menu_style_first",
						"type" => "switch");

$of_options[] = array(  "name" => "Menu Line Height",
						"desc" => "Enter the line height for the Menu. Default is 97px",
						"id" => "menu_first_line_height",
						"std" => "97px",
						"collapse_sec"	=> "menu_style_first",	
//						"fold" => "header_contact",
						"type" => "text");

$of_options[] = array(  "name" => "Menu Font Weight",
						"desc" => "",
						"id" => "menu_first_font_weight",
						"std" => "400",
						"collapse_sec"	=> "menu_style_first",	
						"type" => "select",
						"options" => array('300', '400', '500', '600', '700'));	

$of_options[] = array(  "name" =>  "Menu Text Color - First Level",
						"desc" => "",
						"id" => "menu_first_color",
						"std" => "#444444",
						"collapse_sec"	=> "menu_style_first",	
						"type" => "color");
						
$of_options[] = array(  "name" =>  "Menu Text Color on Hover - First Level",
						"desc" => "",
						"id" => "menu_first_color_hover",
						"std" => "#444444",
						"collapse_sec"	=> "menu_style_first",	
						"type" => "color");						
					
$of_options[] = array(  "name" =>  "Menu Background Color Hover - First Level",
						"desc" => "",
						"id" => "menu_first_bg_color_hover",
						"std" => "#ffffff",
						"collapse_sec"	=> "menu_style_first",	
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Menu Border Color Hover - Sublevels",
						"desc" => "",
						"id" => "menu_border_color_hover",
						"std" => "#f96e5b",
						"collapse_sec"	=> "menu_style_first",	
						"type" => "color");

$of_options[] = array(  "name" => "Menu Item Hover Effect",
						"desc" => "Choose to show or hide a small animated border below the menu items text, on hover.",
						"id" => "menu_border_effect",
						"std" => 0,
						"folds" =>1,
						"collapse_sec"	=> "menu_style_first",
						"type" => "switch");

$of_options[] = array(  "name" =>  "Menu Item Hover Effect Color",
						"desc" => "Select the color of the small animated border below the menu items text, on hover",
						"id" => "menu_border_effect_color",
						"std" => "#34495e",
						"collapse_sec"	=> "menu_style_first",	
						"fold" => "menu_border_effect",
						"type" => "color");

$of_options[] = array(  "name" => "Transparent Header - Menu Colors",
						"desc" => "",
						"id" => "transparent_menu_colors",
						"std" => "<h3>Transparent Header - Menu Colors</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");

$of_options[] = array(  "name" =>  "Transparent Header Menu Color",
						"desc" => "",
						"id" => "transparent_menu_tc",
						"std" => "#f2f2f2",
						"collapse_sec"	=> "transparent_menu_colors",	
						"type" => "color");
						
$of_options[] = array(  "name" =>  "Transparent Header Menu Color on Hover",
						"desc" => "",
						"id" => "transparent_menu_tc_hover",
						"std" => "#dd3333",
						"collapse_sec"	=> "transparent_menu_colors",	
						"type" => "color");

$of_options[] = array(  "name" => "Menu Style - Sublevels",
						"desc" => "",
						"id" => "menu_style_sublevel",
						"std" => "<h3>Menu Style - Sublevels + Megamenu</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	

$of_options[] = array(  "name" => "Sub-Menu Font Weight",
						"desc" => "",
						"id" => "sub_menu_font_weight",
						"std" => "400",
						"collapse_sec"	=> "menu_style_sublevel",	
						"type" => "select",
						"options" => array('300', '400', '500', '600', '700'));																	

$of_options[] = array(  "name" =>  "Menu Text Color - Sublevels",
						"desc" => "",
						"id" => "menu_sub_color",
						"std" => "#444444",
						"collapse_sec"	=> "menu_style_sublevel",
						"type" => "color");

$of_options[] = array(  "name" =>  "Menu Text Color Hover - Sublevels",
						"desc" => "",
						"id" => "menu_sub_color_hover",
						"std" => "#ffffff",
						"collapse_sec"	=> "menu_style_sublevel",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Menu Background Color - Sublevels",
						"desc" => "",
						"id" => "menu_sub_bg_color",
						"std" => "#ffffff",
						"collapse_sec"	=> "menu_style_sublevel",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Menu Background Color Hover - Sublevels ",
						"desc" => "",
						"id" => "menu_sub_bg_color_hover",
						"std" => "#313131",
						"collapse_sec"	=> "menu_style_sublevel",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Menu Separator Color (Lines)",
						"desc" => "",
						"id" => "menu_separators_color",
						"std" => "#f2f2f2",
						"collapse_sec"	=> "menu_style_sublevel",
						"type" => "color");	
						
$of_options[] = array(  "name" => "Megamenu",
						"desc" => "",
						"id" => "megamenu_colors",
						"std" => "<h3>Megamenu</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");						
						
$of_options[] = array(  "name" =>  "MegaMenu Heading Links Color",
						"desc" => "",
						"id" => "mm_headings",
						"std" => "#000",
						"collapse_sec"	=> "megamenu_colors",
						"type" => "color");
						
$of_options[] = array(  "name" =>  "MegaMenu Heading Links Color on Hover",
						"desc" => "",
						"id" => "mm_headings_hover",
						"std" => "#f96e5b",
						"collapse_sec"	=> "megamenu_colors",
						"type" => "color");	

$of_options[] = array( 	"name" 		=> "Header V2/V3 Menu",
						"desc" 		=> "",
						"id" 		=> "header_v23_menu",
						"std" 		=> "<h3>Header V2/V3 Menu Options</h3>",
						"icon" 		=> true,						
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);				
				
$of_options[] = array( 	"name" 		=> "Header V2/V3 Menu Height",
						"id" 		=> "header_v23_menu_height",
						"std" 		=> "50",
						"min" 		=> "20",
						"step"		=> "1",
						"max" 		=> "120",
						"collapse_sec"	=> "header_v23_menu",
						"type" 		=> "sliderui" 
				);	
				
$of_options[] = array(  "name" =>  "Header V2/V3 Background Color",
						"desc" => "",
						"id" => "menu_v23_bg",
						"std" => "#ffffff",
						"collapse_sec"	=> "header_v23_menu",
						"type" => "color");								
				
$of_options[] = array(  "name" => "Dropdown Menu",
						"desc" => "",
						"id" => "dropdown_menu",
						"std" => "<h3>Dropdown Menu</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");					
				
$of_options[] = array( 	"name" 		=> "Dropdown Menu Width (px)",
						"desc"		=> "You can enter your own value for the Dropdown Menu Width, in pixels!",
						"id" 		=> "dropdown_mw",
						"std" 		=> "200",
						"min" 		=> "100",
						"step"		=> "5",						
						"max" 		=> "400",
						"collapse_sec"	=> "dropdown_menu",
						"type" 		=> "sliderui" 
				);	

$of_options[] = array(  "name" => "WooCommerce ",
						"desc" => "",
						"id" => "woocommerce_shopping_icon",
						"std" => "<h3>WooCommerce Shopping Cart Icon</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	
						
$of_options[] = array(  "name" => "",
						"desc" => "Add shopping cart icon to main menu.<br>Will only work if you have WooCommerce plugin installed.",
						"id" => "woocommerce_item",
						"std" => 1,
						"folds" => 1,
						"collapse_sec"	=> "woocommerce_shopping_icon",
						"type" => "switch");

$of_options[] = array(  "name" => "Header Search ",
						"desc" => "",
						"id" => "header_search",
						"std" => "<h3>Header Search</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	
						
$of_options[] = array(  "name" => "Add Search Option to Main Menu",
						"desc" => "Enable this option to add search icon to main menu",
						"id" => "main_menu_search",
						"std" => 0,	
						"collapse_sec"	=> "header_search",					
						"type" => "switch");
						
				
$of_options[] = array(  "name" => "Mobile Menu",
						"desc" => "",
						"id" => "mob_menu_settings",
						"std" => "<h3>Mobile Menu</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	
						
$of_options[] = array(  "name" => "Mobile Menu Text",
						"desc" => "Enter the text you want to use for the mobile menu.",
						"id" => "mob_menu_text",
						"std" => "Menu",
						"collapse_sec"	=> "mob_menu_settings",
//						"fold" => "header_contact",
						"type" => "text");

$of_options[] = array(  "name" =>  "Mobile Menu Background Color",
						"desc" => "",
						"id" => "mob_menu_bg",
						"std" => "#1F1F1F",
						"collapse_sec"	=> "mob_menu_settings",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Mobile Menu Link Color",
						"desc" => "",
						"id" => "mob_menu_link",
						"std" => "#fffeff",
						"collapse_sec"	=> "mob_menu_settings",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Mobile Menu Link Separator Color",
						"desc" => "",
						"id" => "mob_menu_sep_link",
						"std" => "#4b4b4b",
						"collapse_sec"	=> "mob_menu_settings",
						"type" => "color");		
						
$of_options[] = array(  "name" => "Mobile Menu Force Uppercase",
						"desc" => "Force uppercase letters on Mobile menu.",
						"id" => "mob_menu_up",
						"std" => 0,
						"folds" => 1,
						"collapse_sec"	=> "mob_menu_settings",
						"type" => "switch");	
						
$of_options[] = array(  "name" => "Mobile Menu Font Weight",
						"desc" => "",
						"id" => "mob_menu_font_weight",
						"std" => "normal",
						"type" => "select",
						"collapse_sec"	=> "mob_menu_settings",
						"options" => array('400', 'normal', '600', '700'));																						
	
//Menu Settings
$of_options[] = array( 	"name" 		=> "Page Title Breadcrumb",
						"type" 		=> "heading"
				);

$of_options[] = array( 	"name" 		=> "Page Title and Breadcrumb",
						"desc" 		=> "",
						"id" 		=> "title_breadcrumbs",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">Page Title and Breadcrumb</h3>",
						"icon" 		=> true,
						"type" 		=> "info"
				);
				
$of_options[] = array( 	"name" 		=> "Title and Breadcrumb",
						"desc" 		=> "Enable / Disable the Title and Breadcrumb section.",
						"id" 		=> "en_title_breadcrumb",
						"std" 		=> 1,
						"type" 		=> "switch",
						"folds"		=> 1
				);

$of_options[] = array( 	"name" 		=> "Disable Title and Breadcrumb for Posts",
						"desc" 		=> "Set this option to ON to Disable the Title and Breadcrumb area for Posts only",
						"id" 		=> "tb_posts_ds",
						"std" 		=> 0,
						"type" 		=> "switch",						
				);
$of_options[] = array( 	"name" 		=> "Disable Title and Breadcrumb for Portfolio",
						"desc" 		=> "Set this option to ON to Disable the Title and Breadcrumb area for Portfolio only",
						"id" 		=> "tb_port_ds",
						"std" 		=> 0,
						"type" 		=> "switch",						
				);

$of_options[] = array( 	"name" 		=> "Disable Title and Breadcrumb for Pages",
						"desc" 		=> "Set this option to ON to Disable the Title and Breadcrumb area for Pages only",
						"id" 		=> "tb_pages_ds",
						"std" 		=> 0,
						"type" 		=> "switch",						
				);
				
$of_options[] = array( "name" => "Title and Breadcrumb - Right Section display",
					"desc" => "Select what do you want to display on the right section of the Title and Sidebar?",
					"id" => "title_breadcrumb_right_side",
					"std" => "Search Box",
					"type" => "select",
					"fold" => "en_title_breadcrumb",
					"options" => array('search' => 'Search Box', 'contactinfo' => 'Contact Info', 'socialinks' => 'Social Links', 'empty' => 'Leave Empty' ));					
				
$of_options[] = array(  "name" =>  "Page Title Text Color",
						"desc" => "",
						"id" => "page_title_color",
						"std" => "#555555",
						"fold" => "en_title_breadcrumb",
						"type" => "color");
						
$of_options[] = array( 	"name" 		=> "Breadcrumb",
						"desc" 		=> "Enable / Disable the Breadcrumb.",
						"id" 		=> "en_breadcrumb",
						"std" 		=> 1,
						"type" 		=> "switch",
						"fold" => "en_title_breadcrumb",
				);						
					
$of_options[] = array(  "name" =>  "Breadcrumbs Text Color",
						"desc" => "",
						"id" => "breadcrumbs_text_color",
						"std" => "#888888",
						"fold" => "en_title_breadcrumb",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Breadcrumbs Link Color",
						"desc" => "",
						"id" => "breadcrumbs_link_color",
						"std" => "#888888",
						"fold" => "en_title_breadcrumb",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Title and Breadcrumbs Background Color Outside",
						"desc" => "",
						"id" => "title_bread_bg_color_out",
						"std" => "#f6f6f6",
						"fold" => "en_title_breadcrumb",
						"type" => "color");							
						
$of_options[] = array(  "name" =>  "Title and Breadcrumbs Background Color Inside",
						"desc" => "",
						"id" => "title_bread_bg_color_in",
						"std" => "#f9f9f9",
						"fold" => "en_title_breadcrumb",
						"type" => "color");
						
$of_options[] = array( 	"name" 		=> "Title and Breadcrumbs Background pattern",
						"desc" 		=> "Enable/Disable Title and Breadcrumbs Background Pattern.",
						"id" 		=> "title_bread_bg_pattern_en",
						"std" 		=> 0,
						"folds" 	=> 1,
						"fold" => "en_title_breadcrumb",
						"type" 		=> "switch"
				);												

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "Select a background pattern for the Title and Breadcrumbs Section.",
						"id" 		=> "title_bread_bg_pattern",
						"std" 		=> $bg_images_url."bg1.png",
						"type" 		=> "tiles",
						"fold"		=> "title_bread_bg_pattern_en",
						"options" 	=> $bg_images,
				);		
				
$of_options[] = array( 	"name" 		=> "Title and Breadcrumbs Custom Background Image Upload",
						"desc" 		=> "Upload or select an existing image to use for the title and breadcrumbs background.",
						"id" 		=> "title_bread_custom_bg_image",
						// Use the shortcodes [site_url] or [site_url_secure] for setting default URLs
						"std" 		=> "",
						"fold" => "en_title_breadcrumb",
						"type" 		=> "upload"
				);
				
$of_options[] = array(  "name" => "Title and Breadcrumbs Custom Background Image Repeat",
						"desc" => "",
						"id" => "title_bread_custom_bg_repeat",
						"std" => "2",
						"type" => "select",
						"fold" => "en_title_breadcrumb",
						"options" => array('no-repeat' => 'no-repeat', 'repeat' => 'repeat', 'repeat-x' => 'repeat-x', 'repeat-y' => 'repeat-y'));						
						
$of_options[] = array(  "name" =>  "Title and Breadcrumbs Padding Outside",
						"desc" => "",
						"id" => "title_bread_padding_out",
						"std" 		=> "5",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "20",
						"fold" => "en_title_breadcrumb",
						"type" 		=> "sliderui");	
						
$of_options[] = array(  "name" =>  "Title and Breadcrumbs Padding Inside",
						"desc" => "",
						"id" => "title_bread_padding_in",
						"std" 		=> "15",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "40",
						"fold" => "en_title_breadcrumb",
						"type" 		=> "sliderui");
						
$of_options[] = array(  "name" =>  "Title and Breadcrumbs Bottom Border Color",
						"desc" => "",
						"id" => "title_bread_border_color",
						"std" => "#f6f6f6",
						"fold" => "en_title_breadcrumb",
						"type" => "color");								
						
$of_options[] = array(  "name" =>  "Title and Breadcrumbs Bottom Border Width",
						"desc" => "",
						"id" => "title_bread_border_width",
						"std" 		=> "1",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "5",
						"fold" => "en_title_breadcrumb",
						"type" 		=> "sliderui");	
						
//Footer Settings
$of_options[] = array( 	"name" 		=> "Footer Settings",
						"type" 		=> "heading"
				);

$of_options[] = array( 	"name" 		=> "Footer Settings",
						"desc" 		=> "",
						"id" 		=> "footer_settings",
						"std" 		=> "<h3>Footer Settings</h3>",
						"icon" 		=> true,						
						"class" 	=>"hide_me admin_accord admin_expand",
						"collapse"	=> true,
						"type" 		=> "info"
				);	

$of_options[] = array(  "name" => "Footer Width",
						"desc" => "",
						"id" => "footer_width",
						"std" => "normal",
						"type" => "select",
						"collapse_sec"	=> "footer_settings",
						"options" => array(
							"default" => "Default",
							"expanded" => "Expanded"
						));

$of_options[] = array( 	"name" 		=> "Sticky Footer",
						"desc" 		=> "Enabling this option will force the footer section to become fixed on user scroll.",
						"id" 		=> "sticky_footer",
						"std" 		=> 0,
						"folds" 	=> 0,
						"collapse_sec"	=> "footer_settings",
						"type" 		=> "switch"
				);

$of_options[] = array(  "name" => "Footer Sidebar Columns",
						"desc" => "Select the number of columns to be used for displaying the Footer Sidebars",
						"id" => "footer_sidebar_cols",
						"std" => "4",
						"type" => "select",	
						"collapse_sec"	=> "footer_settings",
						"options" => array(4,3,2));													

$of_options[] = array(  "name" => "Footer Widgets",
						"desc" => "",
						"id" => "footer_widgets_settings",
						"std" => "<h3>Footer Widgets</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");

$of_options[] = array( 	"name" 		=> "Footer Widgets",
						"desc" 		=> "Enable/disable footer widgets.",
						"id" 		=> "footer_widgets",
						"std" 		=> 0,
						"folds" 	=> 1,
						"collapse_sec"	=> "footer_widgets_settings",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"name" => "Footer Headings Design",
						"desc" => "Select the design of the Footer Headings",
						"id" => "footer_heading_design",
						"std" 		=> "Style 1",
						"type" 		=> "select",
						"collapse_sec"	=> "footer_widgets_settings",
						"options" => array(						
							'style1' => 'Style 1',
							'style2' => 'Style 2'
						));	

$of_options[] = array(  "name" => "Footer Copyright",
						"desc" => "",
						"id" => "footer_copyright_opt",
						"std" => "<h3>Footer Copyright</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");
				
$of_options[] = array( 	"name" 		=> "Footer Copyright Alignment",
						"desc" 		=> "Center the footer copyright section.",
						"id" 		=> "footer_copyright_center",
						"std" 		=> 0,
						"folds" 	=> 1,
						"collapse_sec"	=> "footer_copyright_opt",
						"type" 		=> "switch"
				);				
				
$of_options[] = array( 	"name" 		=> "Copyright",
						"desc" 		=> "Enable/disable the copyrights.",
						"id" 		=> "copyrights_area",
						"std" 		=> 1,
						"folds" 	=> 1,
						"collapse_sec"	=> "footer_copyright_opt",
						"type" 		=> "switch"
				);				
				
$of_options[] = array(  "name" => "Copyright Text",
						"desc" => "",
						"id" => "copyrights_text",
						"fold" => "copyrights_area",
						"std" => 'Copyright 2022 Nimva | All Rights Reserved | <a href="https://rockythemes.com">RockyThemes</a>',
						"collapse_sec"	=> "footer_copyright_opt",
						"type" => "textarea");					

$of_options[] = array( 	"name" 		=> "Footer Menu",
						"desc" 		=> "Enable/disable footer menu.",
						"id" 		=> "footer_menu",
						"std" 		=> 1,
						"folds" 	=> 1,
						"collapse_sec"	=> "footer_copyright_opt",
						"type" 		=> "switch"
				);	
				
$of_options[] = array(  "name" => "Twitter Feed Bar",
						"desc" => "",
						"id" => "twitted_fd_br",
						"std" => "<h3>Twitter Feed Bar</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");				

$of_options[] = array( 	"name" 		=> "Enable/Disable Twitter Feed Bar",
						"desc" 		=> "Enable/Disable Twitter Feed bar just above the footer.",
						"id" 		=> "twitter_bar",
						"std" 		=> 0,
						"folds" 	=> 1,
						"collapse_sec"	=> "twitted_fd_br",
						"type" 		=> "switch"
				);	
				
$of_options[] = array(  "name" =>  "Twitter Feed Bar Text Color",
						"desc" => "",
						"id" => "twitter_bar_text",
						"std" => "#ffffff",
						"fold" => "twitter_bar",
						"collapse_sec"	=> "twitted_fd_br",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Twitter Feed Bar Background Color",
						"desc" => "",
						"id" => "twitter_bar_bg",
						"std" => "#f96e5b",
						"fold" => "twitter_bar",
						"collapse_sec"	=> "twitted_fd_br",
						"type" => "color");						

$of_options[] = array( 	"name" 		=> "Twitter Info",
						"desc" 		=> "",
						"id" 		=> "twitter_info",
						"std" 		=> "<h3 style=\"margin: 0;\">Twitter Api</h3><a href=\"http://dev.twitter.com/apps\" target=\"_blank\">Go here to Create or Find your Twitter App</a>",
						"icon" 		=> true,
						"fold" => "twitter_bar",
						"collapse_sec"	=> "twitted_fd_br",
						"type" 		=> "info"
				);	
				
$of_options[] = array(  "name" => "Twitter Profile",
						"desc" => "Enter your twitter profile id.",
						"id" => "twitter_profile",
						"std" => "rockythemes",
						"fold" => "twitter_bar",
						"collapse_sec"	=> "twitted_fd_br",
						"type" => "text");
							
$of_options[] = array(  "name" => "Consumer Key",
						"desc" => "Enter your consumer key.",
						"id" => "consumer_key",
						"std" => "",
						"fold" => "twitter_bar",
						"collapse_sec"	=> "twitted_fd_br",
						"type" => "text");		
						
$of_options[] = array(  "name" => "Consumer Secret",
						"desc" => "Enter your consumer secret.",
						"id" => "consumer_secret",
						"std" => "",
						"fold" => "twitter_bar",
						"collapse_sec"	=> "twitted_fd_br",
						"type" => "text");
						
$of_options[] = array(  "name" => "Action Token",
						"desc" => "Enter your action token.",
						"id" => "access_token",
						"std" => "",
						"fold" => "twitter_bar",
						"collapse_sec"	=> "twitted_fd_br",
						"type" => "text");

$of_options[] = array(  "name" => "Action Token Secret",
						"desc" => "Enter your action token secret.",
						"id" => "access_token_secret",
						"std" => "",
						"fold" => "twitter_bar",
						"collapse_sec"	=> "twitted_fd_br",
						"type" => "text");																												

$of_options[] = array(  "name" => "Call to Action Bar",
						"desc" => "",
						"id" => "cta_settings",
						"std" => "<h3>Call to Action Bar</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");
						

$of_options[] = array( 	"name" 		=> "Call to Action Bar",
						"desc" 		=> "Enable/Disable Call to Action Bar.",
						"id" 		=> "call_action",
						"std" 		=> 0,
						"folds" 	=> 1,
						"collapse_sec"	=> "cta_settings",
						"type" 		=> "switch"
				);
											

$of_options[] = array(  "name" => "Call to Action Text",
						"desc" => "Enter your Call to Action Text.",
						"id" => "call_action_text",
						"std" => "<span>Call to action</span> section for all pages with Admin Option. Enjoy <span><strong>Nimva?</strong></span>",
						"fold" => "call_action",
						"collapse_sec"	=> "cta_settings",
						"type" => "textarea");
						
$of_options[] = array(  "name" =>  "Call to Action Text Color",
						"desc" => "",
						"id" => "call_action_text_color",
						"std" => "#444444",
						"fold" => "call_action",
						"collapse_sec"	=> "cta_settings",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Call to Action Span Color",
						"desc" => "",
						"id" => "call_action_span_color",
						"std" => "#f96e5b",
						"fold" => "call_action",
						"collapse_sec"	=> "cta_settings",
						"type" => "color");															

$of_options[] = array(  "name" => "Call to Action Button Text",
						"desc" => "Edit Call to Action Button text.",
						"id" => "call_action_button_text",
						"std" => "Buy This Theme",
						"fold" => "call_action",
						"collapse_sec"	=> "cta_settings",
						"type" => "text");

$of_options[] = array(  "name" => "Call to Action Button Link",
						"desc" => "Edit Call to Action Button link.",
						"id" => "call_action_button_link",
						"std" => "#",
						"fold" => "call_action",
						"collapse_sec"	=> "cta_settings",
						"type" => "text");
						
$of_options[] = array(  "name" => "Call to Action Button Icon",
						"desc" => "Add a font awesome icon to the Call to Action Button.",
						"id" => "call_action_button_icon",
						"std" => "fa-star",
						"fold" => "call_action",
						"collapse_sec"	=> "cta_settings",
						"type" => "text");						
						
$of_options[] = array(  "name" => "Call to Action Button Style",
						"desc" => "",
						"id" => "call_action_button_style",
						"std" => "minimal",
						"fold" => "call_action",
						"collapse_sec"	=> "cta_settings",
						"type" => "select",
						"options" => array('minimal' => 'Minimal', '3d' => '3D'));							
						
$of_options[] = array(  "name" => "Call to Action Button Color",
						"desc" => "Select the color of the Call to Action button",
						"id" => "call_action_button_color",
						"fold" => "call_action",
						"std" => "lightred",
						"collapse_sec"	=> "cta_settings",
						"type" => "select",
						"options" => array( 'lightred' => 'Light Red',
											'darkred' => 'Dark Red',  
											'orange' => 'Orange',  
											'turquoise' => 'Turquoise',
											'emerald' => 'Emerald',
											'lightblue' => 'Light Blue',
											'amethyst' => 'Amethyst',
											'wetasphalt' => 'Wet Asphalt',
											'light' => 'Light',
											'dark' => 'Dark'
									 ));	
																								
$of_options[] = array(  "name" => "Call to Action Button Size",
						"desc" => "Select the size of the Call to Action button",
						"id" => "call_action_button_size",
						"std" => "small",
						"fold" => "call_action",
						"collapse_sec"	=> "cta_settings",
						"type" => "select",
						"options" => array('small' => 'Small', 'large' => 'Large'));						
						
$of_options[] = array(  "name" =>  "Call to Action Background Color",
						"desc" => "",
						"fold" => "call_action",
						"id" => "call_action_bg",
						"std" => "#f2f2f2",
						"collapse_sec"	=> "cta_settings",
						"type" => "color");	
						
$of_options[] = array( 	"name" 		=> "Call to Action Background Pattern",
						"desc" 		=> "Enable/Disable Call to Action Background Pattern.",
						"id" 		=> "call_action_bg_pattern_en",
						"std" 		=> 0,
						"fold" => "call_action",
						"folds" 	=> 1,
						"collapse_sec"	=> "cta_settings",
						"type" 		=> "switch"
				);												

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "Select a background pattern for the Call to Action.",
						"id" 		=> "call_action_bg_pattern",
						"std" 		=> $bg_images_url."bg1.png",
						"type" 		=> "tiles",
						"collapse_sec"	=> "cta_settings",
						"fold"		=> "call_action_bg_pattern_en",
						"options" 	=> $bg_images,
				);		
				
$of_options[] = array( 	"name" 		=> "Custom Background Image Upload",
						"desc" 		=> "Upload or select an existing image to use for the call to action background.",
						"id" 		=> "call_action_custom_bg_image",
						// Use the shortcodes [site_url] or [site_url_secure] for setting default URLs
						"std" 		=> "",
						"fold" => "call_action",
						"collapse_sec"	=> "cta_settings",
						"type" 		=> "upload"
				);
				
$of_options[] = array(  "name" => "Call to Action Custom Background Image Repeat",
						"desc" => "",
						"id" => "call_action_custom_bg_repeat",
						"std" => "2",
						"type" => "select",
						"fold" => "call_action",
						"collapse_sec"	=> "cta_settings",
						"options" => array('no-repeat' => 'no-repeat', 'repeat' => 'repeat', 'repeat-x' => 'repeat-x', 'repeat-y' => 'repeat-y'));						
//footer style		
$of_options[] = array( 	"name" 		=> "Footer Colors and Background",
						"desc" 		=> "",
						"id" 		=> "footer_color_bg",
						"std" 		=> "<h3>Footer Colors and Background</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);	

$of_options[] = array(  "name" =>  "Footer Headings Color",
						"desc" => "",
						"id" => "footer_headings_color",
						"std" => "#EEEEEE",
						"collapse_sec"	=> "footer_color_bg",
						"type" => "color");
						
$of_options[] = array(  "name" =>  "Footer Headings Small Border Color",
						"desc" => "",
						"id" => "footer_headings_border_color",
						"std" => "#676767",
						"collapse_sec"	=> "footer_color_bg",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Footer Headings Big Border Color",
						"desc" => "",
						"id" => "footer_headings_border_color_big",
						"std" => "#4b4b4b",
						"collapse_sec"	=> "footer_color_bg",
						"type" => "color");												

$of_options[] = array(  "name" =>  "Footer Text Color",
						"desc" => "",
						"id" => "footer_text_color",
						"std" => "#DDDDDD",
						"collapse_sec"	=> "footer_color_bg",
						"type" => "color");

$of_options[] = array(  "name" =>  "Footer Link Color",
						"desc" => "",
						"id" => "footer_link_color",
						"std" => "#BFBFBF",
						"collapse_sec"	=> "footer_color_bg",
						"type" => "color");	

$of_options[] = array(  "name" =>  "Footer Link Color Hover",
						"desc" => "",
						"id" => "footer_link_color_hover",
						"std" => "#fff",
						"collapse_sec"	=> "footer_color_bg",
						"type" => "color");						
				
$of_options[] = array(  "name" =>  "Footer Background Color ",
						"desc" => "",
						"id" => "footer_bg",
						"std" => "#363839",
						"collapse_sec"	=> "footer_color_bg",
						"type" => "color");
						
$of_options[] = array( 	"name" 		=> "Footer Background pattern",
						"desc" 		=> "Enable/Disable Footer Background Pattern.",
						"id" 		=> "footer_bg_pattern_en",
						"std" 		=> 0,
						"folds" 	=> 1,
						"collapse_sec"	=> "footer_color_bg",
						"type" 		=> "switch"
				);												

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "Select a background pattern for the footer.",
						"id" 		=> "footer_bg_pattern",
						"std" 		=> $bg_images_url."bg1.png",
						"type" 		=> "tiles",
						"collapse_sec"	=> "footer_color_bg",
						"fold"		=> "footer_bg_pattern_en",
						"options" 	=> $bg_images,
				);		
				
$of_options[] = array( 	"name" 		=> "Custom Background Image Upload",
						"desc" 		=> "Upload or select an existing image to use for the footer background.",
						"id" 		=> "footer_custom_bg_image",
						// Use the shortcodes [site_url] or [site_url_secure] for setting default URLs
						"std" 		=> "",
						"collapse_sec"	=> "footer_color_bg",
						"type" 		=> "upload"
				);
				
$of_options[] = array(  "name" => "Footer Custom Background Image Repeat",
						"desc" => "",
						"id" => "footer_custom_bg_repeat",
						"std" => "2",
						"type" => "select",
						"collapse_sec"	=> "footer_color_bg",
						"options" => array('no-repeat' => 'no-repeat', 'repeat' => 'repeat', 'repeat-x' => 'repeat-x', 'repeat-y' => 'repeat-y'));						

$of_options[] = array(  "name" =>  "Footer Border Color ",
						"desc" => "",
						"id" => "footer_border",
						"std" => "#3f3f3f",
						"collapse_sec"	=> "footer_color_bg",
						"type" => "color");								
						
$of_options[] = array(  "name" =>  "Copyright Background Color",
						"desc" => "",
						"collapse_sec"	=> "footer_color_bg",
						"id" => "copyright_bg",
						"std" => "#282A2B",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Copyright Text Color",
						"desc" => "",
						"collapse_sec"	=> "footer_color_bg",
						"id" => "copyright_text_color",
						"std" => "#DDDDDD",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Copyright Link Color",
						"desc" => "",
						"id" => "copyright_link_color",
						"std" => "#BFBFBF",
						"collapse_sec"	=> "footer_color_bg",
						"type" => "color");	

$of_options[] = array(  "name" =>  "Copyright Link Color Hover",
						"desc" => "",
						"id" => "copyright_link_color_hover",
						"std" => "#fff",
						"collapse_sec"	=> "footer_color_bg",
						"type" => "color");										
						
$of_options[] = array(  "name" =>  "Copyright Border Color ",
						"desc" => "",
						"id" => "copyright_border",
						"std" => "#282A2B",
						"collapse_sec"	=> "footer_color_bg",
						"type" => "color");							
				
//Footer Settings
$of_options[] = array( 	"name" 		=> "Background",
						"type" 		=> "heading"
				);

$of_options[] = array( 	"name" 		=> "Site Layout",
						"desc" 		=> "",
						"id" 		=> "site_layout_settings",
						"std" 		=> "<h3>Site Layout Settings.</h3>",
						"icon" 		=> true,						
						"class" 	=>"hide_me admin_accord admin_expand",
						"collapse"	=> true,
						"type" 		=> "info"
				);	

$of_options[] = array(  "name" => "Site Layout",
						"desc" => "Boxed or wide layout?",
						"id" => "site_layout",
						"std" => "wide",
						"type" => "select",
						"collapse_sec"	=> "site_layout_settings",
						"options" => array(						
							'wide' => 'Wide',
							'boxed' => 'Boxed',
				));
				
$of_options[] = array(  "name" => "Layout Width",
						"desc" => "Select the width of the Site Layout, in pixels.",
						"id" => "layout_width",
						"std" => "1160",
						"type" => "select",
						"collapse_sec"	=> "site_layout_settings",
						"options" => array(	
							"1160" => "1160px",					
							"960" => "960px",							
						)
					);

$of_options[] = array(  "name" => "Custom Width Layout",
						"desc" => "Specify a custom width for your site. Leave blank to inherit the setting selected under Layour Width. E.g: 1600px",
						"id" => "custom_width",
						"std" => "",
						"collapse_sec"	=> "site_layout_settings",
//						"fold" => "header_contact",
						"type" => "text");	

$of_options[] = array(  "name" =>  "Background Color - Wide/Boxed Layout",
						"desc" => "Select a background color for the wide/boxed layout.",
						"id" => "bg_color",
						"std" => "#ffffff",
						"collapse_sec"	=> "site_layout_settings",
						"type" => "color");
						
$of_options[] = array(  "name" =>  "Inner Background Color - Boxed Layout",
						"desc" => "Select a background color for the inner content of the boxed layout.",
						"id" => "content_bg",
						"std" => "#ffffff",
						"collapse_sec"	=> "site_layout_settings",
						"type" => "color");	
				
$of_options[] = array( 	"name" 		=> "Margins",
						"desc" 		=> "",
						"id" 		=> "site_margin",
						"std" 		=> "<h3>Site Margins for Boxed Layout!</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);				
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "Margin Top",
						"id" 		=> "margin_top",
						"std" 		=> "50",
						"min" 		=> "0",
						"step"		=> "5",
						"max" 		=> "80",
						"collapse_sec"	=> "site_margin",
						"type" 		=> "sliderui" 
				);	
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "Margin Bottom",
						"id" 		=> "margin_bottom",
						"std" 		=> "50",
						"min" 		=> "0",
						"step"		=> "5",
						"max" 		=> "80",
						"collapse_sec"	=> "site_margin",
						"type" 		=> "sliderui" 
				);							

$of_options[] = array( 	"name" 		=> "Background Info",
						"desc" 		=> "",
						"id" 		=> "background_img_setting",
						"std" 		=> "<h3>Image Background Options</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);

$of_options[] = array( 	"name" 		=> "Background Image",
						"desc" 		=> "Upload or select an existing image to use for background.",
						"id" 		=> "bg_image",
						// Use the shortcodes [site_url] or [site_url_secure] for setting default URLs
						"std" 		=> "",
						"collapse_sec"	=> "background_img_setting",
						"type" 		=> "upload"
				);
				
$of_options[] = array(  "name" => "Background Repeat",
						"desc" => "",
						"id" => "bg_repeat",
						"std" => "2",
						"type" => "select",
						"collapse_sec"	=> "background_img_setting",
						"options" => array('no-repeat' => 'no-repeat', 'repeat' => 'repeat', 'repeat-x' => 'repeat-x', 'repeat-y' => 'repeat-y'));
						
$of_options[] = array( 	"name" 		=> "Enable Parallax effect",
						"desc" 		=> "Add a very awesome parallax effect to your site background.",
						"id" 		=> "en_parallax",
						"std" 		=> 0,
						"collapse_sec"	=> "background_img_setting",
						"type" 		=> "switch"
				);						

$of_options[] = array( 	"name" 		=> "Fullscreen Background Image",
						"desc" 		=> "Have background image always at 100% in width and height and scale according to the browser size.",
						"id" 		=> "bg_full",
						"std" 		=> 0,
						"collapse_sec"	=> "background_img_setting",
						"type" 		=> "switch"
				);
												
						
$of_options[] = array( 	"name" 		=> "Background pattern",
						"desc" 		=> "Enable/Disable Background Pattern.",
						"id" 		=> "bg_pattern_en",
						"std" 		=> 0,
						"folds" 	=> 1,
						"collapse_sec"	=> "background_img_setting",
						"type" 		=> "switch"
				);												

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "Select a background pattern.",
						"id" 		=> "bg_pattern",
						"std" 		=> $bg_images_url."bg1.png",
						"type" 		=> "tiles",
						"fold"		=> "bg_pattern_en",
						"collapse_sec"	=> "background_img_setting",
						"options" 	=> $bg_images,
				);
				
$of_options[] = array( 	"name" 		=> "Video Background",
						"desc" 		=> "",
						"id" 		=> "video_bg_opt",
						"std" 		=> "<h3>Video Background Options</h3>Allows you add a video background from youtube.",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);				
				
$of_options[] = array( 	"name" 		=> "Video Background",
						"desc" 		=> "Enable/Disable Video Background.",
						"id" 		=> "video_bg_en",
						"std" 		=> 0,
						"folds" 	=> 1,
						"collapse_sec"	=> "video_bg_opt",
						"type" 		=> "switch"
				);	
				
$of_options[] = array(  "name" => "Youtube Video ID",
						"desc" => "Paste here the id of your Youtube video you want to use. <br> E.g: https://www.youtube.com/watch?v=PZizZxwrrbk - if this is your video link, the id would be:<strong>PZizZxwrrbk</strong>",
						"id" => "ytb_id",
						"std" => "",
						"fold" => "video_bg_en",
						"collapse_sec"	=> "video_bg_opt",
						"type" => "text");	
						
$of_options[] = array(  "name" => "Video Quality",
						"desc" => "Only works if the video supports this quality",
						"id" => "video_quality",
						"std" => "2",
						"fold" => "video_bg_en",
						"type" => "select",
						"collapse_sec"	=> "video_bg_opt",
						"options" => array( 'Default' => 'default', 'Small' => 'small', 'Medium' => 'medium', 'Large' => 'large', '720 HD' => 'hd720', '1080 HD' => 'hd1080', 'High Resolution' => 'highres' ));	
						
$of_options[] = array( 	"name" 		=> "Video Opacity",
						"desc" 		=> "Select the opacity for the video background",
						"id" 		=> "video_opacity",
						"std" 		=> "100",
						"min" 		=> "0",
						"step"		=> "5",
						"max" 		=> "100",
						"fold" => "video_bg_en",
						"collapse_sec"	=> "video_bg_opt",
						"type" 		=> "sliderui" 
				);																	

$of_options[] = array(  "name" =>  "Video Overlay Color",
						"desc" => "Add a colored background over the Video Background. Leave blank if you don't want to use this feature.",
						"id" => "video_overlay",
						"std" => "",
						"fold" => "video_bg_en",
						"collapse_sec"	=> "video_bg_opt",
						"type" => "color");
						
$of_options[] = array( 	"name" 		=> "Video Overlay Opacity",
						"desc" 		=> "Select the opacity of the colored background, in percents.",
						"id" 		=> "video_overlay_opacity",
						"std" 		=> "50",
						"min" 		=> "0",
						"step"		=> "5",
						"max" 		=> "100",
						"fold" => "video_bg_en",
						"collapse_sec"	=> "video_bg_opt",
						"type" 		=> "sliderui" 
				);			
				
$of_options[] = array( 	"name" 		=> "Background Video Overlay Pattern",
						"desc" 		=> "You can optionally select an overlay pattern for your video background.",
						"id" 		=> "video_overlay_bg",
						"std" 		=> $bg_overlay_url."none.png",
						"type" 		=> "tiles",
						"fold"		=> "video_bg_en",
						"options" 	=> $bg_overlay,
						"collapse_sec"	=> "video_bg_opt",
						"fold" => "video_bg_en"
				);											

//Footer Settings
$of_options[] = array( 	"name" 		=> "Typography",
						"type" 		=> "heading"
				);

$of_options[] = array( 	"name" 		=> "Google Fonts Options",
						"desc" 		=> "",
						"id" 		=> "g_fonts_options",
						"std" 		=> "<h3>Google Fonts Options</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord admin_expand",
						"collapse"	=> true,
						"type" 		=> "info"
				);
				
$of_options[] = array(  "name" => "Select Body Font Family",
						"desc" => "Select a font family for body text",
						"id" => "google_body",
						"std" => "Open Sans",
						"type" => "select_google_font",
						"preview" => array(
									"text" => "Donec sed odio dui. Nulla vitae elit libero, a pharetra augue. Nullam id dolor id nibh ultricies vehicula ut id elit.", 
									"size" => "12px"
						),
						"collapse_sec"	=> "g_fonts_options",
						"options" => $google_fonts);
						
						

$of_options[] = array(  "name" => "Select Header Menu Font Family",
						"desc" => "Select a font family for navigation",
						"id" => "google_nav",
						"std" => "Open Sans",
						"type" => "select_google_font",
						"preview" => array(
									"text" => "HOME&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; PAGES&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; SHORTCODES&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; CONTACT", 
									"size" => "13px"
						),
						"collapse_sec"	=> "g_fonts_options",
						"options" => $google_fonts);

$of_options[] = array(  "name" => "Select Headings Font Family",
						"desc" => "Select a font family for headings",
						"id" => "google_headings",
						"std" => "Open Sans",
						"type" => "select_google_font",
						"preview" => array(
									"text" => "Headings are used everywhere!", 
									"size" => "18px"
						),
						"collapse_sec"	=> "g_fonts_options",
						"options" => $google_fonts);

$of_options[] = array(  "name" => "Select Sidebar Headings Font Family",
						"desc" => "Select a font family for sidebar headings",
						"id" => "google_sidebar_headings",
						"std" => "Open Sans",
						"type" => "select_google_font",
						"preview" => array(
									"text" => "Sidebar Headings are great", 
									"size" => "16px"
						),
						"collapse_sec"	=> "g_fonts_options",
						"options" => $google_fonts);

$of_options[] = array(  "name" => "Select Footer Headings Font Family",
						"desc" => "Select a font family for footer headings",
						"id" => "google_footer_headings",
						"std" => "Open Sans",
						"type" => "select_google_font",
						"preview" => array(
									"text" => "Footer Headings are also important", 
									"size" => "16px"
						),
						"collapse_sec"	=> "g_fonts_options",
						"options" => $google_fonts);
						
$of_options[] = array(  "name" => "Standard Fonts",
						"desc" => "",
						"id" => "standard_fonts_option",
						"std" => "<h3>Standard Fonts Sizes</h3>If you have a Google Font selected above, the standard font will be overridden.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");		
						
$standard_fonts = array(
						'0' => 'Select Font',
						'Arial, Helvetica, sans-serif' => 'Arial, Helvetica, sans-serif',
						"'Arial Black', Gadget, sans-serif" => "'Arial Black', Gadget, sans-serif",
						"'Bookman Old Style', serif" => "'Bookman Old Style', serif",
						"'Comic Sans MS', cursive" => "'Comic Sans MS', cursive",
						"Courier, monospace" => "Courier, monospace",
						"Garamond, serif" => "Garamond, serif",
						"Georgia, serif" => "Georgia, serif",
						"Impact, Charcoal, sans-serif" => "Impact, Charcoal, sans-serif",
						"'Lucida Console', Monaco, monospace" => "'Lucida Console', Monaco, monospace",
						"'Lucida Sans Unicode', 'Lucida Grande', sans-serif" => "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
						"'MS Sans Serif', Geneva, sans-serif" => "'MS Sans Serif', Geneva, sans-serif",
						"'MS Serif', 'New York', sans-serif" => "'MS Serif', 'New York', sans-serif",
						"'Palatino Linotype', 'Book Antiqua', Palatino, serif" => "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
						"Tahoma, Geneva, sans-serif" => "Tahoma, Geneva, sans-serif",
						"'Times New Roman', Times, serif" => "'Times New Roman', Times, serif",
						"'Trebuchet MS', Helvetica, sans-serif" => "'Trebuchet MS', Helvetica, sans-serif",
						"Verdana, Geneva, sans-serif" => "Verdana, Geneva, sans-serif"
					);

$of_options[] = array(  "name" => "Select Body Font Family",
						"desc" => "Select a font family for body text",
						"id" => "standard_body",
						"std" => "",
						"type" => "select",
						"collapse_sec"	=> "standard_fonts_option",
						"options" => $standard_fonts);

$of_options[] = array(  "name" => "Select Menu Font Family",
						"desc" => "Select a font family for menu / navigation",
						"id" => "standard_nav",
						"std" => "",
						"type" => "select",
						"collapse_sec"	=> "standard_fonts_option",
						"options" => $standard_fonts);

$of_options[] = array(  "name" => "Select Headings Font Family",
						"desc" => "Select a font family for headings",
						"id" => "standard_headings",
						"std" => "",
						"type" => "select",
						"collapse_sec"	=> "standard_fonts_option",
						"options" => $standard_fonts);

$of_options[] = array(  "name" => "Select Sidebar Headings Font Family",
						"desc" => "Select a font family for sidebar headings",
						"id" => "standard_sidebar_headings",
						"std" => "",
						"type" => "select",
						"collapse_sec"	=> "standard_fonts_option",
						"options" => $standard_fonts);	

$of_options[] = array(  "name" => "Select Footer Headings Font Family",
						"desc" => "Select a font family for footer headings",
						"id" => "standard_footer_headings",
						"std" => "",
						"type" => "select",
						"collapse_sec"	=> "standard_fonts_option",
						"options" => $standard_fonts);	
				
$of_options[] = array( 	"name" 		=> "Custom Font",
						"desc" 		=> "",
						"id" 		=> "c_fonts",
						"std" 		=> "<h3>Custom Font</h3>This will overide the google/standard fonts.",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);				

$of_options[] = array(  "name" => "Custom Font .woff",
						"desc" => "Upload here the .woff font file.",
						"id" => "custom_woff",
						"std" => "",
						"mod" => "yes",
						"collapse_sec"	=> "c_fonts",
						"type" => "upload");	
						
$of_options[] = array(  "name" => "Custom Font .ttf",
						"desc" => "Upload here the .ttf font file.",
						"id" => "custom_ttf",
						"std" => "",
						"mod" => "yes",
						"collapse_sec"	=> "c_fonts",
						"type" => "media");	
						
$of_options[] = array(  "name" => "Custom Font .svg",
						"desc" => "Upload here the .svg font file.",
						"id" => "custom_svg",
						"std" => "",
						"mod" => "yes",
						"collapse_sec"	=> "c_fonts",
						"type" => "media");	
						
$of_options[] = array(  "name" => "Custom Font .eot",
						"desc" => "Upload here the .eot font file.",
						"id" => "custom_eot",
						"std" => "",
						"mod" => "yes",
						"collapse_sec"	=> "c_fonts",
						"type" => "media");	
							
						
$of_options[] = array( 	"name" 		=> "Choose where to use your Custom Font",
						"desc" 		=> "Use as Body Font",
						"id" 		=> "custom_body",
						"std" 		=> 0,
						"collapse_sec"	=> "c_fonts",
						"type" 		=> "switch"
				);
$of_options[] = array( 	"desc" 		=> "Use on Header Menu",
						"id" 		=> "custom_menu",
						"std" 		=> 0,
						"collapse_sec"	=> "c_fonts",
						"type" 		=> "switch"
				);

$of_options[] = array( 	"desc" 		=> "Use on Sidebar Headings",
						"id" 		=> "custom_sidebar_font",
						"std" 		=> 0,
						"collapse_sec"	=> "c_fonts",
						"type" 		=> "switch"
				);	
				
$of_options[] = array( 	"desc" 		=> "Use on Headings",
						"id" 		=> "custom_heading",
						"std" 		=> 0,
						"collapse_sec"	=> "c_fonts",
						"type" 		=> "switch"
				);	
				
$of_options[] = array( 	"desc" 		=> "Use on Text Logo",
						"id" 		=> "custom_logo",
						"std" 		=> 0,
						"collapse_sec"	=> "c_fonts",
						"type" 		=> "switch"
				);	

$of_options[] = array( 	"desc" 		=> "Use on Tagline",
						"id" 		=> "custom_tagline",
						"std" 		=> 0,
						"collapse_sec"	=> "c_fonts",
						"type" 		=> "switch"
				);								

$of_options[] = array( 	"desc" 		=> "Use on Footer Headings",
						"id" 		=> "custom_footer",
						"std" 		=> 0,
						"collapse_sec"	=> "c_fonts",
						"type" 		=> "switch"
				);																																				

$of_options[] = array(  "name" => "Font Sizes",
						"desc" => "",
						"id" => "font_sizes_settings",
						"std" => "<h3 >Font Sizes</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");

$of_options[] = array(  "name" => "Body Font Size (px)",
						"desc" => "Default is 12",
						"id" => "body_font_size",
						"std" => "12",
						"type" => "select",
						"collapse_sec"	=> "font_sizes_settings",
						"options" => $font_sizes);

$of_options[] = array(  "name" => "Body Line Height",
						"desc" => "Default is 1.3",
						"id" => "body_line_height",
						"std" => "1.3",
						"collapse_sec"	=> "font_sizes_settings",
//						"fold" => "header_contact",
						"type" => "text");	

$of_options[] = array(  "name" => "Header Menu Font Size (px)",
						"desc" => "Default is 13",
						"id" => "nav_font_size",
						"std" => "13",
						"type" => "select",
						"collapse_sec"	=> "font_sizes_settings",
						"options" => $font_sizes);

$of_options[] = array(  "name" => "Header Contact Info Font Size (px)",
						"desc" => "Default is 12",
						"id" => "snav_font_size",
						"std" => "12",
						"type" => "select",
						"collapse_sec"	=> "font_sizes_settings",
						"options" => $font_sizes);
						
$of_options[] = array(  "name" =>  "Page Title Font Size",
						"desc" => "Default is 24",
						"id" => "page_title_font_size",
						"std" => "24",
						"type" => "select",
						"collapse_sec"	=> "font_sizes_settings",
						"options" => $font_sizes);						

$of_options[] = array(  "name" => "Breadcrumbs Font Size (px)",
						"desc" => "Default is 12",
						"id" => "breadcrumbs_font_size",
						"std" => "12",
						"type" => "select",
						"collapse_sec"	=> "font_sizes_settings",
						"options" => $font_sizes);

$of_options[] = array(  "name" => "Sidebar Widget Title Font Size (px)",
						"desc" => "Default is 11",
						"id" => "sidew_font_size",
						"std" => "11",
						"type" => "select",
						"collapse_sec"	=> "font_sizes_settings",
						"options" => $font_sizes);

$of_options[] = array(  "name" => "Footer Widget Title Font Size (px)",
						"desc" => "Default is 11",
						"id" => "footw_font_size",
						"std" => "11",
						"type" => "select",
						"collapse_sec"	=> "font_sizes_settings",
						"options" => $font_sizes);

$of_options[] = array(  "name" => "Copyright Font Size (px)",
						"desc" => "Default is 12",
						"id" => "copyright_font_size",
						"std" => "12",
						"type" => "select",
						"collapse_sec"	=> "font_sizes_settings",
						"options" => $font_sizes);

$of_options[] = array(  "name" => "Heading Font Size H1 (px)",
						"desc" => "Default is 28",
						"id" => "h1_font_size",
						"std" => "28",
						"type" => "select",
						"collapse_sec"	=> "font_sizes_settings",
						"options" => $font_sizes);

$of_options[] = array(  "name" => "Heading Font Size H2 (px)",
						"desc" => "Default is 22",
						"id" => "h2_font_size",
						"std" => "22",
						"type" => "select",
						"collapse_sec"	=> "font_sizes_settings",
						"options" => $font_sizes);

$of_options[] = array(  "name" => "Heading Font Size H3 (px)",
						"desc" => "Default is 18",
						"id" => "h3_font_size",
						"std" => "18",
						"type" => "select",
						"collapse_sec"	=> "font_sizes_settings",
						"options" => $font_sizes);

$of_options[] = array(  "name" => "Heading Font Size H4 (px)",
						"desc" => "Default is 16",
						"id" => "h4_font_size",
						"std" => "16",
						"type" => "select",
						"collapse_sec"	=> "font_sizes_settings",
						"options" => $font_sizes);

$of_options[] = array(  "name" => "Heading Font Size H5 (px)",
						"desc" => "Default is 14",
						"id" => "h5_font_size",
						"std" => "14",
						"type" => "select",
						"collapse_sec"	=> "font_sizes_settings",
						"options" => $font_sizes);

$of_options[] = array(  "name" => "Heading Font Size H6 (px)",
						"desc" => "Default is 12",
						"id" => "h6_font_size",
						"std" => "12",
						"type" => "select",
						"collapse_sec"	=> "font_sizes_settings",
						"options" => $font_sizes);	

$of_options[] = array( "name" => "Headings H1, H2, H3, H4, H5, H6",
						"desc" => "Choose the font weight of the H1, H2, H3, H4, H5, H6 headings",
						"id" => "headings_font_size",
						"std" => "400",
						"type" => "select",
						"collapse_sec"	=> "font_sizes_settings",
						"options" => array('300', '400', '500', '600', '700')
				);			
								
$of_options[] = array( 	"name" 		=> "Color Scheme",
						"type" 		=> "heading"
				);
$of_options[] = array( 	"name" 		=> "Colors",
						"desc" 		=> "",
						"id" 		=> "color_scheme_setting",
						"std" 		=> "<h3>Colorschemes</h3>",
						"icon" 		=> true,						
						"class" 	=>"hide_me admin_accord admin_expand",
						"collapse"	=> true,
						"type" 		=> "info"
				);					
$of_options[] = array(  "name" => "Predefined Color Scheme",
						"desc" => "",
						"id" => "color_scheme",
						"std" => "Light Red",
						"type" => "select",
						"collapse_sec"	=> "color_scheme_setting",
						"options" => array( 'lightred' => 'Light Red',
											'darkred' => 'Dark Red',  
											'orange' => 'Orange',  
											'turquoise' => 'Turquoise',
											'emerald' => 'Emerald',
											'lightblue' => 'Light Blue',
											'amethyst' => 'Amethyst',
											'wetasphalt' => 'Wet Asphalt',
									 ));
/*
$of_options[] = array(  "name" =>  "Primary Color",
						"desc" => "",
						"id" => "primary_color",
						"std" => "#f96e5b",
						"type" => "color");	
						
$of_options[] = array( 	"name" 		=> "Primary Color Overwrite",
						"desc" 		=> "Use Primary Color for all styles (links, shortcodes, etc). Checking this box will overwrite some of the colors you manually set.",
						"id" 		=> "primary_color_overwrite",
						"std" 		=> 0,
						"type" 		=> "switch"
				);						
*/
$of_options[] = array(  "name" => "Text Color",
						"desc" => "",
						"id" => "text_color_setting",
						"std" => "<h3>Text Colors</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	

$of_options[] = array(  "name" =>  "Body Text Color",
						"desc" => "",
						"id" => "body_text_color",
						"std" => "#777777",
						"collapse_sec"	=> "text_color_setting",
						"type" => "color");
						
$of_options[] = array(  "name" =>  "Span Text Color",
						"desc" => "",
						"id" => "span_text_color",
						"std" => "#f96e5b",
						"collapse_sec"	=> "text_color_setting",
						"type" => "color");						

$of_options[] = array(  "name" =>  "Link Color",
						"desc" => "",
						"id" => "link_color",
						"std" => "#555555",
						"collapse_sec"	=> "text_color_setting",
						"type" => "color");															

$of_options[] = array(  "name" =>  "Link Color on Hover",
						"desc" => "",
						"id" => "link_color_hover",
						"std" => "#f96e5b",
						"collapse_sec"	=> "text_color_setting",
						"type" => "color");						
						

$of_options[] = array(  "name" =>  "Heading 1 (H1) Text Color",
						"desc" => "",
						"id" => "h1_color",
						"std" => "#444444",
						"collapse_sec"	=> "text_color_setting",
						"type" => "color");

$of_options[] = array(  "name" =>  "Heading 2 (H2) Text Color",
						"desc" => "",
						"id" => "h2_color",
						"std" => "#444444",
						"collapse_sec"	=> "text_color_setting",
						"type" => "color");

$of_options[] = array(  "name" =>  "Heading 3 (H3) Text Color",
						"desc" => "",
						"id" => "h3_color",
						"std" => "#444444",
						"collapse_sec"	=> "text_color_setting",
						"type" => "color");

$of_options[] = array(  "name" =>  "Heading 4 (H4) Text Color",
						"desc" => "",
						"id" => "h4_color",
						"std" => "#444444",
						"collapse_sec"	=> "text_color_setting",
						"type" => "color");

$of_options[] = array(  "name" =>  "Heading 5 (H5) Text Color",
						"desc" => "",
						"id" => "h5_color",
						"std" => "#444444",
						"collapse_sec"	=> "text_color_setting",
						"type" => "color");

$of_options[] = array(  "name" =>  "Heading 6 (H6) Text Color",
						"desc" => "",
						"id" => "h6_color",
						"std" => "#444444",
						"collapse_sec"	=> "text_color_setting",
						"type" => "color");
							
$of_options[] = array( 	"name" 		=> "PageNavigation and Flexslider Arrow Color",
						"desc" 		=> "",
						"id" 		=> "page_navigation_setting",
						"std" 		=> "<h3>PageNavigation and Flexslider Arrow Colorn</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);
				
$of_options[] = array(  "name" =>  "Page Navigation Color",
						"desc" => "",
						"id" => "page_navi_color",
						"std" => "#f96e5b",
						"collapse_sec"	=> "page_navigation_setting",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Slideshow Arrows Color",
						"desc" => "",
						"id" => "slide_arrow_color",
						"std" => "#f96e5b",
						"collapse_sec"	=> "page_navigation_setting",
						"type" => "color");									
						
$of_options[] = array( 	"name" 		=> "Header Post Nagivation",
						"desc" 		=> "",
						"id" 		=> "post_navi_header",
						"std" 		=> "<h3>Header Post Nagivation</h3>",
						"icon" 		=> true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" 		=> "info"
				);							
						
$of_options[] = array(  "name" =>  "Post Navigation Icon Color",
						"desc" => "",
						"id" => "post_navigation_color",
						"std" => "#777",
						"collapse_sec"	=> "post_navi_header",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Post Navigation Icon Color on Hover",
						"desc" => "",
						"id" => "post_navigation_color_hover",
						"std" => "#f96e5b",
						"collapse_sec"	=> "post_navi_header",
						"type" => "color");																																			
/*
$of_options[] = array( 	"name" 		=> "Background Color!",
						"desc" 		=> "",
						"id" 		=> "background_color",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">Footer Twitter Bar </h3>",
						"icon" 		=> true,
						"type" 		=> "info"
				);																	

						
$of_options[] = array(  "name" =>  "Twitter Bar Background Color",
						"desc" => "",
						"id" => "twitter_bar_bg",
						"std" => "#f96e5b",
						"type" => "color");													
	*/																									

$of_options[] = array(  "name" => "Image Overlay",
						"desc" => "",
						"id" => "image_overlay_setting",
						"std" => "<h3>Image Overlay</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");
						
$of_options[] = array(  "name" =>  "Image Hover Background Color",
						"desc" => "",
						"id" => "image_hover_bg_color",
						"std" => "#000000",
						"collapse_sec"	=> "image_overlay_setting",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Image Hover Background Opacity %",
						"desc" => "Lower values will make the background transparent.<br />Higher values will make the background opaque.",
						"id" => "image_hover_bg_opacity",
						"std" 		=> "60",
						"min" 		=> "0",
						"step"		=> "10",
						"max" 		=> "100",
						"collapse_sec"	=> "image_overlay_setting",
						"type" 		=> "sliderui");	
						
$of_options[] = array(  "name" =>  "Image Hover - Icon Color",
						"desc" => "",
						"id" => "image_hover_icon_color",
						"std" => "#fff",
						"collapse_sec"	=> "image_overlay_setting",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Image Hover - Icon Background",
						"desc" => "",
						"id" => "image_hover_icon_bg",
						"std" => "#f96e5b",
						"collapse_sec"	=> "image_overlay_setting",
						"type" => "color");	
						
$of_options[] = array(  "name" => "Search Button Colors",
						"desc" => "",
						"id" => "search_btt",
						"std" => "<h3>Search Button Colors</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");																																				
						
$of_options[] = array(  "name" =>  "Search Button Background Color",
						"desc" => "",
						"id" => "search_button_bg_color",
						"std" => "#444444",
						"collapse_sec"	=> "search_btt",
						"type" => "color");																											
											
$of_options[] = array(  "name" =>  "Search Button Background Color Hover",
						"desc" => "",
						"id" => "search_button_bg_color_hover",
						"std" => "#f96e5b",
						"collapse_sec"	=> "search_btt",
						"type" => "color");
						
$of_options[] = array(  "name" => "Back to Top Button",
						"desc" => "",
						"id" => "back_top_settings",
						"std" => "<h3>Back to Top Button</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");		
						
$of_options[] = array(  "name" => "Enable Back to Top Button",
						"id" => "en_back_top",
						"std" => 1,
						"folds" => 1,
						"collapse_sec"	=> "back_top_settings",
						"type" => "switch");
						
$of_options[] = array(  "name" =>  "Back to Top Icon Color",
						"desc" => "",
						"id" => "back_top_icon",
						"std" => "#fff",
						"fold" => "en_back_top",
						"collapse_sec"	=> "back_top_settings",
						"type" => "color");							
						
$of_options[] = array(  "name" =>  "Back to Top Background Color",
						"desc" => "",
						"id" => "back_top_bg",
						"std" => "#444",
						"fold" => "en_back_top",
						"collapse_sec"	=> "back_top_settings",
						"type" => "color");
						
$of_options[] = array(  "name" =>  "Back to Top Background Color on Hover",
						"desc" => "",
						"id" => "back_top_bg_hover",
						"std" => "#f96e5b",
						"fold" => "en_back_top",
						"collapse_sec"	=> "back_top_settings",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Back to Top Border Width",
						"desc" => "",
						"id" => "back_top_border",
						"std" 		=> "0",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "5",
						"fold" => "en_back_top",
						"collapse_sec"	=> "back_top_settings",
						"type" 		=> "sliderui");	
						
$of_options[] = array(  "name" =>  "Back to Top Border Color",
						"desc" => "",
						"id" => "back_top_border_color",
						"std" => "#fff",
						"fold" => "en_back_top",
						"collapse_sec"	=> "back_top_settings",
						"type" => "color");	
																																																			
$of_options[] = array( 	"name" 		=> "Buttons",
						"type" 		=> "heading"
				);																																																																																										

$of_options[] = array(  "name" => "WooCommerce Default Button",
						"desc" => "",
						"id" => "wc_but_sett",
						"std" => "<h3>WooCommerce Button</h3>",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");
						
$of_options[] = array(  "name" =>  "WooCommerce Button Text Color",
						"desc" => "",
						"id" => "wc_button_text",
						"std" => "#ffffff",
						"collapse_sec"	=> "wc_but_sett",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "WooCommerce Button Background Color",
						"desc" => "",
						"id" => "wc_button_bg",
						"std" => "#333333",
						"collapse_sec"	=> "wc_but_sett",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "WooCommerce Button Text Color on Hover",
						"desc" => "",
						"id" => "wc_button_text_hover",
						"std" => "#ffffff",
						"collapse_sec"	=> "wc_but_sett",
						"type" => "color");												
						
$of_options[] = array(  "name" =>  "WooCommerce Button Background Color on Hover",
						"desc" => "",
						"id" => "wc_button_bg_hover",
						"std" => "#f96e5b",
						"collapse_sec"	=> "wc_but_sett",
						"type" => "color");	

$of_options[] = array(  "name" => "Contact Form Submit Button",
						"desc" => "",
						"id" => "cf_sett",
						"std" => "<h3>Contact Form Button</h3>Use the settings bellow to customize the look of the Contact Form submit button.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");

					
$of_options[] = array(  "name" =>  "Contact Form Button Background Color",
						"desc" => "",
						"id" => "cf_bg",
						"std" => "#34495e",
						"collapse_sec"	=> "cf_sett",
						"type" => "color");
						
$of_options[] = array(  "name" =>  "Contact Form Button Text Color",
						"desc" => "",
						"id" => "cf_text",
						"std" => "#ffffff",
						"collapse_sec"	=> "cf_sett",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Contact Form Button Background Color on Hover",
						"desc" => "",
						"id" => "cf_bg_hover",
						"std" => "#e5e5e5",
						"collapse_sec"	=> "cf_sett",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Contact Form Button Text Color on Hover",
						"desc" => "",
						"id" => "cf_text_hover",
						"std" => "#34495e",
						"collapse_sec"	=> "cf_sett",
						"type" => "color");	



$of_options[] = array(  "name" => "Load More Posts Button",
						"desc" => "",
						"id" => "load_more_sett",
						"std" => "<h3>Load More Posts Button</h3>Use the settings bellow to customize the look of the Load More Posts button.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");

$of_options[] = array(  "name" => "Load More Posts Button Text",
						"desc" => "",
						"id" => "load_more_posts_text",
						"std" => "Load more posts",
//						"fold" => "header_contact",
						"collapse_sec"	=> "load_more_sett",
						"type" => "text");
						
$of_options[] = array(  "name" =>  "Load More Posts Button Background Color",
						"desc" => "",
						"id" => "lmp_bg",
						"std" => "#444444",
						"collapse_sec"	=> "load_more_sett",
						"type" => "color");
						
$of_options[] = array(  "name" =>  "Load More Posts Button Text Color",
						"desc" => "",
						"id" => "lmp_text",
						"std" => "#ffffff",
						"collapse_sec"	=> "load_more_sett",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Load More Posts Button Background Color on Hover",
						"desc" => "",
						"id" => "lmp_bg_hover",
						"std" => "#000000",
						"collapse_sec"	=> "load_more_sett",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Load More Posts Button Text Color on Hover",
						"desc" => "",
						"id" => "lmp_text_hover",
						"std" => "#ffffff",
						"collapse_sec"	=> "load_more_sett",
						"type" => "color");	



$of_options[] = array(  "name" => "Red Button",
						"desc" => "",
						"id" => "red_btn_sett",
						"std" => "<h3>Red Button</h3>Use the settings bellow to customize the look of the red button.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");
						
$of_options[] = array(  "name" =>  "Red Button Background Color",
						"desc" => "",
						"id" => "colored_bg_red",
						"std" => "#f96e5b",
						"collapse_sec"	=> "red_btn_sett",
						"type" => "color");
						
$of_options[] = array(  "name" =>  "Red Button Text Color",
						"desc" => "",
						"id" => "colored_text_red",
						"std" => "#fff",
						"collapse_sec"	=> "red_btn_sett",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Red Button Background Color on Hover",
						"desc" => "",
						"id" => "colored_bg_red_hover",
						"std" => "#333",
						"collapse_sec"	=> "red_btn_sett",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Red Button Text Color on Hover",
						"desc" => "",
						"id" => "colored_text_red_hover",
						"std" => "#fff",
						"collapse_sec"	=> "red_btn_sett",
						"type" => "color");	
						
$of_options[] = array(  "name" => "Dark Red Button",
						"desc" => "",
						"id" => "dark_red_sett",
						"std" => "<h3>Dark Red Button</h3>Use the settings bellow to customize the look of the dark red button.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");						
						
$of_options[] = array(  "name" =>  "Dark Red Button Background Color",
						"desc" => "",
						"id" => "colored_bg_dark_red",
						"std" => "#961a34",
						"collapse_sec"	=> "dark_red_sett",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Dark Red Button Text Color",
						"desc" => "",
						"id" => "colored_text_dark_red",
						"std" => "#fff",
						"collapse_sec"	=> "dark_red_sett",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Dark Red Button Background Color on Hover",
						"desc" => "",
						"id" => "colored_bg_dark_red_hover",
						"std" => "#333",
						"collapse_sec"	=> "dark_red_sett",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Dark Red Button Text Color on Hover",
						"desc" => "",
						"id" => "colored_text_dark_red_hover",
						"std" => "#fff",
						"collapse_sec"	=> "dark_red_sett",
						"type" => "color");							
						
$of_options[] = array(  "name" => "Blue Button",
						"desc" => "",
						"id" => "blue_btn_sett",
						"std" => "<h3>Blue Button</h3>Use the settings bellow to customize the look of the blue button.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");																	
						
$of_options[] = array(  "name" =>  "Blue Button Background Color",
						"desc" => "",
						"id" => "colored_bg_blue",
						"std" => "#3498db",
						"collapse_sec"	=> "blue_btn_sett",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Blue Button Text Color",
						"desc" => "",
						"id" => "colored_text_blue",
						"std" => "#fff",
						"collapse_sec"	=> "blue_btn_sett",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Blue Button Background Color on Hover",
						"desc" => "",
						"id" => "colored_bg_blue_hover",
						"std" => "#333",
						"collapse_sec"	=> "blue_btn_sett",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Blue Button Text Color on Hover",
						"desc" => "",
						"id" => "colored_text_blue_hover",
						"std" => "#fff",
						"collapse_sec"	=> "blue_btn_sett",
						"type" => "color");							
						
$of_options[] = array(  "name" => "Orange Button",
						"desc" => "",
						"id" => "orng_butt",
						"std" => "<h3>Orange Button</h3>Use the settings bellow to customize the look of the orange button.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");						
						
$of_options[] = array(  "name" =>  "Orange Button Background Color",
						"desc" => "",
						"id" => "colored_bg_orange",
						"std" => "#ff7534",
						"collapse_sec"	=> "orng_butt",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Orange Button Text Color",
						"desc" => "",
						"id" => "colored_text_orange",
						"std" => "#fff",
						"collapse_sec"	=> "orng_butt",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Orange Button Background Color on Hover",
						"desc" => "",
						"id" => "colored_bg_orange_hover",
						"std" => "#333",
						"collapse_sec"	=> "orng_butt",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Orange Button Text Color on Hover",
						"desc" => "",
						"id" => "colored_text_orange_hover",
						"std" => "#fff",
						"collapse_sec"	=> "orng_butt",
						"type" => "color");	
						
$of_options[] = array(  "name" => "Turquoise Button",
						"desc" => "",
						"id" => "turq_bttn",
						"std" => "<h3>Turquoise Button</h3>Use the settings bellow to customize the look of the Turquoise button.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");																	
						
$of_options[] = array(  "name" =>  "Turquoise Button Background Color",
						"desc" => "",
						"id" => "colored_bg_turquoise",
						"std" => "#00d1c5",
						"collapse_sec"	=> "turq_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Turquoise Button Text Color",
						"desc" => "",
						"id" => "colored_text_turquoise",
						"std" => "#fff",
						"collapse_sec"	=> "turq_bttn",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Turquoise Button Background Color on Hover",
						"desc" => "",
						"id" => "colored_bg_turquoise_hover",
						"std" => "#333",
						"collapse_sec"	=> "turq_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Turquoise Button Text Color on Hover",
						"desc" => "",
						"id" => "colored_text_turquoise_hover",
						"std" => "#fff",
						"collapse_sec"	=> "turq_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" => "Emerald Button",
						"desc" => "",
						"id" => "emerald_bttn",
						"std" => "<h3>Emerald Button</h3>Use the settings bellow to customize the look of the Emerald button.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");																	
						
$of_options[] = array(  "name" =>  "Emerald Button Background Color",
						"desc" => "",
						"id" => "colored_bg_emerald",
						"std" => "#37ba85",
						"collapse_sec"	=> "emerald_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Emerald Button Text Color",
						"desc" => "",
						"id" => "colored_text_emerald",
						"std" => "#fff",
						"collapse_sec"	=> "emerald_bttn",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Emerald Button Background Color on Hover",
						"desc" => "",
						"id" => "colored_bg_emerald_hover",
						"std" => "#333",
						"collapse_sec"	=> "emerald_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Emerald Button Text Color on Hover",
						"desc" => "",
						"id" => "colored_text_emerald_hover",
						"std" => "#fff",
						"collapse_sec"	=> "emerald_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" => "Amethyst Button",
						"desc" => "",
						"id" => "amethyst_bttn",
						"std" => "<h3>Amethyst Button</h3>Use the settings bellow to customize the look of the Amethyst button.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");																	
						
$of_options[] = array(  "name" =>  "Amethyst Button Background Color",
						"desc" => "",
						"id" => "colored_bg_amethyst",
						"std" => "#9b59b6",
						"collapse_sec"	=> "amethyst_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Amethyst Button Text Color",
						"desc" => "",
						"id" => "colored_text_amethyst",
						"std" => "#fff",
						"collapse_sec"	=> "amethyst_bttn",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Amethyst Button Background Color on Hover",
						"desc" => "",
						"id" => "colored_bg_amethyst_hover",
						"std" => "#333",
						"collapse_sec"	=> "amethyst_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Amethyst Button Text Color on Hover",
						"desc" => "",
						"id" => "colored_text_amethyst_hover",
						"std" => "#fff",
						"collapse_sec"	=> "amethyst_bttn",
						"type" => "color");		
						
$of_options[] = array(  "name" => "Wet Asphalt Button",
						"desc" => "",
						"id" => "wetasph_bttn",
						"std" => "<h3>Wet Asphalt Button</h3>Use the settings bellow to customize the look of the Wet Asphalt button.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");																	
						
$of_options[] = array(  "name" =>  "Wet Asphalt Button Background Color",
						"desc" => "",
						"id" => "colored_bg_wet_asphalt",
						"std" => "#34495e",
						"collapse_sec"	=> "wetasph_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Wet Asphalt Button Text Color",
						"desc" => "",
						"id" => "colored_text_wet_asphalt",
						"std" => "#fff",
						"collapse_sec"	=> "wetasph_bttn",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Wet Asphalt Button Background Color on Hover",
						"desc" => "",
						"id" => "colored_bg_wet_asphalt_hover",
						"std" => "#333",
						"collapse_sec"	=> "wetasph_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Wet Asphalt Button Text Color on Hover",
						"desc" => "",
						"id" => "colored_text_wet_asphalt_hover",
						"std" => "#fff",
						"collapse_sec"	=> "wetasph_bttn",
						"type" => "color");																								
						
$of_options[] = array(  "name" => "Light Button",
						"desc" => "",
						"id" => "light_bttn",
						"std" => "<h3>Light Button</h3>Use the settings bellow to customize the look of the white button.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	
																	
$of_options[] = array(  "name" =>  "Light Button Background Color",
						"desc" => "",
						"id" => "colored_bg_light",
						"std" => "#ffffff",
						"collapse_sec"	=> "light_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Light Button Text Color",
						"desc" => "",
						"id" => "colored_text_light",
						"std" => "#333333",
						"collapse_sec"	=> "light_bttn",
						"type" => "color");												
						
$of_options[] = array(  "name" =>  "Light Button Background Color on Hover",
						"desc" => "",
						"id" => "colored_bg_light_hover",
						"std" => "#555555",
						"collapse_sec"	=> "light_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Light Button Text Color on Hover",
						"desc" => "",
						"id" => "colored_text_light_hover",
						"std" => "#ffffff",
						"collapse_sec"	=> "light_bttn",
						"type" => "color");
						
$of_options[] = array(  "name" =>  "Light Button Border Color",
						"desc" => "",
						"id" => "colored_border_light",
						"std" => "#555555",
						"collapse_sec"	=> "light_bttn",
						"type" => "color");							
						
$of_options[] = array(  "name" =>  "Light Button Border Color on Hover",
						"desc" => "",
						"id" => "colored_border_light_hover",
						"std" => "#555555",
						"collapse_sec"	=> "light_bttn",
						"type" => "color");										

						
$of_options[] = array(  "name" => "Dark Button",
						"desc" => "",
						"id" => "dark_bttn",
						"std" => "<h3>Dark Button</h3>Use the settings bellow to customize the look of the dark button.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");						
						
$of_options[] = array(  "name" =>  "Dark Button Background Color",
						"desc" => "",
						"id" => "colored_bg_dark",
						"std" => "#555555",
						"collapse_sec"	=> "dark_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Dark Button Text Color",
						"desc" => "",
						"id" => "colored_text_dark",
						"std" => "#fff",
						"collapse_sec"	=> "dark_bttn",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Dark Button Background Color on Hover",
						"desc" => "",
						"id" => "colored_bg_dark_hover",
						"std" => "#fff",
						"collapse_sec"	=> "dark_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Dark Button Text Color on Hover",
						"desc" => "",
						"id" => "colored_text_dark_hover",
						"std" => "#555",
						"collapse_sec"	=> "dark_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Dark Button Border Color",
						"desc" => "",
						"id" => "colored_border_dark",
						"std" => "#555",
						"collapse_sec"	=> "dark_bttn",
						"type" => "color");							
						
$of_options[] = array(  "name" =>  "Dark Button Border Color on Hover",
						"desc" => "",
						"id" => "colored_border_dark_hover",
						"std" => "#555",
						"collapse_sec"	=> "dark_bttn",
						"type" => "color");
						
$of_options[] = array(  "name" => "Transparent Light Button",
						"desc" => "",
						"id" => "transparent_lght_bttn",
						"std" => "<h3>Transparent Light Button</h3>Use the settings bellow to customize the look of the transparent light button.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	
						
$of_options[] = array(  "name" =>  "Transparent Light Button Border Color",
						"desc" => "",
						"id" => "transparent_light_border",
						"std" => "#ffffff",
						"collapse_sec"	=> "transparent_lght_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Transparent Light Button Text Color",
						"desc" => "",
						"id" => "transparent_ligth_text",
						"std" => "#fff",
						"collapse_sec"	=> "transparent_lght_bttn",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Transparent Light Button Border Color on Hover",
						"desc" => "",
						"id" => "transparent_light_border_hover",
						"std" => "#ededed",
						"collapse_sec"	=> "transparent_lght_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Transparent Light Button Text Color on Hover",
						"desc" => "",
						"id" => "transparent_ligth_text_hover",
						"std" => "#ededed",
						"collapse_sec"	=> "transparent_lght_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" => "Transparent Dark Button",
						"desc" => "",
						"id" => "transparent_dark_bttn",
						"std" => "<h3>Transparent Dark Button</h3>Use the settings bellow to customize the look of the transparent dark button.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	
						
$of_options[] = array(  "name" =>  "Transparent Dark Button Border Color",
						"desc" => "",
						"id" => "transparent_dark_border",
						"std" => "#555555",
						"collapse_sec"	=> "transparent_dark_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Transparent Dark Button Text Color",
						"desc" => "",
						"id" => "transparent_dark_text",
						"std" => "#555555",
						"collapse_sec"	=> "transparent_dark_bttn",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Transparent Dark Button Border Color on Hover",
						"desc" => "",
						"id" => "transparent_dark_border_hover",
						"std" => "#7c7c7c",
						"collapse_sec"	=> "transparent_dark_bttn",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Transparent Dark Button Text Color on Hover",
						"desc" => "",
						"id" => "transparent_dark_text_hover",
						"std" => "#7c7c7c",
						"collapse_sec"	=> "transparent_dark_bttn",
						"type" => "color");																												

$of_options[] = array( 	"name" 		=> "VC Elements",
						"type" 		=> "heading"
				);
/*
$of_options[] = array(  "name" => "Minimal Buttons",
						"desc" => "",
						"id" => "min_buttons_shortcode",
						"std" => "<h3 style='margin: 0;'>Minimal Buttons Shortcode</h3>Use the settings bellow to customize the look of the minimal buttons.",
						"icon" => true,
						"type" => "info");
				
$of_options[] = array(  "name" =>  "Minimal Button Background Color",
						"desc" => "This setting also controls the background color of the Minimal Button Inverse, on hover.",
						"id" => "minimal_bg_color",
						"std" => "#333333",
						"type" => "color");	

$of_options[] = array(  "name" =>  "Minimal Button Text Color",
						"desc" => "",
						"id" => "minimal_text_color",
						"std" => "#ffffff",
						"type" => "color");						
						
$of_options[] = array(  "name" =>  "Minimal Button Inverse Background Color",
						"desc" => "This setting also controls the background color of the Minimal Button, on hover.",
						"id" => "minimal_bg_inverse_color",
						"std" => "#f96e5b",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Minimal Button Inverse Text Color",
						"desc" => "",
						"id" => "minimal_text_color_inverse",
						"std" => "#ffffff",
						"type" => "color");	
						
$of_options[] = array( 	"name" 		=> "Minimal Button Text Shadow",
						"desc" 		=> "Enable text shadow effect on Minimal Buttons - uncheck to disable!",
						"id" 		=> "minimal_text_shadow",
						"std" 		=> 1,
						"type" 		=> "switch"
				);																									
*/

$of_options[] = array(  "name" => "Accordion Element",
						"desc" => "",
						"id" => "accordion_el",
						"std" => "<h3>Accordion Element</h3>Use the settings bellow to customize the look of the accordion element.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");
						
$of_options[] = array(  "name" =>  "Active Section - Title Color",
						"desc" => "",
						"id" => "acc_active_title",
						"std" => "#f96e5b",
						"collapse_sec"	=> "accordion_el",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Active Section - Icon Color",
						"desc" => "",
						"id" => "acc_active_icon",
						"std" => "#f96e5b",
						"collapse_sec"	=> "accordion_el",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Inactive Section - Title Color",
						"desc" => "",
						"id" => "acc_inactive_title",
						"std" => "#333333",
						"collapse_sec"	=> "accordion_el",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Inactive Section - Icon Color",
						"desc" => "",
						"id" => "acc_inactive_icon",
						"std" => "#333333",
						"collapse_sec"	=> "accordion_el",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Separator color",
						"desc" => "",
						"id" => "acc_separator",
						"std" => "#dddddd",
						"collapse_sec"	=> "accordion_el",
						"type" => "color");																							
					
$of_options[] = array(  "name" => "Clients Element",
						"desc" => "",
						"id" => "clients_el",
						"std" => "<h3>Clients Element</h3>Use the settings bellow to customize the look of the clients element.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	
/*						
$of_options[] = array(  "name" =>  "Clients Border Width (px)",
						"desc" => "",
						"id" => "clients_border_width",
						"std" 		=> "5",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "10",
						"type" 		=> "sliderui");																												
*/						
$of_options[] = array(  "name" =>  "Clients Border Color",
						"desc" => "",
						"id" => "clients_border_color",
						"std" => "#F5F5F5",
						"collapse_sec"	=> "clients_el",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Clients Border Color on Hover",
						"desc" => "",
						"id" => "clients_border_color_hover",
						"std" => "#f96e5b",
						"collapse_sec"	=> "clients_el",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "Clients Effect",
						"desc" => "",
						"id" => "clients_effect",
						"std" 		=> "scroll",
						"type" 		=> "select",
						"collapse_sec"	=> "clients_el",
						"options" 	=> $of_options_effect
						);
						
$of_options[] = array( 	"name" => "Clients Autoplay Effect",
						"desc" => "",
						"id" => "clients_auto",
						"std" 		=> "false",
						"type" 		=> "select",
						"collapse_sec"	=> "clients_el",
						"options" 	=> $of_options_autoplay
						);	
						
$of_options[] = array(  "name" =>  "Clients Speed (miliseconds)",
						"desc" => "",
						"id" => "clients_speed",
						"std" 		=> "300",
						"min" 		=> "100",
						"step"		=> "100",
						"max" 		=> "1000",
						"collapse_sec"	=> "clients_el",
						"type" 		=> "sliderui");	
						
$of_options[] = array(  "name" =>  "Clients Pause Time (seconds)",
						"desc" => "",
						"id" => "clients_pause",
						"std" 		=> "3",
						"min" 		=> "1",
						"step"		=> "1",
						"max" 		=> "30",
						"collapse_sec"	=> "clients_el",
						"type" 		=> "sliderui");						
						
$of_options[] = array(  "name" => "Title Element",
						"desc" => "",
						"id" => "ctitle_el",
						"std" => "<h3> Title Element</h3>Use the settings bellow to customize the look of the Title element.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");													

$of_options[] = array( 	"name" => "Title Small Bottom Border",
						"desc" => "Enable small border just bellow the title - turn off to disable!",
						"id" => "cool_title_border",
						"std" => 1,
						"collapse_sec"	=> "ctitle_el",
						"type" => "switch"
				);

$of_options[] = array( 	"name" => "Disable Title Uppercase",
						"desc" => "Set this option to ON to disable the Forced Uppercase.",
						"id" => "cool_title_up",
						"std" => 0,
						"collapse_sec"	=> "ctitle_el",
						"type" => "switch"
				);
				
$of_options[] = array( 	"name" => "Title Small Bottom Border Color",
						"desc" => "",
						"id" => "cool_title_border_color",
						"std" => "#f96e5b",
						"collapse_sec"	=> "ctitle_el",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "Title Big Bottom Border Color",
						"desc" => "",
						"id" => "cool_title_big_border_color",
						"std" => "#e5e5e5",
						"collapse_sec"	=> "ctitle_el",
						"type" => "color");																						
				
$of_options[] = array(  "name" => "Featured Services Element",
						"desc" => "",
						"id" => "featured_services_el",
						"std" => "<h3>Featured Services Element</h3>Use the settings bellow to customize the look of the featured services element.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	
						
$of_options[] = array(  "name" =>  "Box Border (px)",
						"desc" => "",
						"id" => "fs_box_border_width",
						"std" 		=> "1",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "10",
						"collapse_sec"	=> "featured_services_el",
						"type" 		=> "sliderui");
						
$of_options[] = array( 	"name" => "Box Background Color",
						"desc" => "",
						"id" => "fs_box_bg_color",
						"std" => "#9f9f9",
						"collapse_sec"	=> "featured_services_el",
						"type" => "color");								
						
$of_options[] = array( 	"name" => "Box Background Color on Hover",
						"desc" => "",
						"id" => "fs_box_bg_color_hover",
						"std" => "#f96e5b",
						"collapse_sec"	=> "featured_services_el",
						"type" => "color");		
						
$of_options[] = array( 	"name" => "Icon Color",
						"desc" => "",
						"id" => "fs_box_icon_color",
						"std" => "#777777",
						"collapse_sec"	=> "featured_services_el",
						"type" => "color");		
						
$of_options[] = array( 	"name" => "Icon Color on Hover",
						"desc" => "",
						"id" => "fs_box_icon_color_hover",
						"std" => "#ffffff",
						"collapse_sec"	=> "featured_services_el",
						"type" => "color");							
						
$of_options[] = array( 	"name" => "Title Color",
						"desc" => "",
						"id" => "fs_box_title_color",
						"std" => "#f96e5b",
						"collapse_sec"	=> "featured_services_el",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "Title Color on Hover",
						"desc" => "",
						"id" => "fs_box_title_color_hover",
						"std" => "#ffffff",
						"collapse_sec"	=> "featured_services_el",
						"type" => "color");								
						
$of_options[] = array( 	"name" => "Text Color",
						"desc" => "",
						"id" => "fs_box_text_color",
						"std" => "#777777",
						"collapse_sec"	=> "featured_services_el",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "Text Color on Hover",
						"desc" => "",
						"id" => "fs_box_text_color_hover",
						"std" => "#ffffff",
						"collapse_sec"	=> "featured_services_el",
						"type" => "color");							
						
$of_options[] = array(  "name" => "Product Featured Element",
						"desc" => "",
						"id" => "product_feature_el",
						"std" => "<h3>Product Feature Element</h3>Use the settings bellow to customize the look of the product feature element.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");
/*
$of_options[] = array( 	"name" => "Product Feature Icon Background Color - Style 1",
						"desc" => "",
						"id" => "pf_icon_bg1",
						"std" => "#f96e5b",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "Product Feature Icon Color - Style 1",
						"desc" => "",
						"id" => "pf_icon_text1",
						"std" => "#ffffff",
						"type" => "color");		
						
$of_options[] = array( 	"name" => "Product Feature Title - Style 1",
						"desc" => "",
						"id" => "pf_icon_title1",
						"std" => "#f96e5b",
						"type" => "color");	
*/					
$of_options[] = array( 	"name" => "Product Feature Icon Background Color",
						"desc" => "",
						"id" => "pf_icon_bg2",
						"std" => "#333333",
						"collapse_sec"	=> "product_feature_el",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "Product Feature Icon Color",
						"desc" => "",
						"id" => "pf_icon_text2",
						"std" => "#ffffff",
						"collapse_sec"	=> "product_feature_el",
						"type" => "color");		
						
$of_options[] = array( 	"name" => "Product Feature Title",
						"desc" => "",
						"id" => "pf_icon_title2",
						"std" => "#333333",
						"collapse_sec"	=> "product_feature_el",
						"type" => "color");	
					
$of_options[] = array(  "name" => "Pricing Table Element",
						"desc" => "",
						"id" => "pricing_table_el",
						"std" => "<h3>Pricing Table Element</h3>Use the settings bellow to customize the look of the pricing table element.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");		
				
$of_options[] = array( 	"name" => "Best Pricing Column",
						"desc" => "Title Color",
						"id" => "pt_best_price_title",
						"std" => "#f96e5b",
						"collapse_sec"	=> "pricing_table_el",
						"type" => "color");				
				
$of_options[] = array( 	"name" => "",
						"desc" => "Price Background",
						"id" => "pt_best_price_bg",
						"std" => "#f96e5b",
						"collapse_sec"	=> "pricing_table_el",
						"type" => "color");		
						
$of_options[] = array( 	"name" => "",
						"desc" => "Text Color",
						"id" => "pt_best_price_text",
						"std" => "#ffffff",
						"collapse_sec"	=> "pricing_table_el",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "",
						"desc" => "Time Color",
						"id" => "pt_best_price_time",
						"std" => "#eeeeee",
						"collapse_sec"	=> "pricing_table_el",
						"type" => "color");		
						
$of_options[] = array( 	"name" => "Normal Pricing Column",
						"desc" => "Title Color",
						"id" => "pt_normal_price_title",
						"std" => "#444444",
						"collapse_sec"	=> "pricing_table_el",
						"type" => "color");				
				
$of_options[] = array( 	"name" => "",
						"desc" => "Price Background",
						"id" => "pt_normal_price_bg",
						"std" => "#ffffff",
						"collapse_sec"	=> "pricing_table_el",
						"type" => "color");		
						
$of_options[] = array( 	"name" => "",
						"desc" => "Text Color",
						"id" => "pt_normal_price_text",
						"std" => "#444444",
						"collapse_sec"	=> "pricing_table_el",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "",
						"desc" => "Time Color",
						"id" => "pt_normal_price_time",
						"std" => "#aaaaaa",
						"collapse_sec"	=> "pricing_table_el",
						"type" => "color");		
						
$of_options[] = array(  "name" => "Tabs Element",
						"desc" => "",
						"id" => "tabs_Element",
						"std" => "<h3>Tabs Element</h3>Use the settings bellow to customize the look of the tabs element.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	
						
$of_options[] = array( 	"name" => "Tabs Section - Border Color",
						"desc" => "",
						"id" => "tabs_border",
						"std" => "#e6e6e6",
						"collapse_sec"	=> "tabs_el",
						"type" => "color");
						
$of_options[] = array( 	"name" => "Tabs - Content Background Color",
						"desc" => "",
						"id" => "tabs_content_bg",
						"std" => "#ffffff",
						"collapse_sec"	=> "tabs_el",
						"type" => "color");
						
$of_options[] = array( 	"name" => "Tabs - Content Text Color",
						"desc" => "",
						"id" => "tabs_text",
						"std" => "#777777",
						"collapse_sec"	=> "tabs_el",
						"type" => "color");												

$of_options[] = array( 	"name" => "Active Tab - Border Top Color",
						"desc" => "",
						"id" => "tabs_active_tab",
						"std" => "#f96e5b",
						"collapse_sec"	=> "tabs_el",
						"type" => "color");
						
$of_options[] = array( 	"name" => "Active Tab - Text Color",
						"desc" => "",
						"id" => "tabs_active_text",
						"std" => "#f96e5b",
						"collapse_sec"	=> "tabs_el",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "Active Tab - Background Color",
						"desc" => "",
						"id" => "tabs_active_bg",
						"std" => "#ffffff",
						"collapse_sec"	=> "tabs_el",
						"type" => "color");		
						
$of_options[] = array( 	"name" => "Inactive Tab - Text Color",
						"desc" => "",
						"id" => "tabs_inactive_text",
						"std" => "#888888",
						"collapse_sec"	=> "tabs_el",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "Inactive Tab - Background Color",
						"desc" => "",
						"id" => "tabs_inactive_bg",
						"std" => "#f4f4f4",
						"collapse_sec"	=> "tabs_el",
						"type" => "color");		
						
$of_options[] = array(  "name" => "Tour Element",
						"desc" => "",
						"id" => "tour_el",
						"std" => "<h3>Tour Element</h3>Use the settings bellow to customize the look of the tour element.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	
						
$of_options[] = array( 	"name" => "Tour Section - Border Color",
						"desc" => "",
						"id" => "tour_border",
						"std" => "#e6e6e6",
						"collapse_sec"	=> "tour_el",
						"type" => "color");
						
$of_options[] = array( 	"name" => "Tour - Content Background Color",
						"desc" => "",
						"id" => "tour_content_bg",
						"std" => "#ffffff",
						"collapse_sec"	=> "tour_el",
						"type" => "color");
						
$of_options[] = array( 	"name" => "Tour - Content Text Color",
						"desc" => "",
						"id" => "tour_text",
						"std" => "#777777",
						"collapse_sec"	=> "tour_el",
						"type" => "color");												

$of_options[] = array( 	"name" => "Active Tour Tab - Border Left Color",
						"desc" => "",
						"id" => "tour_active_tab",
						"std" => "#f96e5b",
						"collapse_sec"	=> "tour_el",
						"type" => "color");
						
$of_options[] = array( 	"name" => "Active Tour Tab - Text Color",
						"desc" => "",
						"id" => "tour_active_text",
						"std" => "#f96e5b",
						"collapse_sec"	=> "tour_el",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "Active Tour Tab - Background Color",
						"desc" => "",
						"id" => "tour_active_bg",
						"std" => "#ffffff",
						"collapse_sec"	=> "tour_el",
						"type" => "color");		
						
$of_options[] = array( 	"name" => "Inactive Tour Tab - Text Color",
						"desc" => "",
						"id" => "tour_inactive_text",
						"std" => "#888888",
						"collapse_sec"	=> "tour_el",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "Inactive Tour Tab - Background Color",
						"desc" => "",
						"id" => "tour_inactive_bg",
						"std" => "#f4f4f4",
						"collapse_sec"	=> "tour_el",
						"type" => "color");															
																																		
$of_options[] = array(  "name" => "Call to Action Element",
						"desc" => "",
						"id" => "cta_el",
						"std" => "<h3>Call to Action</h3>Use the settings bellow to customize the look of the call to action element.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");
						
$of_options[] = array( 	"name" => "Call to Action - Box Border Color",
						"desc" => "",
						"id" => "tagline_box_border",
						"std" => "#e8e8e8",
						"collapse_sec"	=> "cta_el",
						"type" => "color");	

$of_options[] = array( 	"name" => "Call to Action - Inner Box Border Color",
						"desc" => "",
						"id" => "tagline_inner_box_border",
						"std" => "#f9f9f9",
						"collapse_sec"	=> "cta_el",
						"type" => "color");						
						
$of_options[] = array( 	"name" => "Call to Action - Box Background Color",
						"desc" => "",
						"id" => "tagline_box_bg",
						"std" => "#ffffff",
						"collapse_sec"	=> "cta_el",
						"type" => "color");
						
$of_options[] = array( 	"name" => "Call to Action - Box Title Color",
						"desc" => "",
						"id" => "tagline_box_title",
						"std" => "#444",
						"collapse_sec"	=> "cta_el",
						"type" => "color");		
						
$of_options[] = array(  "name" =>  "Call to Action - Box Title Size (px)",
						"desc" => "",
						"id" => "tagline_title_size",
						"std" 		=> "19",
						"min" 		=> "10",
						"step"		=> "1",
						"max" 		=> "40",
						"collapse_sec"	=> "cta_el",
						"type" 		=> "sliderui");	
						
$of_options[] = array(  "name" =>  "Call to Action - Box Text Size (px)",
						"desc" => "",
						"id" => "tagline_text_size",
						"std" 		=> "12",
						"min" 		=> "10",
						"step"		=> "1",
						"max" 		=> "40",
						"collapse_sec"	=> "cta_el",
						"type" 		=> "sliderui");																																			

$of_options[] = array(  "name" => "Testimonials Element",
						"desc" => "",
						"id" => "testimonial_el",
						"std" => "<h3>Testimonials Element</h3>Use the settings bellow to customize the look of the testimonial element.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");
						
$of_options[] = array( 	"name" => "Testimonial Background Color",
						"desc" => "",
						"id" => "testimonial_bg_color",
						"std" => "#EEE",
						"collapse_sec"	=> "testimonial_el",
						"type" => "color");		
						
$of_options[] = array( 	"name" => "Testimonial Border Color",
						"desc" => "",
						"id" => "testimonial_border_color",
						"std" => "#fff",
						"collapse_sec"	=> "testimonial_el",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "Testimonial Text Color",
						"desc" => "",
						"id" => "testimonial_text_color",
						"std" => "#222222",
						"collapse_sec"	=> "testimonial_el",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "Testimonial Author Color",
						"desc" => "",
						"id" => "testimonial_author_color",
						"std" => "#222222",
						"collapse_sec"	=> "testimonial_el",
						"type" => "color");			
						
$of_options[] = array( 	"name" => "Testimonial Link Color",
						"desc" => "",
						"id" => "testimonial_link_color",
						"std" => "#f96e5b",
						"collapse_sec"	=> "testimonial_el",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "Testimonial Link Color Hover",
						"desc" => "",
						"id" => "testimonial_link_color_hover",
						"std" => "#222222",
						"collapse_sec"	=> "testimonial_el",
						"type" => "color");																																				
/*
$of_options[] = array( 	"name" => "Testimonial Text Shadow",
						"desc" => "Enable text shadow - turn off to disable!",
						"id" => "testimonial_text_shadow",
						"std" => 1,
						"type" => "switch");
*/					
$of_options[] = array( 	"name" => "Testimonial Text Alignment",
						"desc" => "",
						"id" => "testimonial_text_align",
						"std" 		=> "Left",
						"type" 		=> "select",
						"collapse_sec"	=> "testimonial_el",
						"options" 	=> $of_options_info
						);	
																							
						
$of_options[] = array( 	"name" => "Testimonial Author Details Position",
						"id" => "testimonial_author_position",
						"std" 		=> "Right",
						"type" 		=> "select",
						"collapse_sec"	=> "testimonial_el",
						"options" 	=> $of_options_info
						);	
						
$of_options[] = array( 	"name" => "Testimonial Effect",
						"desc" => "",
						"id" => "testimonial_effect",
						"std" 		=> "scroll",
						"type" 		=> "select",
						"collapse_sec"	=> "testimonial_el",
						"options" 	=> $of_options_effect
						);
						
$of_options[] = array( 	"name" => "Testimonial Autoplay Effect",
						"desc" => "",
						"id" => "testimonial_auto",
						"std" 		=> "false",
						"type" 		=> "select",
						"collapse_sec"	=> "testimonial_el",
						"options" 	=> $of_options_autoplay
						);	
						
$of_options[] = array(  "name" =>  "Testimonial Transition Speed (miliseconds)",
						"desc" => "",
						"id" => "testimonial_speed",
						"std" 		=> "300",
						"min" 		=> "100",
						"step"		=> "100",
						"max" 		=> "1000",
						"collapse_sec"	=> "testimonial_el",
						"type" 		=> "sliderui");	
						
$of_options[] = array(  "name" =>  "Testimonial Pause Time (seconds)",
						"desc" => "",
						"id" => "testimonial_pause",
						"std" 		=> "3",
						"min" 		=> "1",
						"step"		=> "1",
						"max" 		=> "30",
						"collapse_sec"	=> "testimonial_el",
						"type" 		=> "sliderui");	
																																							

$of_options[] = array(  "name" => "Toggle Box Element",
						"desc" => "",
						"id" => "toggle_box_el",
						"std" => "<h3>Toggle Box Element</h3>Use the settings bellow to customize the look of the toggle box element.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");
						
$of_options[] = array( 	"name" => "Toggle Box Icon Position",
						"desc" => "",
						"id" => "tb_pos",
						"std" 		=> "left",
						"type" 		=> "select",
						"collapse_sec"	=> "toggle_box_el",
						"options" 	=> $of_options_tb
						);			
						
$of_options[] = array( 	"name" => "Toggle Box Icon Color",
						"desc" => "",
						"id" => "tb_icon_color",
						"std" => "#333",
						"collapse_sec"	=> "toggle_box_el",
						"type" => "color");
						
$of_options[] = array( 	"name" => "Toggle Box Title Color",
						"desc" => "",
						"id" => "tb_title_color",
						"std" => "#333",
						"collapse_sec"	=> "toggle_box_el",
						"type" => "color");	
						
$of_options[] = array( 	"name" => "Toggle Box Icon Color on Hover / Expanded",
						"desc" => "",
						"id" => "tb_icon_color_hov",
						"std" => "#333",
						"collapse_sec"	=> "toggle_box_el",
						"type" => "color");
						
$of_options[] = array( 	"name" => "Toggle Box Title Color on Hover / Expanded",
						"desc" => "",
						"id" => "tb_title_color_hov",
						"std" => "#333",
						"collapse_sec"	=> "toggle_box_el",
						"type" => "color");	
						
$of_options[] = array(  "name" => "Tooltip Element",
						"desc" => "",
						"id" => "tooltip_el",
						"std" => "<h3>Tooltip Element</h3>Use the settings bellow to customize the look of the tooltip element.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");																																		
						
$of_options[] = array(  "name" =>  "Tooltip Background Color",
						"desc" => "",
						"id" => "tooltip_bg_color",
						"std" => "#000000",
						"collapse_sec"	=> "tooltip_el",
						"type" => "color");
						
$of_options[] = array(  "name" =>  "Tooltip Text Color",
						"desc" => "",
						"id" => "tooltip_text_color",
						"std" => "#ffffff",
						"collapse_sec"	=> "tooltip_el",
						"type" => "color");
/*
$of_options[] = array( 	"name" 		=> "Shortcodes",
						"type" 		=> "heading"
				);
				
$of_options[] = array(  "name" => "Checklist Shortcode",
						"desc" => "",
						"id" => "checklist_shortcode",
						"std" => "<h3 style='margin: 0;'>Checklist Shortcode</h3>Use the settings bellow to customize the look of the checklists.",
						"icon" => true,
						"type" => "info");	
						
$of_options[] = array(  "name" =>  "Checklist Color",
						"desc" => "",
						"id" => "checklist_color",
						"std" => "#777777",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Checklist Margin Left (px)",
						"desc" => "",
						"id" => "checklist_margin_left",
						"std" 		=> "0",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "30",
						"type" 		=> "sliderui");					

$of_options[] = array( 	"name" 		=> "Comments",
						"type" 		=> "heading"
				);
*/	

$of_options[] = array( 	"name" 		=> "Comments",
						"type" 		=> "heading"
				);
			
$of_options[] = array(  "name" => "Comments Settings",
						"desc" => "",
						"id" => "comm_settings",
						"std" => "<h3 style='margin: 0;'>Comments Settings</h3>",
						"icon" => true,
						"type" => "info");	
						
$of_options[] = array(  "name" => "Posts Comments",
						"desc" => "Show comments on single post pages.",
						"id" => "blog_comments",
						"std" => 1,
						"type" => "switch");									
						
$of_options[] = array(  "name" => "Page Comments - Default Template",
						"desc" => "Show comments on pages - default template.",
						"id" => "default_comments",
						"std" => 0,
						"type" => "switch");

$of_options[] = array(  "name" => "Submit Comment - Button Style ",
						"desc" => "Select the style for the Submit Comment button",
						"id" => "comment_style",
						"std" => "minimal",
						"type" => "select",
						"options" => array('minimal' => 'Minimal', '3d' => '3D'));	
						
$of_options[] = array(  "name" => "Submit Comment - Button Color",
						"desc" => "Select the color of the Submit Comment button",
						"id" => "comment_color",
						"std" => "lightred",
						"type" => "select",
						"options" => array( 'lightred' => 'Light Red',
											'darkred' => 'Dark Red',  
											'orange' => 'Orange',  
											'turquoise' => 'Turquoise',
											'emerald' => 'Emerald',
											'lightblue' => 'Light Blue',
											'amethyst' => 'Amethyst',
											'wetasphalt' => 'Wet Asphalt',
											'light' => 'Light',
											'dark' => 'Dark'
									 ));
									 
$of_options[] = array(  "name" => "Submit Comment - Button Size",
						"desc" => "Select the size of the Submit Comment button",
						"id" => "comment_size",
						"std" => "small",
						"type" => "select",
						"options" => array('small' => 'Small', 'large' => 'Large'));
						
$of_options[] = array(  "name" => "Submit Comment - Button Icon",
						"desc" => "Insert a fontawesome icon.",
						"id" => "comment_icon",
						"std" => "fa-comments",
						"type" => "text");															 						

$of_options[] = array( 	"name" 		=> "Blog Options",
						"type" 		=> "heading"
				);
				
$of_options[] = array(  "name" => "Blog Global Settings",
						"desc" => "",
						"id" => "global_blog_settings",
						"std" => "<h3>Blog Global Settings</h3>Use the settings bellow to customize the Blog pages, archives and Posts Grid element.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord admin_expand",
						"collapse"	=> true,
						"type" => "info");	

$of_options[] = array(  "name" => "Animate Posts on scroll",
						"desc" => "Enable this option to animate posts on scroll ",
						"id" => "animate_posts_scroll",
						"std" => 0,
						"collapse_sec"	=> "global_blog_settings",
						"type" => "switch");	

$of_options[] = array(	"name" => "Enable Infinite Posts Scroll",
						"desc" => "",
						"id" => "infinite_scroll",
						"std" 		=> "no",
						"type" 		=> "select",
						"collapse_sec"	=> "global_blog_settings",
						"options" => array(						
							'no' => 'No',
							'yes' => 'Yes',
						));								
						
$of_options[] = array(	"name" => "Featured Image Link to",
						"desc" => "Select where the Featured Image of the Posts Grid element links to: post page or bigger image.",
						"id" => "fi_post_link",
						"std" 		=> "bigger_image",
						"type" 		=> "select",
						"collapse_sec"	=> "global_blog_settings",
						"options" => array(						
							'bigger_image' => 'Bigger Image',
							'post_page' => 'Post Page',
						));								
				
$of_options[] = array(  "name" => "Single Post Page",
						"desc" => "",
						"id" => "single_post_page",
						"std" => "<h3>Single Post Page</h3>Use the settings bellow to customize the single post page.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");

$of_options[] = array( 	"name" => "Single Post Page design",
						"desc" => "Select the design of the Single Post page",
						"id" => "spp_design",
						"std" => "style1",
						"type" => "select",						
						"collapse_sec"	=> "single_post_page",
						"options" => array(						
							'style1' => 'Style 1',
							'style2' => 'Style 2',
							'style3' => 'Style 3',
						));		

$of_options[] = array(  "name" => "Post Title",
						"desc" => "Show the post title that goes below the featured images",
						"id" => "blog_post_title",
						"std" => 1,
						"collapse_sec"	=> "single_post_page",
						"type" => "switch");				

$of_options[] = array(  "name" => "Featured Image on Single Post Page",
						"desc" => "Show featured images on top on single post pages.",
						"id" => "featured_images_single",
						"std" => 1,
						"collapse_sec"	=> "single_post_page",
						"type" => "switch");
						
$of_options[] = array(  "name" => "Social Sharing Box",
						"desc" => "Show the social sharing box.",
						"id" => "social_sharing_box",
						"std" => 1,
						"folds" =>1,
						"collapse_sec"	=> "single_post_page",
						"type" => "switch");

$of_options[] = array( 	"name" => "Social Sharing Icons Shape",
						"desc" => "Select the shape of the social icons",
						"id" => "social_icons_shape",
						"std" => "Rounded",
						"type" => "select",
						"fold" => "social_sharing_box",
						"collapse_sec"	=> "single_post_page",
						"options" => array(						
							'rounded' => 'Round',
							'square' => 'Square',
						));							
						
$of_options[] = array(  "name" => "Related Posts",
						"desc" => "Show related posts.",
						"id" => "related_posts",
						"std" => 1,
						"folds" => 1,
						"collapse_sec"	=> "single_post_page",
						"type" => "switch");
						
$of_options[] = array( 	"name" 		=> "Related Posts Quantity",
						"desc" 		=> "How many related posts to be displayed on single post pages",
						"id" 		=> "related_posts_number",
						"std" 		=> "4",
						"min" 		=> "1",
						"step"		=> "1",
						"max" 		=> "15",
						"fold"		=> "related_posts",
						"collapse_sec"	=> "single_post_page",
						"type" 		=> "sliderui" 
				);	

$of_options[] = array( 	"name" => "Related Posts Design",
						"desc" => "Select the design of the Related Posts section",
						"id" => "rp_design",
						"std" => "carousel",
						"type" => "select",						
						"collapse_sec"	=> "single_post_page",
						"fold"		=> "related_posts",
						"options" => array(						
							'carousel' => 'Carousel',
							'list' => 'Vertical List'
							//'grid' => 'Horizontal Grid',
						));							

						
$of_options[] = array(  "name" => "Show Post Date",
						"desc" => "Turn Off to hide date on single post page.",
						"id" => "post_meta_date",
						"std" => 1,
						"collapse_sec"	=> "single_post_page",
						"type" => "switch");						
						
$of_options[] = array(  "name" => "Show Post Tags",
						"desc" => "Turn Off to hide tags from on single post page.",
						"id" => "post_meta_tags",
						"std" => 0,
						"collapse_sec"	=> "single_post_page",
						"type" => "switch");						
						
$of_options[] = array(  "name" => "Show Previous/Next Pagination",
						"desc" => "Turn Off to disable previous/next pagination",
						"id" => "blog_pn_nav",
						"std" => 1,
						"collapse_sec"	=> "single_post_page",
						"type" => "switch");																			

$of_options[] = array(  "name" => "Post Meta Settings - Affects Single Post and Archive Page!",
						"desc" => "",
						"id" => "post_meta_sett",
						"std" => "<h3>Post Meta Settings !</h3>These settings affect both single post and archive pages.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	

$of_options[] = array(  "name" => "Show Post Meta Date",
						"desc" => "Turn Off to hide date from post meta on archive and Blog Templates.",
						"id" => "post_meta_date_archive",
						"std" => 1,
						"collapse_sec"	=> "post_meta_sett",
						"type" => "switch");
						
$of_options[] = array(  "name" => "Show Post Meta Author",
						"desc" => "Turn Off to hide author name from post meta.",
						"id" => "post_meta_author",
						"std" => 1,
						"collapse_sec"	=> "post_meta_sett",
						"type" => "switch");																										
						
$of_options[] = array(  "name" => "Show Post Meta Categories",
						"desc" => "Turn Off to hide categories from post meta.",
						"id" => "post_meta_cats",
						"std" => 1,
						"collapse_sec"	=> "post_meta_sett",
						"type" => "switch");						
						
$of_options[] = array(  "name" => "Show Post Meta Comments",
						"desc" => "Turn Off to hide comments from post meta.",
						"id" => "post_meta_comments",
						"std" => 1,
						"collapse_sec"	=> "post_meta_sett",
						"type" => "switch");

$of_options[] = array(  "name" => "Show Post Meta Icons",
						"desc" => "Show or Hide the Post Meta icons.",
						"id" => "post_meta_icons",
						"std" => 1,
						"collapse_sec"	=> "post_meta_sett",
						"type" => "switch");

$of_options[] = array(  "name" => "Sidebar Settings",
						"desc" => "",
						"id" => "sidebar_settings",
						"std" => "<h3>Sidebar Settings</h3>Use the settings bellow to customize the Blog sidebar.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	

$of_options[] = array( 	"name" => "Sidebar Design",
						"desc" => "Select the sidebar design",
						"id" => "sidebar_design",
						"std" 		=> "default",
						"type" 		=> "select",
						"collapse_sec"	=> "sidebar_settings",
						"options" => array(						
							'style1' => 'Style 1',
							'style2' => 'Style 2'
						));	

$of_options[] = array(  "name" => "Sidebar Headings Font Weight",
						"desc" => "",
						"id" => "sidebar_font_weight",
						"std" => "400",
						"collapse_sec"	=> "sidebar_settings",	
						"type" => "select",
						"options" => array('300', '400', '500', '600', '700'));													
						
$of_options[] = array( 	"name" => "Sticky Sidebar",
						"id" => "sticky_sidebar",
						"std" 		=> 0,	
						"desc" => "Enable/disable the Sticky Sidebar",					
						"collapse_sec"	=> "sidebar_settings",
						"type" => "switch");					

$of_options[] = array(  "name" => "Archive Page",
						"desc" => "",
						"id" => "archive_page_sett",
						"std" => "<h3>Archive Page</h3>Use the settings bellow to customize the archive page.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");

$of_options[] = array( 	
						"name" => "Archive Page Layout",
						"desc" => "Select the layout to be used on the Archive pages",
						"id" => "archive_layout",
						"std" => "big_images",
						"type" => "select",	
						"collapse_sec"	=> "archive_page_sett",					
						"options" => array(						
							'big_img' => 'Big Images',
							'small_img' => 'Small Images',
						));
						
$of_options[] = array( 	"name" 		=> "Posts per page",
						"desc" 		=> "How many posts to be displayed on archive pages",
						"id" 		=> "archive_posts",
						"std" 		=> "8",
						"min" 		=> "1",
						"step"		=> "1",
						"max" 		=> "20",
						"collapse_sec"	=> "archive_page_sett",	
						"type" 		=> "sliderui" 
				);	
				
$of_options[] = array(  "name" => "Category Description",
						"desc" => "Show/Hide Category Description.",
						"id" => "categ_desc",
						"std" => 1,
						"folds" => 1,
						"collapse_sec"	=> "archive_page_sett",	
						"type" => "switch");

$of_options[] = array(  "name" =>  "",
						"desc" => "Category description background color",
						"id" => "categ_desc_bg",
						"std" => "#f7f7f7",
						"fold" => "categ_desc",
						"collapse_sec"	=> "archive_page_sett",	
						"type" => "color");

$of_options[] = array(  "name" =>  "",
						"desc" => "Category description text color",
						"id" => "categ_desc_text",
						"std" => "#777777",
						"fold" => "categ_desc",
						"collapse_sec"	=> "archive_page_sett",	
						"type" => "color");							
						
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "Category description border width (px)",
						"id" 		=> "categ_desc_border",
						"std" 		=> "1",
						"min" 		=> "0",
						"step"		=> "1",
						"max" 		=> "10",
						"fold" => "categ_desc",
						"collapse_sec"	=> "archive_page_sett",	
						"type" 		=> "sliderui" 
				);
				
$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "Category description border color",
						"id" 		=> "categ_desc_border_color",
						"std" => "#f2f2f2",
						"fold" => "categ_desc",
						"collapse_sec"	=> "archive_page_sett",	
						"type" => "color"
				);																										
						
$of_options[] = array(  "name" =>  "Blog Post Date Background Color on Archive Page",
						"desc" => "",
						"id" => "blog_post_date_bg_color",
						"std" => "#f96e5b",
						"collapse_sec"	=> "archive_page_sett",	
						"type" => "color");	
				
$of_options[] = array(  "name" =>  "Blog Post Icon Color on Archive Page",
						"desc" => "",
						"id" => "blog_post_icon_color",
						"std" => "#999999",
						"collapse_sec"	=> "archive_page_sett",	
						"type" => "color");	
						
$of_options[] = array(  "name" => "Show Post Date on Archive Page",
						"desc" => "Turn Off to hide date from archive page.",
						"id" => "post_archive_date",
						"std" => 1,
						"collapse_sec"	=> "archive_page_sett",	
						"type" => "switch");						
						
$of_options[] = array(  "name" => "Show Post Icon on Archive Page",
						"desc" => "Turn Off to hide post icon.",
						"id" => "post_meta_icon",
						"std" => 1,
						"collapse_sec"	=> "archive_page_sett",	
						"type" => "switch");																			
												

$of_options[] = array(  "name" => "Show Post Meta Read More Link",
						"desc" => "Turn Off to hide read more link from post meta.",
						"id" => "post_meta_read",
						"std" => 1,
						"collapse_sec"	=> "archive_page_sett",	
						"type" => "switch");
						
$of_options[] = array(  "name" => "Excerpt vs Post Content",
						"desc" => "",
						"id" => "excerpt_post_content",
						"std" => "<h3>Post Excerpt vs Post Content</h3>Use the settings bellow to choose what to show on archive pages.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");						
						
$of_options[] = array( 	
						"desc" => "Display post excerpt or full post content on archive pages.",
						"id" => "archive_excerpt_full",
						"std" 		=> "slide",
						"type" 		=> "select",
						"collapse_sec"	=> "excerpt_post_content",	
						"options" => array(						
							'excerpt' => 'Post Excerpt',
							'full' => 'Full Content',
						));							
						
$of_options[] = array(  "name" => "Excerpt Length",
						"desc" => "Input the number of words you want to cut from the content to be the excerpt of search and archive page.",
						"id" => "excerpt_length_blog",
						"std" => "40",
						"collapse_sec"	=> "excerpt_post_content",	
						"type" => "text");			
						
$of_options[] = array(  "name" => "Strip HTML from Excerpt",
						"desc" => "Check this if you want to strip HTML from the excerpt content only.",
						"id" => "strip_html_excerpt",
						"std" => 1,
						"collapse_sec"	=> "excerpt_post_content",	
						"type" => "switch");	
						
$of_options[] = array(  "name" => "Animations",
						"desc" => "",
						"id" => "blog_animations",
						"std" => "<h3>Blog Post Slideshow</h3>Use the settings bellow to customize the animation of the blog post featured images.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");		
						
$of_options[] = array( 	"name" => "Slideshows Animation Effect",
						"desc" => "Select the effect for the slideshow animation.",
						"id" => "bp_anim",
						"std" 		=> "slide",
						"type" 		=> "select",
						"collapse_sec"	=> "blog_animations",	
						"options" 	=> $of_options_animation
						);
/*						
$of_options[] = array( 	"name" => "Slideshows Animation Direction",
						"desc" => "Only works for SLIDE animation effect.",
						"id" => "bp_anim_dir",
						"std" 		=> "slide",
						"type" 		=> "select",
						"options" 	=> $of_options_direction
						);		
*/						
$of_options[] = array( 	"name" => "Slideshow Controls",
						"desc" => "Display slideshow controls. ",
						"id" => "bp_anim_control",
						"std" => 1,
						"collapse_sec"	=> "blog_animations",
						"type" => "switch");										
						
$of_options[] = array( 	"name" => "Slideshow Animation Autoplay",
						"desc" => "Turn On to enable Slideshow Autoplay.",
						"id" => "bp_anim_auto",
						"std" => 0,
						"collapse_sec"	=> "blog_animations",
						"type" => "switch");
						
$of_options[] = array( 	"name" => "Slideshow Animation Pause on Hover",
						"desc" => "Turn on to pause the slideshow on user hover. ",
						"id" => "bp_anim_pause",
						"std" => 1,
						"collapse_sec"	=> "blog_animations",
						"type" => "switch");
						
$of_options[] = array( 	"name" => "Slideshow Animation Speed",
						"desc" => "Select the speed of the slideshow, in miliseconds.",
						"id" => "bp_anim_speed",
						"std" 		=> "300",
						"min" 		=> "100",
						"step"		=> "50",
						"max" 		=> "2000",
						"collapse_sec"	=> "blog_animations",
						"type" 		=> "sliderui");		
						
$of_options[] = array( 	"name" => "Slideshow Animation Pause Time",
						"desc" => "Select the pause time for the slideshow, in seconds.",
						"id" => "bp_anim_pause_time",
						"std" 		=> "5",
						"min" 		=> "1",
						"step"		=> "1",
						"max" 		=> "10",
						"collapse_sec"	=> "blog_animations",
						"type" 		=> "sliderui");																																																													

$of_options[] = array( 	"name" 		=> "Portfolio Options",
						"type" 		=> "heading"
				);

$of_options[] = array( 	"name" 		=> "Portfolio Options",
						"desc" 		=> "",
						"id" 		=> "portfolio_sett",
						"std" 		=> "<h3>Portfolio Settings.</h3>",
						"icon" 		=> true,						
						"class" 	=>"hide_me admin_accord admin_expand",
						"collapse"	=> true,
						"type" 		=> "info"
				);	
				
$of_options[] = array( 	"name" => "Portfolio Items",
						"desc" => "Select how many portfolio items to display on portfolio pages (2 columns, 3 columns, 4 columns, hexagon columns, rounded columns).",
						"id" => "port_items",
						"std" 		=> "12",
						"min" 		=> "2",
						"step"		=> "1",
						"max" 		=> "30",
						"collapse_sec"	=> "portfolio_sett",
						"type" 		=> "sliderui");	
						
$of_options[] = array(  "name" => "Portfolio Slug",
						"desc" => "Change/Rewrite the permalink when you use the permalink type as %postname%.<strong>Make sure to regenerate permalinks.</strong>",
						"id" => "portfolio_slug",
						"collapse_sec"	=> "portfolio_sett",
						"std" => "portfolio-items",
						"type" => "text");	

$of_options[] = array(  "name" => "Portfolio Sidebar",
						"desc" => "Select the default sidebar that will be used for Portfolio posts.",
						"id" => "portfolio_sidebar",
						"std" => "None",
						"type" => "select",
						"collapse_sec"	=> "portfolio_sett",
						"options" => $sidebar_options
					);

$of_options[] = array( 	"name" => "Page Template Image Size",
						"desc" => "Choose the Image Size used for Portfolio Page Templates.",
						"id" => "portfolio_img_size",
						"std" 		=> "bigger_image",
						"type" 		=> "select",
						"collapse_sec"	=> "portfolio_sett",
						"options" => array(						
							'theme' => 'Theme Generated',
							'full' => 'Full Image',
						));							
						
$of_options[] = array(  "name" => "Portfolio Text Fields",
						"desc" => "",
						"id" => "port_text_field",
						"std" => "<h3>Portfolio Text Fields</h3>Use the settings bellow to change the text for the Portfolio Fields.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	

$of_options[] = array( 	"name" 		=> "Project Details Text",
						"desc" 		=> "Enter the text you want to use for Project Details text tag. Default is: Project Details.<br />Leave empty if you don't want to show anything.",
						"id" 		=> "project_details_text",
						"std" 		=> "Project Details",
						"collapse_sec"	=> "port_text_field",
						"type" 		=> "text"
				);

$of_options[] = array( 	"name" 		=> "Project Description Text",
						"desc" 		=> "Enter the text you want to use for Project Description text tag. Default is: Project Description.<br />Leave empty if you don't want to show anything.",
						"id" 		=> "project_description_text",
						"std" 		=> "Project Description",
						"collapse_sec"	=> "port_text_field",
						"type" 		=> "text"
				);	

$of_options[] = array( 	"name" 		=> "Related Projects Text",
						"desc" 		=> "Enter the text you want to use for Related Projects text tag. Default is: Related Projects.<br />Leave empty if you don't want to show anything.",
						"id" 		=> "project_related_text",
						"std" 		=> "Related Projects",
						"collapse_sec"	=> "port_text_field",
						"type" 		=> "text"
				);		
				
$of_options[] = array( 	"name" 		=> "Client Text",
						"desc" 		=> "Enter the text you want to use for Client text tag. Default is: Client.<br />This will only appear in the front end. In the backend you will still see Client.",
						"id" 		=> "project_client_text",
						"collapse_sec"	=> "port_text_field",
						"std" 		=> "Client",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "Skills Text",
						"desc" 		=> "Enter the text you want to use for Skills text tag. Default is: Skills.<br />This will only appear in the front end. In the backend you will still see Skills.",
						"id" 		=> "project_skills_text",
						"std" 		=> "Skills",
						"collapse_sec"	=> "port_text_field",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "Website Text",
						"desc" 		=> "Enter the text you want to use for Website text tag. Default is: Website.<br />This will only appear in the front end. In the backend you will still see Website.",
						"id" 		=> "project_website_text",
						"std" 		=> "Website",
						"collapse_sec"	=> "port_text_field",
						"type" 		=> "text"
				);																																	
						
$of_options[] = array(  "name" => "Single Portfolio Page",
						"desc" => "",
						"id" => "single_portfolio_page",
						"std" => "<h3>Single Portfolio Page</h3>Use the settings bellow to customize the single portfolio page.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	
						
$of_options[] = array( 	"name" => "Enable Project Details",
						"desc" => "This will show up the project details on the single portfolio page. ",
						"id" => "port_details",
						"std" => 1,
						"folds" => 1,
						"collapse_sec"	=> "single_portfolio_page",
						"type" => "switch");
						
$of_options[] = array( 	"name" => "Project Creation Date",
						"desc" => "Show the project creation date. ",
						"id" => "port_date",
						"std" => 1,
						"fold" => "port_details",
						"collapse_sec"	=> "single_portfolio_page",
						"type" => "switch");	
						
$of_options[] = array( 	"name" => "Project Client Name",
						"desc" => "Show the project client name. ",
						"id" => "port_client",
						"std" => 1,
						"fold" => "port_details",
						"collapse_sec"	=> "single_portfolio_page",
						"type" => "switch");
						
$of_options[] = array( 	"name" => "Project Skills",
						"desc" => "Show the project skills. ",
						"id" => "port_skills",
						"std" => 1,
						"fold" => "port_details",
						"collapse_sec"	=> "single_portfolio_page",
						"type" => "switch");
						
$of_options[] = array( 	"name" => "Project Website",
						"desc" => "Show the project website. ",
						"id" => "port_website",
						"std" => 1,
						"fold" => "port_details",
						"collapse_sec"	=> "single_portfolio_page",
						"type" => "switch");																																						

$of_options[] = array( 	"name" => "Related Projects",
						"desc" => "Show/hide related portfolio posts. ",
						"id" => "related_portfolio",
						"std" => 1,
						"collapse_sec"	=> "single_portfolio_page",
						"type" => "switch");

$of_options[] = array(	"name" => "Headings Style",
						"desc" => "Select Headings style for Portfolio items.",
						"id" => "port_headings",
						"std" 		=> "bigger_image",
						"type" 		=> "select",
						"collapse_sec"	=> "single_portfolio_page",
						"options" => array(						
							'style1' => 'Style 1',
							'style2' => 'Style 2',
						));	

/*
$of_options[] = array( 	"name" => "Project Launch Button",
						"desc" => "Show the project launch button. ",
						"id" => "port_button",
						"std" => 1,
						"fold" => "port_details",
						"type" => "switch");																																						
*/
$of_options[] = array(  "name" => "Portfolio Element and Portfolio Columns",
						"desc" => "",
						"id" => "portfolio_el_sett",
						"std" => "<h3>Portfolio Element and Portfolio Columns</h3>Use the settings bellow to customize the portfolio columns page and portfolio shortcode.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");
						
$of_options[] = array( 	
						"desc" => "Select where the Portfolio Image links to: portfolio post or bigger image.",
						"id" => "portfolio_link",
						"std" 		=> "bigger_image",
						"type" 		=> "select",
						"collapse_sec"	=> "portfolio_el_sett",
						"options" => array(						
							'bigger_image' => 'Bigger Image',
							'portfolio_post' => 'Portfolio Post',
						));		
						
$of_options[] = array( 	"name" => "Show portfolio title and categories box",
						"desc" => "Select if you want to display the portfolio title and categories box bellow the portfolio image.",
						"id" => "portfolio_details",
						"std" 		=> "yes",
						"collapse_sec"	=> "portfolio_el_sett",
						"type" 		=> "switch"
						);												
				
$of_options[] = array(  "name" =>  "Portfolio Title Background Color ",
						"desc" => "",
						"fold" => "portfolio_details",
						"id" => "portf_title_bg_color",
						"std" => "#F5F5F5",
						"collapse_sec"	=> "portfolio_el_sett",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Portfolio Title Background Color Hover",
						"desc" => "",
						"fold" => "portfolio_details",
						"id" => "portf_title_bg_color_hover",
						"std" => "#f96e5b",
						"collapse_sec"	=> "portfolio_el_sett",
						"type" => "color");								
						
$of_options[] = array(  "name" =>  "Portfolio Title Link Color",
						"desc" => "",
						"fold" => "portfolio_details",
						"id" => "portf_title_link_color",
						"std" => "#444444",
						"collapse_sec"	=> "portfolio_el_sett",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Portfolio Title Link Color on Hover ",
						"desc" => "",
						"fold" => "portfolio_details",
						"id" => "portf_title_link_color_hover",
						"std" => "#ffffff",
						"collapse_sec"	=> "portfolio_el_sett",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Portfolio Categories Link Color ",
						"desc" => "",
						"fold" => "portfolio_details",
						"id" => "portf_categ_link_color",
						"std" => "#555555",
						"collapse_sec"	=> "portfolio_el_sett",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "Portfolio Categories Link Color on Hover ",
						"desc" => "",
						"fold" => "portfolio_details",
						"id" => "portf_categ_link_color_hover",
						"std" => "#ffffff",
						"collapse_sec"	=> "portfolio_el_sett",
						"type" => "color");	

$of_options[] = array(  "name" => "Rounded & Hexagonal Portfolio Settings",
						"desc" => "",
						"id" => "portfolio_hexa_sett",
						"std" => "<h3>Rounded & Hexagonal Portfolio Settings</h3>Use the settings bellow to customize the rounded and hexagonal portfolio page.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");
						
$of_options[] = array(  "name" =>  "Rounded & Hexagonal Portfolio Background Color",
						"desc" => "",
						"id" => "portf_rh_bg",
						"std" => "#f96e5b",
						"collapse_sec"	=> "portfolio_hexa_sett",
						"type" => "color");										
						
$of_options[] = array(  "name" => "Portfolio Slideshow Settings",
						"desc" => "",
						"id" => "portfolio_slide",
						"std" => "<h3>Portfolio Slideshow Settings</h3>Use the settings bellow to customize the look of the Portfolio Slideshow.",
						"icon" => true,
						"class" 	=>"hide_me admin_accord",
						"collapse"	=> true,
						"type" => "info");	
						
$of_options[] = array( 	"name" => "Portfolio Effect",
						"desc" => "",
						"id" => "rw_effect",
						"std" 		=> "scroll",
						"type" 		=> "select",
						"collapse_sec"	=> "portfolio_slide",
						"options" 	=> $of_options_effect
						);
						
$of_options[] = array( 	"name" => "Portfolio Autoplay Effect",
						"desc" => "",
						"id" => "rw_auto",
						"std" 		=> "false",
						"type" 		=> "select",
						"collapse_sec"	=> "portfolio_slide",
						"options" 	=> $of_options_autoplay
						);	
						
$of_options[] = array(  "name" =>  "Portfolio Transition Speed (miliseconds)",
						"desc" => "",
						"id" => "rw_speed",
						"std" 		=> "300",
						"min" 		=> "100",
						"step"		=> "100",
						"max" 		=> "1000",
						"collapse_sec"	=> "portfolio_slide",
						"type" 		=> "sliderui");	
						
$of_options[] = array(  "name" =>  "Portfolio Pause Time (seconds)",
						"desc" => "",
						"id" => "rw_pause",
						"std" 		=> "3",
						"min" 		=> "1",
						"step"		=> "1",
						"max" 		=> "30",
						"collapse_sec"	=> "portfolio_slide",
						"type" 		=> "sliderui");											

$of_options[] = array( 	"name" 		=> "WooCommerce",
						"type" 		=> "heading"
				);
				
$of_options[] = array(  "name" => "WooCommerce Shop Page",
						"desc" => "",
						"id" => "woo_shop_page",
						"std" => "<h3 style='margin: 0;'>WooCommerce Shop Page</h3>Use the settings bellow to customize the functionality of your shop page.",
						"icon" => true,
						"type" => "info");
						
$of_options[] = array(  "name" => "Enable Sidebar",
						"desc" => "Enable/disable sidebar on your shop page.",
						"id" => "shop_sidebar",
						"std" => 0,
						"folds" => 1,
						"type" => "switch");
						
$of_options[] = array( "name" => "Woocommerce Archive/Category Sidebar",
						"desc" => "Select the sidebar that will be added to the archive/category pages.",
						"id" => "woocommerce_archive_sidebar",
						"std" => "None",
						"type" => "select",
						"options" => $sidebar_options
					);						
						
$of_options[] = array(  "name" =>  "Products per page",
						"desc" => "Select how many products you want to list on your pages.",
						"id" => "shop_prod_number",
						"std" 		=> "10",
						"min" 		=> "3",
						"step"		=> "1",
						"max" 		=> "40",
						"type" 		=> "sliderui");

$of_options[] = array( 	"name" => "Products Thumbnail Size",
						"desc" => "Choose the Thumbnail Size used for WooCommerce products on Shop, Archives and Related Products.",
						"id" => "woocommerce_catalog_thumb",
						"std" 		=> "theme",
						"type" 		=> "select",
						//"collapse_sec"	=> "portfolio_sett",
						"options" => array(						
							'theme' => 'Theme Generated',
							'full' => 'Full Image',
						));								
						
					
$of_options[] = array(  "name" =>  "WooCommerce Sale Tag",
						"desc" => "Select the color of the WooCommerce Sale Tag",
						"id" => "woo_sale_tag",
						"std" => "#f96e5b",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "WooCommerce Products Price",
						"desc" => "Select the color of the WooCommerce Products Price",
						"id" => "woo_prod_price",
						"std" => "#f96e5b",
						"type" => "color");	
						
$of_options[] = array(  "name" =>  "WooCommerce Products - Old Price",
						"desc" => "Select the color of the WooCommerce Products - Old Price",
						"id" => "woo_prod_old_price",
						"std" => "#c8c8c8",
						"type" => "color");																												

$of_options[] = array( 	"name" 		=> "Custom Css",
						"type" 		=> "heading"
				);

$of_options[] = array(  "name" => "Custom Css",
						"desc" => "",
						"id" => "custom_css_head",
						"std" => "<h3>Custom Css</h3>Use the textarea below to add custom css rules and modify the look of the Nimva theme.",
						"icon" => true,
						"type" => "info");

$of_options[] = array( 	//"name" 		=> "Custom CSS",
						//"desc" 		=> "Quickly add some CSS to your theme by adding it to this block.",
						"id" 		=> "custom_css_area",
						"std" 		=> "/* Add your custom css rules below */",
						"type" 		=> "textarea"
				);

$of_options[] = array( 	"name" 		=> "Contact Options",
						"type" 		=> "heading"
				);
$of_options[] = array( 	"name" 		=> "Contact Options",
						"desc" 		=> "",
						"id" 		=> "contact_sett",
						"std" 		=> "<h3>Contact Options</h3>",
						"icon" 		=> true,						
						"type" 		=> "info"
				);		
$of_options[] = array(  "name" => "Google Map API Key",
						"desc" => "If you are experiencing issues with your Google Maps, please create your own unique API key and use it here.<br>To create an API key follow the steps below: <br>1. Go to the Google Developers Console <a href=\"https://console.developers.google.com/flows/enableapi?apiid=maps_backend,geocoding_backend,directions_backend,distance_matrix_backend,elevation_backend&keyType=CLIENT_SIDE&reusekey=true\" target=\"_blank\">here</a> and login with your google account.<br>
2. Create or select a project.<br>
3. Click Continue to enable the API and any related services.<br>
4. On the Credentials page, get a Browser key (and set the API Credentials). 
Note: If you have an existing Browser key, you may use that key.<br>

After creating the Api key, you will have a code similar to: AIzaSyBA0nEHL7AlN-lxEs7hCacsqwN4Y39Dnlg - paste that code in the field to the left.",
						"id" => "gmap_api",
						"std" => "",
						"type" => "text");
				
$of_options[] = array(  "name" => "Google Map Type",
						"desc" => "Select the type of map to show on google map",
						"id" => "gmap_type",
						"std" => "roadmap",
						"options" => array('roadmap' => 'ROADMAP', 'satellite' => 'SATELLITE', 'hybrid' => 'HYBRID', 'terrain' => 'TERRAIN'),
						"type" => "select");

$of_options[] = array(  "name" => "Google Map Width",
						"desc" => "(in pixels or percentage, e.g.:100% or 100px)",
						"id" => "gmap_width",
						"std" => "100%",
						"type" => "text");

$of_options[] = array(  "name" => "Google Map Height",
						"desc" => "(in pixels, e.g.: 100px)",
						"id" => "gmap_height",
						"std" => "400px",
						"type" => "text");
						
$of_options[] = array(  "name" => "Google Map PopUp Title",
						"desc" => "Example: We are RockyThemes",
						"id" => "gmap_title",
						"std" => "We are <span>RockyThemes</span>",
						"type" => "text");	
						
$of_options[] = array(  "name" => "Google Map PopUp Short Message",
						"desc" => "",
						"id" => "gmap_desc",
						"std" => "Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Praesent commodo cursus magna, vel scelerisque nisl consectetur et.",
						"type" => "textarea");											

$of_options[] = array(  "name" => "Google Map Address",
						"desc" => "Example: 775 New York Ave, Brooklyn, New York 11203. ",
						"id" => "gmap_address",
						"std" => "",
						"type" => "text");

$of_options[] = array(  "name" => "Google Map Email Address",
						"desc" => "Enter your contact email.",
						"id" => "gmap_email",
						"std" => "hello@yoursite.com",
						"type" => "text");
						

$of_options[] = array(  "name" => "Google Map Phone Number",
						"desc" => "Enter your contact phone number.",
						"id" => "gmap_phone",
						"std" => "1.555.800.800",
						"type" => "text");						

$of_options[] = array(  "name" => "Map Zoom Level",
						"desc" => "Higher number will be more zoomed in",
						"id" => "map_zoom_level",
						"std" => "16",
						"std" 		=> "16",
						"min" 		=> "1",
						"step"		=> "1",
						"max" 		=> "21",
						"type" 		=> "sliderui");	

$of_options[] = array(  "name" => "Disable Map Scrollwheel",
						"desc" => "Check to disable scrollwheel on google maps",
						"id" => "map_scrollwheel",
						"std" => 0,
						"type" => "checkbox");
/*
$of_options[] = array(  "name" => "Disable Map Scale",
						"desc" => "Check to disable scale on google maps",
						"id" => "map_scale",
						"std" => 0,
						"type" => "checkbox"); //asta am
*/
$of_options[] = array(  "name" => "Disable Map Zoom & Pan Control Icons",
						"desc" => "Check to disable zoom control icon and pan control icon on google maps",
						"id" => "map_zoomcontrol",
						"std" => 0,
						"type" => "checkbox");	
						
$of_options[] = array(  "name" => "Disable Map Type Control", //asta am
						"desc" => "Check to disable map type control on google maps",
						"id" => "map_type_control",
						"std" => 0,
						"type" => "checkbox");	
						
$of_options[] = array(  "name" => "Disable StreetView", //asta am
						"desc" => "Check to disable street view on google maps",
						"id" => "map_street",
						"std" => 0,
						"type" => "checkbox");														
				
$of_options[] = array( 	"name" 		=> "Docs and Videos",
						"type" 		=> "heading"
				);
				
$of_options[] = array( 	"name" 		=> "Online Documentation",
						"id" 		=> "on_doc",
						"std" 		=> "<h3 style=\"margin: 0;\">Online Documentation</h3>You can check out the Online Documentation of the Nimva theme here: <a href=\"http://rockythemes.com/nimva/doc/\" target=\"_blank\">http://rockythemes.com/nimva/doc/</a>",
						"type" 		=> "info",
						"desc" 		=> '',
				);	
				
$of_options[] = array( 	"name" 		=> "Narrated Video Tutorials",
						"id" 		=> "on_videos",
						"std" 		=> "<h3 style=\"margin: 0;\">Narrated Video Tutorials</h3>You can check out the Narrated Video Tutorials of the Nimva theme here: <a href=\"https://www.youtube.com/playlist?list=PLw5gDyOINzEwNI1z5l2GFdlgY1u9x_h5A\" target=\"_blank\">Youtube Videos</a>",
						"type" 		=> "info",
						"desc" 		=> '',
				);					
			
				
// Backup Options
$of_options[] = array( 	"name" 		=> "Backup Options",
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-slider.png"
				);
$of_options[] = array( 	"name" 		=> "Backup / Restore Options",
						"desc" 		=> "",
						"id" 		=> "bck_rest_sett",
						"std" 		=> "<h3>Backup / Restore Options</h3>",
						"icon" 		=> true,						
						"type" 		=> "info"
				);
$of_options[] = array( 	"name" 		=> "Backup and Restore Options",
						"id" 		=> "of_backup",
						"std" 		=> "",
						"type" 		=> "backup",
						"desc" 		=> 'You can use the two buttons below to backup your current options, and then restore it back at a later time. This is useful if you want to experiment on the options but would like to keep the old settings in case you need it back.',
				);
				
$of_options[] = array( 	"name" 		=> "Transfer Theme Options Data",
						"id" 		=> "of_transfer",
						"std" 		=> "",
						"type" 		=> "transfer",
						"desc" 		=> 'You can tranfer the saved options data between different installs by copying the text inside the text box. To import data from another install, replace the data in the text box with the one from another install and click "Import Options".',
				);
				
	}//End function: of_options()
}//End chack if function exists: of_options()
?>
